/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Region
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Region> {
    private static final SdkField<String> REGION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("regionName").getter(Region.getter(Region::regionName)).setter(Region.setter(Builder::regionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("regionName").build()}).build();
    private static final SdkField<String> REGION_NAME_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("regionNamePath").getter(Region.getter(Region::regionNamePath)).setter(Region.setter(Builder::regionNamePath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("regionNamePath").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGION_NAME_FIELD, REGION_NAME_PATH_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Region.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String regionName;
    private final String regionNamePath;
    private final Type type;

    private Region(BuilderImpl builder) {
        this.regionName = builder.regionName;
        this.regionNamePath = builder.regionNamePath;
        this.type = builder.type;
    }

    public final String regionName() {
        return this.regionName;
    }

    public final String regionNamePath() {
        return this.regionNamePath;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.regionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.regionNamePath());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Region)) {
            return false;
        }
        Region other = (Region)obj;
        return Objects.equals(this.regionName(), other.regionName()) && Objects.equals(this.regionNamePath(), other.regionNamePath());
    }

    public final String toString() {
        return ToString.builder((String)"Region").add("RegionName", (Object)this.regionName()).add("RegionNamePath", (Object)this.regionNamePath()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "regionName": {
                return Optional.ofNullable(clazz.cast(this.regionName()));
            }
            case "regionNamePath": {
                return Optional.ofNullable(clazz.cast(this.regionNamePath()));
            }
        }
        return Optional.empty();
    }

    public static Region fromRegionName(String regionName) {
        return (Region)Region.builder().regionName(regionName).build();
    }

    public static Region fromRegionNamePath(String regionNamePath) {
        return (Region)Region.builder().regionNamePath(regionNamePath).build();
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("regionName", REGION_NAME_FIELD);
        map.put("regionNamePath", REGION_NAME_PATH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Region, T> g) {
        return obj -> g.apply((Region)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        REGION_NAME,
        REGION_NAME_PATH,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private String regionName;
        private String regionNamePath;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(Region model) {
            this.regionName(model.regionName);
            this.regionNamePath(model.regionNamePath);
        }

        public final String getRegionName() {
            return this.regionName;
        }

        public final void setRegionName(String regionName) {
            String oldValue = this.regionName;
            this.regionName = regionName;
            this.handleUnionValueChange(Type.REGION_NAME, oldValue, this.regionName);
        }

        @Override
        public final Builder regionName(String regionName) {
            String oldValue = this.regionName;
            this.regionName = regionName;
            this.handleUnionValueChange(Type.REGION_NAME, oldValue, this.regionName);
            return this;
        }

        public final String getRegionNamePath() {
            return this.regionNamePath;
        }

        public final void setRegionNamePath(String regionNamePath) {
            String oldValue = this.regionNamePath;
            this.regionNamePath = regionNamePath;
            this.handleUnionValueChange(Type.REGION_NAME_PATH, oldValue, this.regionNamePath);
        }

        @Override
        public final Builder regionNamePath(String regionNamePath) {
            String oldValue = this.regionNamePath;
            this.regionNamePath = regionNamePath;
            this.handleUnionValueChange(Type.REGION_NAME_PATH, oldValue, this.regionNamePath);
            return this;
        }

        public Region build() {
            return new Region(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Region> {
        public Builder regionName(String var1);

        public Builder regionNamePath(String var1);
    }
}

