/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SubscriptionGrantStatus {
    GRANT_PENDING("GRANT_PENDING"),
    REVOKE_PENDING("REVOKE_PENDING"),
    GRANT_IN_PROGRESS("GRANT_IN_PROGRESS"),
    REVOKE_IN_PROGRESS("REVOKE_IN_PROGRESS"),
    GRANTED("GRANTED"),
    REVOKED("REVOKED"),
    GRANT_FAILED("GRANT_FAILED"),
    REVOKE_FAILED("REVOKE_FAILED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SubscriptionGrantStatus> VALUE_MAP;
    private final String value;

    private SubscriptionGrantStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SubscriptionGrantStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SubscriptionGrantStatus> knownValues() {
        EnumSet<SubscriptionGrantStatus> knownValues = EnumSet.allOf(SubscriptionGrantStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SubscriptionGrantStatus.class, SubscriptionGrantStatus::toString);
    }
}

