/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.datazone.model.GlueRunConfigurationInput;
import software.amazon.awssdk.services.datazone.model.RedshiftRunConfigurationInput;
import software.amazon.awssdk.services.datazone.model.SageMakerRunConfigurationInput;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataSourceConfigurationInput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataSourceConfigurationInput> {
    private static final SdkField<GlueRunConfigurationInput> GLUE_RUN_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("glueRunConfiguration").getter(DataSourceConfigurationInput.getter(DataSourceConfigurationInput::glueRunConfiguration)).setter(DataSourceConfigurationInput.setter(Builder::glueRunConfiguration)).constructor(GlueRunConfigurationInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("glueRunConfiguration").build()}).build();
    private static final SdkField<RedshiftRunConfigurationInput> REDSHIFT_RUN_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("redshiftRunConfiguration").getter(DataSourceConfigurationInput.getter(DataSourceConfigurationInput::redshiftRunConfiguration)).setter(DataSourceConfigurationInput.setter(Builder::redshiftRunConfiguration)).constructor(RedshiftRunConfigurationInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("redshiftRunConfiguration").build()}).build();
    private static final SdkField<SageMakerRunConfigurationInput> SAGE_MAKER_RUN_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sageMakerRunConfiguration").getter(DataSourceConfigurationInput.getter(DataSourceConfigurationInput::sageMakerRunConfiguration)).setter(DataSourceConfigurationInput.setter(Builder::sageMakerRunConfiguration)).constructor(SageMakerRunConfigurationInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sageMakerRunConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GLUE_RUN_CONFIGURATION_FIELD, REDSHIFT_RUN_CONFIGURATION_FIELD, SAGE_MAKER_RUN_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DataSourceConfigurationInput.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final GlueRunConfigurationInput glueRunConfiguration;
    private final RedshiftRunConfigurationInput redshiftRunConfiguration;
    private final SageMakerRunConfigurationInput sageMakerRunConfiguration;
    private final Type type;

    private DataSourceConfigurationInput(BuilderImpl builder) {
        this.glueRunConfiguration = builder.glueRunConfiguration;
        this.redshiftRunConfiguration = builder.redshiftRunConfiguration;
        this.sageMakerRunConfiguration = builder.sageMakerRunConfiguration;
        this.type = builder.type;
    }

    public final GlueRunConfigurationInput glueRunConfiguration() {
        return this.glueRunConfiguration;
    }

    public final RedshiftRunConfigurationInput redshiftRunConfiguration() {
        return this.redshiftRunConfiguration;
    }

    public final SageMakerRunConfigurationInput sageMakerRunConfiguration() {
        return this.sageMakerRunConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.glueRunConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.redshiftRunConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.sageMakerRunConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataSourceConfigurationInput)) {
            return false;
        }
        DataSourceConfigurationInput other = (DataSourceConfigurationInput)obj;
        return Objects.equals(this.glueRunConfiguration(), other.glueRunConfiguration()) && Objects.equals(this.redshiftRunConfiguration(), other.redshiftRunConfiguration()) && Objects.equals(this.sageMakerRunConfiguration(), other.sageMakerRunConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"DataSourceConfigurationInput").add("GlueRunConfiguration", (Object)this.glueRunConfiguration()).add("RedshiftRunConfiguration", (Object)this.redshiftRunConfiguration()).add("SageMakerRunConfiguration", (Object)this.sageMakerRunConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "glueRunConfiguration": {
                return Optional.ofNullable(clazz.cast(this.glueRunConfiguration()));
            }
            case "redshiftRunConfiguration": {
                return Optional.ofNullable(clazz.cast(this.redshiftRunConfiguration()));
            }
            case "sageMakerRunConfiguration": {
                return Optional.ofNullable(clazz.cast(this.sageMakerRunConfiguration()));
            }
        }
        return Optional.empty();
    }

    public static DataSourceConfigurationInput fromGlueRunConfiguration(GlueRunConfigurationInput glueRunConfiguration) {
        return (DataSourceConfigurationInput)DataSourceConfigurationInput.builder().glueRunConfiguration(glueRunConfiguration).build();
    }

    public static DataSourceConfigurationInput fromGlueRunConfiguration(Consumer<GlueRunConfigurationInput.Builder> glueRunConfiguration) {
        GlueRunConfigurationInput.Builder builder = GlueRunConfigurationInput.builder();
        glueRunConfiguration.accept(builder);
        return DataSourceConfigurationInput.fromGlueRunConfiguration((GlueRunConfigurationInput)builder.build());
    }

    public static DataSourceConfigurationInput fromRedshiftRunConfiguration(RedshiftRunConfigurationInput redshiftRunConfiguration) {
        return (DataSourceConfigurationInput)DataSourceConfigurationInput.builder().redshiftRunConfiguration(redshiftRunConfiguration).build();
    }

    public static DataSourceConfigurationInput fromRedshiftRunConfiguration(Consumer<RedshiftRunConfigurationInput.Builder> redshiftRunConfiguration) {
        RedshiftRunConfigurationInput.Builder builder = RedshiftRunConfigurationInput.builder();
        redshiftRunConfiguration.accept(builder);
        return DataSourceConfigurationInput.fromRedshiftRunConfiguration((RedshiftRunConfigurationInput)builder.build());
    }

    public static DataSourceConfigurationInput fromSageMakerRunConfiguration(SageMakerRunConfigurationInput sageMakerRunConfiguration) {
        return (DataSourceConfigurationInput)DataSourceConfigurationInput.builder().sageMakerRunConfiguration(sageMakerRunConfiguration).build();
    }

    public static DataSourceConfigurationInput fromSageMakerRunConfiguration(Consumer<SageMakerRunConfigurationInput.Builder> sageMakerRunConfiguration) {
        SageMakerRunConfigurationInput.Builder builder = SageMakerRunConfigurationInput.builder();
        sageMakerRunConfiguration.accept(builder);
        return DataSourceConfigurationInput.fromSageMakerRunConfiguration((SageMakerRunConfigurationInput)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("glueRunConfiguration", GLUE_RUN_CONFIGURATION_FIELD);
        map.put("redshiftRunConfiguration", REDSHIFT_RUN_CONFIGURATION_FIELD);
        map.put("sageMakerRunConfiguration", SAGE_MAKER_RUN_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataSourceConfigurationInput, T> g) {
        return obj -> g.apply((DataSourceConfigurationInput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        GLUE_RUN_CONFIGURATION,
        REDSHIFT_RUN_CONFIGURATION,
        SAGE_MAKER_RUN_CONFIGURATION,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private GlueRunConfigurationInput glueRunConfiguration;
        private RedshiftRunConfigurationInput redshiftRunConfiguration;
        private SageMakerRunConfigurationInput sageMakerRunConfiguration;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(DataSourceConfigurationInput model) {
            this.glueRunConfiguration(model.glueRunConfiguration);
            this.redshiftRunConfiguration(model.redshiftRunConfiguration);
            this.sageMakerRunConfiguration(model.sageMakerRunConfiguration);
        }

        public final GlueRunConfigurationInput.Builder getGlueRunConfiguration() {
            return this.glueRunConfiguration != null ? this.glueRunConfiguration.toBuilder() : null;
        }

        public final void setGlueRunConfiguration(GlueRunConfigurationInput.BuilderImpl glueRunConfiguration) {
            GlueRunConfigurationInput oldValue = this.glueRunConfiguration;
            this.glueRunConfiguration = glueRunConfiguration != null ? glueRunConfiguration.build() : null;
            this.handleUnionValueChange(Type.GLUE_RUN_CONFIGURATION, oldValue, this.glueRunConfiguration);
        }

        @Override
        public final Builder glueRunConfiguration(GlueRunConfigurationInput glueRunConfiguration) {
            GlueRunConfigurationInput oldValue = this.glueRunConfiguration;
            this.glueRunConfiguration = glueRunConfiguration;
            this.handleUnionValueChange(Type.GLUE_RUN_CONFIGURATION, oldValue, this.glueRunConfiguration);
            return this;
        }

        public final RedshiftRunConfigurationInput.Builder getRedshiftRunConfiguration() {
            return this.redshiftRunConfiguration != null ? this.redshiftRunConfiguration.toBuilder() : null;
        }

        public final void setRedshiftRunConfiguration(RedshiftRunConfigurationInput.BuilderImpl redshiftRunConfiguration) {
            RedshiftRunConfigurationInput oldValue = this.redshiftRunConfiguration;
            this.redshiftRunConfiguration = redshiftRunConfiguration != null ? redshiftRunConfiguration.build() : null;
            this.handleUnionValueChange(Type.REDSHIFT_RUN_CONFIGURATION, oldValue, this.redshiftRunConfiguration);
        }

        @Override
        public final Builder redshiftRunConfiguration(RedshiftRunConfigurationInput redshiftRunConfiguration) {
            RedshiftRunConfigurationInput oldValue = this.redshiftRunConfiguration;
            this.redshiftRunConfiguration = redshiftRunConfiguration;
            this.handleUnionValueChange(Type.REDSHIFT_RUN_CONFIGURATION, oldValue, this.redshiftRunConfiguration);
            return this;
        }

        public final SageMakerRunConfigurationInput.Builder getSageMakerRunConfiguration() {
            return this.sageMakerRunConfiguration != null ? this.sageMakerRunConfiguration.toBuilder() : null;
        }

        public final void setSageMakerRunConfiguration(SageMakerRunConfigurationInput.BuilderImpl sageMakerRunConfiguration) {
            SageMakerRunConfigurationInput oldValue = this.sageMakerRunConfiguration;
            this.sageMakerRunConfiguration = sageMakerRunConfiguration != null ? sageMakerRunConfiguration.build() : null;
            this.handleUnionValueChange(Type.SAGE_MAKER_RUN_CONFIGURATION, oldValue, this.sageMakerRunConfiguration);
        }

        @Override
        public final Builder sageMakerRunConfiguration(SageMakerRunConfigurationInput sageMakerRunConfiguration) {
            SageMakerRunConfigurationInput oldValue = this.sageMakerRunConfiguration;
            this.sageMakerRunConfiguration = sageMakerRunConfiguration;
            this.handleUnionValueChange(Type.SAGE_MAKER_RUN_CONFIGURATION, oldValue, this.sageMakerRunConfiguration);
            return this;
        }

        public DataSourceConfigurationInput build() {
            return new DataSourceConfigurationInput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataSourceConfigurationInput> {
        public Builder glueRunConfiguration(GlueRunConfigurationInput var1);

        default public Builder glueRunConfiguration(Consumer<GlueRunConfigurationInput.Builder> glueRunConfiguration) {
            return this.glueRunConfiguration((GlueRunConfigurationInput)((GlueRunConfigurationInput.Builder)GlueRunConfigurationInput.builder().applyMutation(glueRunConfiguration)).build());
        }

        public Builder redshiftRunConfiguration(RedshiftRunConfigurationInput var1);

        default public Builder redshiftRunConfiguration(Consumer<RedshiftRunConfigurationInput.Builder> redshiftRunConfiguration) {
            return this.redshiftRunConfiguration((RedshiftRunConfigurationInput)((RedshiftRunConfigurationInput.Builder)RedshiftRunConfigurationInput.builder().applyMutation(redshiftRunConfiguration)).build());
        }

        public Builder sageMakerRunConfiguration(SageMakerRunConfigurationInput var1);

        default public Builder sageMakerRunConfiguration(Consumer<SageMakerRunConfigurationInput.Builder> sageMakerRunConfiguration) {
            return this.sageMakerRunConfiguration((SageMakerRunConfigurationInput)((SageMakerRunConfigurationInput.Builder)SageMakerRunConfigurationInput.builder().applyMutation(sageMakerRunConfiguration)).build());
        }
    }
}

