/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.datazone.model.RedshiftCredentials;
import software.amazon.awssdk.services.datazone.model.RedshiftLineageSyncConfigurationInput;
import software.amazon.awssdk.services.datazone.model.RedshiftStorageProperties;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RedshiftPropertiesPatch
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RedshiftPropertiesPatch> {
    private static final SdkField<RedshiftCredentials> CREDENTIALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("credentials").getter(RedshiftPropertiesPatch.getter(RedshiftPropertiesPatch::credentials)).setter(RedshiftPropertiesPatch.setter(Builder::credentials)).constructor(RedshiftCredentials::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("credentials").build()}).build();
    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("databaseName").getter(RedshiftPropertiesPatch.getter(RedshiftPropertiesPatch::databaseName)).setter(RedshiftPropertiesPatch.setter(Builder::databaseName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("databaseName").build()}).build();
    private static final SdkField<String> HOST_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("host").getter(RedshiftPropertiesPatch.getter(RedshiftPropertiesPatch::host)).setter(RedshiftPropertiesPatch.setter(Builder::host)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("host").build()}).build();
    private static final SdkField<RedshiftLineageSyncConfigurationInput> LINEAGE_SYNC_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("lineageSync").getter(RedshiftPropertiesPatch.getter(RedshiftPropertiesPatch::lineageSync)).setter(RedshiftPropertiesPatch.setter(Builder::lineageSync)).constructor(RedshiftLineageSyncConfigurationInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lineageSync").build()}).build();
    private static final SdkField<Integer> PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("port").getter(RedshiftPropertiesPatch.getter(RedshiftPropertiesPatch::port)).setter(RedshiftPropertiesPatch.setter(Builder::port)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("port").build()}).build();
    private static final SdkField<RedshiftStorageProperties> STORAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("storage").getter(RedshiftPropertiesPatch.getter(RedshiftPropertiesPatch::storage)).setter(RedshiftPropertiesPatch.setter(Builder::storage)).constructor(RedshiftStorageProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREDENTIALS_FIELD, DATABASE_NAME_FIELD, HOST_FIELD, LINEAGE_SYNC_FIELD, PORT_FIELD, STORAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RedshiftPropertiesPatch.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final RedshiftCredentials credentials;
    private final String databaseName;
    private final String host;
    private final RedshiftLineageSyncConfigurationInput lineageSync;
    private final Integer port;
    private final RedshiftStorageProperties storage;

    private RedshiftPropertiesPatch(BuilderImpl builder) {
        this.credentials = builder.credentials;
        this.databaseName = builder.databaseName;
        this.host = builder.host;
        this.lineageSync = builder.lineageSync;
        this.port = builder.port;
        this.storage = builder.storage;
    }

    public final RedshiftCredentials credentials() {
        return this.credentials;
    }

    public final String databaseName() {
        return this.databaseName;
    }

    public final String host() {
        return this.host;
    }

    public final RedshiftLineageSyncConfigurationInput lineageSync() {
        return this.lineageSync;
    }

    public final Integer port() {
        return this.port;
    }

    public final RedshiftStorageProperties storage() {
        return this.storage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.credentials());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(this.host());
        hashCode = 31 * hashCode + Objects.hashCode(this.lineageSync());
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.storage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RedshiftPropertiesPatch)) {
            return false;
        }
        RedshiftPropertiesPatch other = (RedshiftPropertiesPatch)obj;
        return Objects.equals(this.credentials(), other.credentials()) && Objects.equals(this.databaseName(), other.databaseName()) && Objects.equals(this.host(), other.host()) && Objects.equals(this.lineageSync(), other.lineageSync()) && Objects.equals(this.port(), other.port()) && Objects.equals(this.storage(), other.storage());
    }

    public final String toString() {
        return ToString.builder((String)"RedshiftPropertiesPatch").add("Credentials", (Object)(this.credentials() == null ? null : "*** Sensitive Data Redacted ***")).add("DatabaseName", (Object)this.databaseName()).add("Host", (Object)this.host()).add("LineageSync", (Object)this.lineageSync()).add("Port", (Object)this.port()).add("Storage", (Object)this.storage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "credentials": {
                return Optional.ofNullable(clazz.cast(this.credentials()));
            }
            case "databaseName": {
                return Optional.ofNullable(clazz.cast(this.databaseName()));
            }
            case "host": {
                return Optional.ofNullable(clazz.cast(this.host()));
            }
            case "lineageSync": {
                return Optional.ofNullable(clazz.cast(this.lineageSync()));
            }
            case "port": {
                return Optional.ofNullable(clazz.cast(this.port()));
            }
            case "storage": {
                return Optional.ofNullable(clazz.cast(this.storage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("credentials", CREDENTIALS_FIELD);
        map.put("databaseName", DATABASE_NAME_FIELD);
        map.put("host", HOST_FIELD);
        map.put("lineageSync", LINEAGE_SYNC_FIELD);
        map.put("port", PORT_FIELD);
        map.put("storage", STORAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RedshiftPropertiesPatch, T> g) {
        return obj -> g.apply((RedshiftPropertiesPatch)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private RedshiftCredentials credentials;
        private String databaseName;
        private String host;
        private RedshiftLineageSyncConfigurationInput lineageSync;
        private Integer port;
        private RedshiftStorageProperties storage;

        private BuilderImpl() {
        }

        private BuilderImpl(RedshiftPropertiesPatch model) {
            this.credentials(model.credentials);
            this.databaseName(model.databaseName);
            this.host(model.host);
            this.lineageSync(model.lineageSync);
            this.port(model.port);
            this.storage(model.storage);
        }

        public final RedshiftCredentials.Builder getCredentials() {
            return this.credentials != null ? this.credentials.toBuilder() : null;
        }

        public final void setCredentials(RedshiftCredentials.BuilderImpl credentials) {
            this.credentials = credentials != null ? credentials.build() : null;
        }

        @Override
        public final Builder credentials(RedshiftCredentials credentials) {
            this.credentials = credentials;
            return this;
        }

        public final String getDatabaseName() {
            return this.databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final String getHost() {
            return this.host;
        }

        public final void setHost(String host) {
            this.host = host;
        }

        @Override
        public final Builder host(String host) {
            this.host = host;
            return this;
        }

        public final RedshiftLineageSyncConfigurationInput.Builder getLineageSync() {
            return this.lineageSync != null ? this.lineageSync.toBuilder() : null;
        }

        public final void setLineageSync(RedshiftLineageSyncConfigurationInput.BuilderImpl lineageSync) {
            this.lineageSync = lineageSync != null ? lineageSync.build() : null;
        }

        @Override
        public final Builder lineageSync(RedshiftLineageSyncConfigurationInput lineageSync) {
            this.lineageSync = lineageSync;
            return this;
        }

        public final Integer getPort() {
            return this.port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final RedshiftStorageProperties.Builder getStorage() {
            return this.storage != null ? this.storage.toBuilder() : null;
        }

        public final void setStorage(RedshiftStorageProperties.BuilderImpl storage) {
            this.storage = storage != null ? storage.build() : null;
        }

        @Override
        public final Builder storage(RedshiftStorageProperties storage) {
            this.storage = storage;
            return this;
        }

        public RedshiftPropertiesPatch build() {
            return new RedshiftPropertiesPatch(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RedshiftPropertiesPatch> {
        public Builder credentials(RedshiftCredentials var1);

        default public Builder credentials(Consumer<RedshiftCredentials.Builder> credentials) {
            return this.credentials((RedshiftCredentials)((RedshiftCredentials.Builder)RedshiftCredentials.builder().applyMutation(credentials)).build());
        }

        public Builder databaseName(String var1);

        public Builder host(String var1);

        public Builder lineageSync(RedshiftLineageSyncConfigurationInput var1);

        default public Builder lineageSync(Consumer<RedshiftLineageSyncConfigurationInput.Builder> lineageSync) {
            return this.lineageSync((RedshiftLineageSyncConfigurationInput)((RedshiftLineageSyncConfigurationInput.Builder)RedshiftLineageSyncConfigurationInput.builder().applyMutation(lineageSync)).build());
        }

        public Builder port(Integer var1);

        public Builder storage(RedshiftStorageProperties var1);

        default public Builder storage(Consumer<RedshiftStorageProperties.Builder> storage) {
            return this.storage((RedshiftStorageProperties)((RedshiftStorageProperties.Builder)RedshiftStorageProperties.builder().applyMutation(storage)).build());
        }
    }
}

