/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.datazone.DataZoneAsyncClient;
import software.amazon.awssdk.services.datazone.internal.UserAgentUtils;
import software.amazon.awssdk.services.datazone.model.LineageEventSummary;
import software.amazon.awssdk.services.datazone.model.ListLineageEventsRequest;
import software.amazon.awssdk.services.datazone.model.ListLineageEventsResponse;

public class ListLineageEventsPublisher
implements SdkPublisher<ListLineageEventsResponse> {
    private final DataZoneAsyncClient client;
    private final ListLineageEventsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListLineageEventsPublisher(DataZoneAsyncClient client, ListLineageEventsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListLineageEventsPublisher(DataZoneAsyncClient client, ListLineageEventsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListLineageEventsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListLineageEventsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<LineageEventSummary> items() {
        Function<ListLineageEventsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListLineageEventsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListLineageEventsResponseFetcher
    implements AsyncPageFetcher<ListLineageEventsResponse> {
        private ListLineageEventsResponseFetcher() {
        }

        public boolean hasNextPage(ListLineageEventsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListLineageEventsResponse> nextPage(ListLineageEventsResponse previousPage) {
            if (previousPage == null) {
                return ListLineageEventsPublisher.this.client.listLineageEvents(ListLineageEventsPublisher.this.firstRequest);
            }
            return ListLineageEventsPublisher.this.client.listLineageEvents((ListLineageEventsRequest)((Object)ListLineageEventsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

