/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datazone.model.DetailedGlossaryTerm;
import software.amazon.awssdk.services.datazone.model.DetailedGlossaryTermsCopier;
import software.amazon.awssdk.services.datazone.model.ListingSummariesCopier;
import software.amazon.awssdk.services.datazone.model.ListingSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataProductListing
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataProductListing> {
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(DataProductListing.getter(DataProductListing::createdAt)).setter(DataProductListing.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<String> DATA_PRODUCT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dataProductId").getter(DataProductListing.getter(DataProductListing::dataProductId)).setter(DataProductListing.setter(Builder::dataProductId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataProductId").build()}).build();
    private static final SdkField<String> DATA_PRODUCT_REVISION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dataProductRevision").getter(DataProductListing.getter(DataProductListing::dataProductRevision)).setter(DataProductListing.setter(Builder::dataProductRevision)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataProductRevision").build()}).build();
    private static final SdkField<String> FORMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("forms").getter(DataProductListing.getter(DataProductListing::forms)).setter(DataProductListing.setter(Builder::forms)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("forms").build()}).build();
    private static final SdkField<List<DetailedGlossaryTerm>> GLOSSARY_TERMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("glossaryTerms").getter(DataProductListing.getter(DataProductListing::glossaryTerms)).setter(DataProductListing.setter(Builder::glossaryTerms)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("glossaryTerms").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DetailedGlossaryTerm::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ListingSummary>> ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("items").getter(DataProductListing.getter(DataProductListing::items)).setter(DataProductListing.setter(Builder::items)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("items").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ListingSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> OWNING_PROJECT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("owningProjectId").getter(DataProductListing.getter(DataProductListing::owningProjectId)).setter(DataProductListing.setter(Builder::owningProjectId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("owningProjectId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AT_FIELD, DATA_PRODUCT_ID_FIELD, DATA_PRODUCT_REVISION_FIELD, FORMS_FIELD, GLOSSARY_TERMS_FIELD, ITEMS_FIELD, OWNING_PROJECT_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DataProductListing.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Instant createdAt;
    private final String dataProductId;
    private final String dataProductRevision;
    private final String forms;
    private final List<DetailedGlossaryTerm> glossaryTerms;
    private final List<ListingSummary> items;
    private final String owningProjectId;

    private DataProductListing(BuilderImpl builder) {
        this.createdAt = builder.createdAt;
        this.dataProductId = builder.dataProductId;
        this.dataProductRevision = builder.dataProductRevision;
        this.forms = builder.forms;
        this.glossaryTerms = builder.glossaryTerms;
        this.items = builder.items;
        this.owningProjectId = builder.owningProjectId;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String dataProductId() {
        return this.dataProductId;
    }

    public final String dataProductRevision() {
        return this.dataProductRevision;
    }

    public final String forms() {
        return this.forms;
    }

    public final boolean hasGlossaryTerms() {
        return this.glossaryTerms != null && !(this.glossaryTerms instanceof SdkAutoConstructList);
    }

    public final List<DetailedGlossaryTerm> glossaryTerms() {
        return this.glossaryTerms;
    }

    public final boolean hasItems() {
        return this.items != null && !(this.items instanceof SdkAutoConstructList);
    }

    public final List<ListingSummary> items() {
        return this.items;
    }

    public final String owningProjectId() {
        return this.owningProjectId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataProductId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataProductRevision());
        hashCode = 31 * hashCode + Objects.hashCode(this.forms());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGlossaryTerms() ? this.glossaryTerms() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasItems() ? this.items() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.owningProjectId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataProductListing)) {
            return false;
        }
        DataProductListing other = (DataProductListing)obj;
        return Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.dataProductId(), other.dataProductId()) && Objects.equals(this.dataProductRevision(), other.dataProductRevision()) && Objects.equals(this.forms(), other.forms()) && this.hasGlossaryTerms() == other.hasGlossaryTerms() && Objects.equals(this.glossaryTerms(), other.glossaryTerms()) && this.hasItems() == other.hasItems() && Objects.equals(this.items(), other.items()) && Objects.equals(this.owningProjectId(), other.owningProjectId());
    }

    public final String toString() {
        return ToString.builder((String)"DataProductListing").add("CreatedAt", (Object)this.createdAt()).add("DataProductId", (Object)this.dataProductId()).add("DataProductRevision", (Object)this.dataProductRevision()).add("Forms", (Object)this.forms()).add("GlossaryTerms", this.hasGlossaryTerms() ? this.glossaryTerms() : null).add("Items", this.hasItems() ? this.items() : null).add("OwningProjectId", (Object)this.owningProjectId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "dataProductId": {
                return Optional.ofNullable(clazz.cast(this.dataProductId()));
            }
            case "dataProductRevision": {
                return Optional.ofNullable(clazz.cast(this.dataProductRevision()));
            }
            case "forms": {
                return Optional.ofNullable(clazz.cast(this.forms()));
            }
            case "glossaryTerms": {
                return Optional.ofNullable(clazz.cast(this.glossaryTerms()));
            }
            case "items": {
                return Optional.ofNullable(clazz.cast(this.items()));
            }
            case "owningProjectId": {
                return Optional.ofNullable(clazz.cast(this.owningProjectId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("dataProductId", DATA_PRODUCT_ID_FIELD);
        map.put("dataProductRevision", DATA_PRODUCT_REVISION_FIELD);
        map.put("forms", FORMS_FIELD);
        map.put("glossaryTerms", GLOSSARY_TERMS_FIELD);
        map.put("items", ITEMS_FIELD);
        map.put("owningProjectId", OWNING_PROJECT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataProductListing, T> g) {
        return obj -> g.apply((DataProductListing)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant createdAt;
        private String dataProductId;
        private String dataProductRevision;
        private String forms;
        private List<DetailedGlossaryTerm> glossaryTerms = DefaultSdkAutoConstructList.getInstance();
        private List<ListingSummary> items = DefaultSdkAutoConstructList.getInstance();
        private String owningProjectId;

        private BuilderImpl() {
        }

        private BuilderImpl(DataProductListing model) {
            this.createdAt(model.createdAt);
            this.dataProductId(model.dataProductId);
            this.dataProductRevision(model.dataProductRevision);
            this.forms(model.forms);
            this.glossaryTerms(model.glossaryTerms);
            this.items(model.items);
            this.owningProjectId(model.owningProjectId);
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getDataProductId() {
            return this.dataProductId;
        }

        public final void setDataProductId(String dataProductId) {
            this.dataProductId = dataProductId;
        }

        @Override
        public final Builder dataProductId(String dataProductId) {
            this.dataProductId = dataProductId;
            return this;
        }

        public final String getDataProductRevision() {
            return this.dataProductRevision;
        }

        public final void setDataProductRevision(String dataProductRevision) {
            this.dataProductRevision = dataProductRevision;
        }

        @Override
        public final Builder dataProductRevision(String dataProductRevision) {
            this.dataProductRevision = dataProductRevision;
            return this;
        }

        public final String getForms() {
            return this.forms;
        }

        public final void setForms(String forms) {
            this.forms = forms;
        }

        @Override
        public final Builder forms(String forms) {
            this.forms = forms;
            return this;
        }

        public final List<DetailedGlossaryTerm.Builder> getGlossaryTerms() {
            List<DetailedGlossaryTerm.Builder> result = DetailedGlossaryTermsCopier.copyToBuilder(this.glossaryTerms);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGlossaryTerms(Collection<DetailedGlossaryTerm.BuilderImpl> glossaryTerms) {
            this.glossaryTerms = DetailedGlossaryTermsCopier.copyFromBuilder(glossaryTerms);
        }

        @Override
        public final Builder glossaryTerms(Collection<DetailedGlossaryTerm> glossaryTerms) {
            this.glossaryTerms = DetailedGlossaryTermsCopier.copy(glossaryTerms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder glossaryTerms(DetailedGlossaryTerm ... glossaryTerms) {
            this.glossaryTerms(Arrays.asList(glossaryTerms));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder glossaryTerms(Consumer<DetailedGlossaryTerm.Builder> ... glossaryTerms) {
            this.glossaryTerms(Stream.of(glossaryTerms).map(c -> (DetailedGlossaryTerm)((DetailedGlossaryTerm.Builder)DetailedGlossaryTerm.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ListingSummary.Builder> getItems() {
            List<ListingSummary.Builder> result = ListingSummariesCopier.copyToBuilder(this.items);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setItems(Collection<ListingSummary.BuilderImpl> items) {
            this.items = ListingSummariesCopier.copyFromBuilder(items);
        }

        @Override
        public final Builder items(Collection<ListingSummary> items) {
            this.items = ListingSummariesCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(ListingSummary ... items) {
            this.items(Arrays.asList(items));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(Consumer<ListingSummary.Builder> ... items) {
            this.items(Stream.of(items).map(c -> (ListingSummary)((ListingSummary.Builder)ListingSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getOwningProjectId() {
            return this.owningProjectId;
        }

        public final void setOwningProjectId(String owningProjectId) {
            this.owningProjectId = owningProjectId;
        }

        @Override
        public final Builder owningProjectId(String owningProjectId) {
            this.owningProjectId = owningProjectId;
            return this;
        }

        public DataProductListing build() {
            return new DataProductListing(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataProductListing> {
        public Builder createdAt(Instant var1);

        public Builder dataProductId(String var1);

        public Builder dataProductRevision(String var1);

        public Builder forms(String var1);

        public Builder glossaryTerms(Collection<DetailedGlossaryTerm> var1);

        public Builder glossaryTerms(DetailedGlossaryTerm ... var1);

        public Builder glossaryTerms(Consumer<DetailedGlossaryTerm.Builder> ... var1);

        public Builder items(Collection<ListingSummary> var1);

        public Builder items(ListingSummary ... var1);

        public Builder items(Consumer<ListingSummary.Builder> ... var1);

        public Builder owningProjectId(String var1);
    }
}

