/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.datazone.model.DataZoneResponse;
import software.amazon.awssdk.services.datazone.model.GlossaryTermStatus;
import software.amazon.awssdk.services.datazone.model.TermRelations;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateGlossaryTermResponse
extends DataZoneResponse
implements ToCopyableBuilder<Builder, UpdateGlossaryTermResponse> {
    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainId").getter(UpdateGlossaryTermResponse.getter(UpdateGlossaryTermResponse::domainId)).setter(UpdateGlossaryTermResponse.setter(Builder::domainId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainId").build()}).build();
    private static final SdkField<String> GLOSSARY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("glossaryId").getter(UpdateGlossaryTermResponse.getter(UpdateGlossaryTermResponse::glossaryId)).setter(UpdateGlossaryTermResponse.setter(Builder::glossaryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("glossaryId").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(UpdateGlossaryTermResponse.getter(UpdateGlossaryTermResponse::id)).setter(UpdateGlossaryTermResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> LONG_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("longDescription").getter(UpdateGlossaryTermResponse.getter(UpdateGlossaryTermResponse::longDescription)).setter(UpdateGlossaryTermResponse.setter(Builder::longDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("longDescription").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(UpdateGlossaryTermResponse.getter(UpdateGlossaryTermResponse::name)).setter(UpdateGlossaryTermResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> SHORT_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("shortDescription").getter(UpdateGlossaryTermResponse.getter(UpdateGlossaryTermResponse::shortDescription)).setter(UpdateGlossaryTermResponse.setter(Builder::shortDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shortDescription").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(UpdateGlossaryTermResponse.getter(UpdateGlossaryTermResponse::statusAsString)).setter(UpdateGlossaryTermResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<TermRelations> TERM_RELATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("termRelations").getter(UpdateGlossaryTermResponse.getter(UpdateGlossaryTermResponse::termRelations)).setter(UpdateGlossaryTermResponse.setter(Builder::termRelations)).constructor(TermRelations::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("termRelations").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_ID_FIELD, GLOSSARY_ID_FIELD, ID_FIELD, LONG_DESCRIPTION_FIELD, NAME_FIELD, SHORT_DESCRIPTION_FIELD, STATUS_FIELD, TERM_RELATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateGlossaryTermResponse.memberNameToFieldInitializer();
    private final String domainId;
    private final String glossaryId;
    private final String id;
    private final String longDescription;
    private final String name;
    private final String shortDescription;
    private final String status;
    private final TermRelations termRelations;

    private UpdateGlossaryTermResponse(BuilderImpl builder) {
        super(builder);
        this.domainId = builder.domainId;
        this.glossaryId = builder.glossaryId;
        this.id = builder.id;
        this.longDescription = builder.longDescription;
        this.name = builder.name;
        this.shortDescription = builder.shortDescription;
        this.status = builder.status;
        this.termRelations = builder.termRelations;
    }

    public final String domainId() {
        return this.domainId;
    }

    public final String glossaryId() {
        return this.glossaryId;
    }

    public final String id() {
        return this.id;
    }

    public final String longDescription() {
        return this.longDescription;
    }

    public final String name() {
        return this.name;
    }

    public final String shortDescription() {
        return this.shortDescription;
    }

    public final GlossaryTermStatus status() {
        return GlossaryTermStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final TermRelations termRelations() {
        return this.termRelations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domainId());
        hashCode = 31 * hashCode + Objects.hashCode(this.glossaryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.longDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.shortDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.termRelations());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateGlossaryTermResponse)) {
            return false;
        }
        UpdateGlossaryTermResponse other = (UpdateGlossaryTermResponse)((Object)obj);
        return Objects.equals(this.domainId(), other.domainId()) && Objects.equals(this.glossaryId(), other.glossaryId()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.longDescription(), other.longDescription()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.shortDescription(), other.shortDescription()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.termRelations(), other.termRelations());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateGlossaryTermResponse").add("DomainId", (Object)this.domainId()).add("GlossaryId", (Object)this.glossaryId()).add("Id", (Object)this.id()).add("LongDescription", (Object)(this.longDescription() == null ? null : "*** Sensitive Data Redacted ***")).add("Name", (Object)(this.name() == null ? null : "*** Sensitive Data Redacted ***")).add("ShortDescription", (Object)(this.shortDescription() == null ? null : "*** Sensitive Data Redacted ***")).add("Status", (Object)this.statusAsString()).add("TermRelations", (Object)this.termRelations()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "domainId": {
                return Optional.ofNullable(clazz.cast(this.domainId()));
            }
            case "glossaryId": {
                return Optional.ofNullable(clazz.cast(this.glossaryId()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "longDescription": {
                return Optional.ofNullable(clazz.cast(this.longDescription()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "shortDescription": {
                return Optional.ofNullable(clazz.cast(this.shortDescription()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "termRelations": {
                return Optional.ofNullable(clazz.cast(this.termRelations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("domainId", DOMAIN_ID_FIELD);
        map.put("glossaryId", GLOSSARY_ID_FIELD);
        map.put("id", ID_FIELD);
        map.put("longDescription", LONG_DESCRIPTION_FIELD);
        map.put("name", NAME_FIELD);
        map.put("shortDescription", SHORT_DESCRIPTION_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("termRelations", TERM_RELATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateGlossaryTermResponse, T> g) {
        return obj -> g.apply((UpdateGlossaryTermResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataZoneResponse.BuilderImpl
    implements Builder {
        private String domainId;
        private String glossaryId;
        private String id;
        private String longDescription;
        private String name;
        private String shortDescription;
        private String status;
        private TermRelations termRelations;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateGlossaryTermResponse model) {
            super(model);
            this.domainId(model.domainId);
            this.glossaryId(model.glossaryId);
            this.id(model.id);
            this.longDescription(model.longDescription);
            this.name(model.name);
            this.shortDescription(model.shortDescription);
            this.status(model.status);
            this.termRelations(model.termRelations);
        }

        public final String getDomainId() {
            return this.domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final String getGlossaryId() {
            return this.glossaryId;
        }

        public final void setGlossaryId(String glossaryId) {
            this.glossaryId = glossaryId;
        }

        @Override
        public final Builder glossaryId(String glossaryId) {
            this.glossaryId = glossaryId;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getLongDescription() {
            return this.longDescription;
        }

        public final void setLongDescription(String longDescription) {
            this.longDescription = longDescription;
        }

        @Override
        public final Builder longDescription(String longDescription) {
            this.longDescription = longDescription;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getShortDescription() {
            return this.shortDescription;
        }

        public final void setShortDescription(String shortDescription) {
            this.shortDescription = shortDescription;
        }

        @Override
        public final Builder shortDescription(String shortDescription) {
            this.shortDescription = shortDescription;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(GlossaryTermStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final TermRelations.Builder getTermRelations() {
            return this.termRelations != null ? this.termRelations.toBuilder() : null;
        }

        public final void setTermRelations(TermRelations.BuilderImpl termRelations) {
            this.termRelations = termRelations != null ? termRelations.build() : null;
        }

        @Override
        public final Builder termRelations(TermRelations termRelations) {
            this.termRelations = termRelations;
            return this;
        }

        @Override
        public UpdateGlossaryTermResponse build() {
            return new UpdateGlossaryTermResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DataZoneResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateGlossaryTermResponse> {
        public Builder domainId(String var1);

        public Builder glossaryId(String var1);

        public Builder id(String var1);

        public Builder longDescription(String var1);

        public Builder name(String var1);

        public Builder shortDescription(String var1);

        public Builder status(String var1);

        public Builder status(GlossaryTermStatus var1);

        public Builder termRelations(TermRelations var1);

        default public Builder termRelations(Consumer<TermRelations.Builder> termRelations) {
            return this.termRelations((TermRelations)((TermRelations.Builder)TermRelations.builder().applyMutation(termRelations)).build());
        }
    }
}

