/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.datazone.model.SubscribedProject;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SubscribedPrincipal
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SubscribedPrincipal> {
    private static final SdkField<SubscribedProject> PROJECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("project").getter(SubscribedPrincipal.getter(SubscribedPrincipal::project)).setter(SubscribedPrincipal.setter(Builder::project)).constructor(SubscribedProject::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("project").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SubscribedPrincipal.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final SubscribedProject project;
    private final Type type;

    private SubscribedPrincipal(BuilderImpl builder) {
        this.project = builder.project;
        this.type = builder.type;
    }

    public final SubscribedProject project() {
        return this.project;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.project());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubscribedPrincipal)) {
            return false;
        }
        SubscribedPrincipal other = (SubscribedPrincipal)obj;
        return Objects.equals(this.project(), other.project());
    }

    public final String toString() {
        return ToString.builder((String)"SubscribedPrincipal").add("Project", (Object)this.project()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "project": {
                return Optional.ofNullable(clazz.cast(this.project()));
            }
        }
        return Optional.empty();
    }

    public static SubscribedPrincipal fromProject(SubscribedProject project) {
        return (SubscribedPrincipal)SubscribedPrincipal.builder().project(project).build();
    }

    public static SubscribedPrincipal fromProject(Consumer<SubscribedProject.Builder> project) {
        SubscribedProject.Builder builder = SubscribedProject.builder();
        project.accept(builder);
        return SubscribedPrincipal.fromProject((SubscribedProject)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<SubscribedProject>> map = new HashMap<String, SdkField<SubscribedProject>>();
        map.put("project", PROJECT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SubscribedPrincipal, T> g) {
        return obj -> g.apply((SubscribedPrincipal)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        PROJECT,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private SubscribedProject project;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(SubscribedPrincipal model) {
            this.project(model.project);
        }

        public final SubscribedProject.Builder getProject() {
            return this.project != null ? this.project.toBuilder() : null;
        }

        public final void setProject(SubscribedProject.BuilderImpl project) {
            SubscribedProject oldValue = this.project;
            this.project = project != null ? project.build() : null;
            this.handleUnionValueChange(Type.PROJECT, oldValue, this.project);
        }

        @Override
        public final Builder project(SubscribedProject project) {
            SubscribedProject oldValue = this.project;
            this.project = project;
            this.handleUnionValueChange(Type.PROJECT, oldValue, this.project);
            return this;
        }

        public SubscribedPrincipal build() {
            return new SubscribedPrincipal(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SubscribedPrincipal> {
        public Builder project(SubscribedProject var1);

        default public Builder project(Consumer<SubscribedProject.Builder> project) {
            return this.project((SubscribedProject)((SubscribedProject.Builder)SubscribedProject.builder().applyMutation(project)).build());
        }
    }
}

