/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datazone.model.EnvironmentParameter;
import software.amazon.awssdk.services.datazone.model.EnvironmentParametersListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EnvironmentConfigurationUserParameter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EnvironmentConfigurationUserParameter> {
    private static final SdkField<String> ENVIRONMENT_CONFIGURATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("environmentConfigurationName").getter(EnvironmentConfigurationUserParameter.getter(EnvironmentConfigurationUserParameter::environmentConfigurationName)).setter(EnvironmentConfigurationUserParameter.setter(Builder::environmentConfigurationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentConfigurationName").build()}).build();
    private static final SdkField<List<EnvironmentParameter>> ENVIRONMENT_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("environmentParameters").getter(EnvironmentConfigurationUserParameter.getter(EnvironmentConfigurationUserParameter::environmentParameters)).setter(EnvironmentConfigurationUserParameter.setter(Builder::environmentParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentParameters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EnvironmentParameter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENVIRONMENT_CONFIGURATION_NAME_FIELD, ENVIRONMENT_PARAMETERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EnvironmentConfigurationUserParameter.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String environmentConfigurationName;
    private final List<EnvironmentParameter> environmentParameters;

    private EnvironmentConfigurationUserParameter(BuilderImpl builder) {
        this.environmentConfigurationName = builder.environmentConfigurationName;
        this.environmentParameters = builder.environmentParameters;
    }

    public final String environmentConfigurationName() {
        return this.environmentConfigurationName;
    }

    public final boolean hasEnvironmentParameters() {
        return this.environmentParameters != null && !(this.environmentParameters instanceof SdkAutoConstructList);
    }

    public final List<EnvironmentParameter> environmentParameters() {
        return this.environmentParameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentConfigurationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEnvironmentParameters() ? this.environmentParameters() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnvironmentConfigurationUserParameter)) {
            return false;
        }
        EnvironmentConfigurationUserParameter other = (EnvironmentConfigurationUserParameter)obj;
        return Objects.equals(this.environmentConfigurationName(), other.environmentConfigurationName()) && this.hasEnvironmentParameters() == other.hasEnvironmentParameters() && Objects.equals(this.environmentParameters(), other.environmentParameters());
    }

    public final String toString() {
        return ToString.builder((String)"EnvironmentConfigurationUserParameter").add("EnvironmentConfigurationName", (Object)(this.environmentConfigurationName() == null ? null : "*** Sensitive Data Redacted ***")).add("EnvironmentParameters", this.hasEnvironmentParameters() ? this.environmentParameters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "environmentConfigurationName": {
                return Optional.ofNullable(clazz.cast(this.environmentConfigurationName()));
            }
            case "environmentParameters": {
                return Optional.ofNullable(clazz.cast(this.environmentParameters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("environmentConfigurationName", ENVIRONMENT_CONFIGURATION_NAME_FIELD);
        map.put("environmentParameters", ENVIRONMENT_PARAMETERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EnvironmentConfigurationUserParameter, T> g) {
        return obj -> g.apply((EnvironmentConfigurationUserParameter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String environmentConfigurationName;
        private List<EnvironmentParameter> environmentParameters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EnvironmentConfigurationUserParameter model) {
            this.environmentConfigurationName(model.environmentConfigurationName);
            this.environmentParameters(model.environmentParameters);
        }

        public final String getEnvironmentConfigurationName() {
            return this.environmentConfigurationName;
        }

        public final void setEnvironmentConfigurationName(String environmentConfigurationName) {
            this.environmentConfigurationName = environmentConfigurationName;
        }

        @Override
        public final Builder environmentConfigurationName(String environmentConfigurationName) {
            this.environmentConfigurationName = environmentConfigurationName;
            return this;
        }

        public final List<EnvironmentParameter.Builder> getEnvironmentParameters() {
            List<EnvironmentParameter.Builder> result = EnvironmentParametersListCopier.copyToBuilder(this.environmentParameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEnvironmentParameters(Collection<EnvironmentParameter.BuilderImpl> environmentParameters) {
            this.environmentParameters = EnvironmentParametersListCopier.copyFromBuilder(environmentParameters);
        }

        @Override
        public final Builder environmentParameters(Collection<EnvironmentParameter> environmentParameters) {
            this.environmentParameters = EnvironmentParametersListCopier.copy(environmentParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environmentParameters(EnvironmentParameter ... environmentParameters) {
            this.environmentParameters(Arrays.asList(environmentParameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environmentParameters(Consumer<EnvironmentParameter.Builder> ... environmentParameters) {
            this.environmentParameters(Stream.of(environmentParameters).map(c -> (EnvironmentParameter)((EnvironmentParameter.Builder)EnvironmentParameter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public EnvironmentConfigurationUserParameter build() {
            return new EnvironmentConfigurationUserParameter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EnvironmentConfigurationUserParameter> {
        public Builder environmentConfigurationName(String var1);

        public Builder environmentParameters(Collection<EnvironmentParameter> var1);

        public Builder environmentParameters(EnvironmentParameter ... var1);

        public Builder environmentParameters(Consumer<EnvironmentParameter.Builder> ... var1);
    }
}

