/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.datazone.model.SubscribedProjectInput;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SubscribedPrincipalInput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SubscribedPrincipalInput> {
    private static final SdkField<SubscribedProjectInput> PROJECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("project").getter(SubscribedPrincipalInput.getter(SubscribedPrincipalInput::project)).setter(SubscribedPrincipalInput.setter(Builder::project)).constructor(SubscribedProjectInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("project").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("project", PROJECT_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final SubscribedProjectInput project;
    private final Type type;

    private SubscribedPrincipalInput(BuilderImpl builder) {
        this.project = builder.project;
        this.type = builder.type;
    }

    public final SubscribedProjectInput project() {
        return this.project;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.project());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubscribedPrincipalInput)) {
            return false;
        }
        SubscribedPrincipalInput other = (SubscribedPrincipalInput)obj;
        return Objects.equals(this.project(), other.project());
    }

    public final String toString() {
        return ToString.builder((String)"SubscribedPrincipalInput").add("Project", (Object)this.project()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "project": {
                return Optional.ofNullable(clazz.cast(this.project()));
            }
        }
        return Optional.empty();
    }

    public static SubscribedPrincipalInput fromProject(SubscribedProjectInput project) {
        return (SubscribedPrincipalInput)SubscribedPrincipalInput.builder().project(project).build();
    }

    public static SubscribedPrincipalInput fromProject(Consumer<SubscribedProjectInput.Builder> project) {
        SubscribedProjectInput.Builder builder = SubscribedProjectInput.builder();
        project.accept(builder);
        return SubscribedPrincipalInput.fromProject((SubscribedProjectInput)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SubscribedPrincipalInput, T> g) {
        return obj -> g.apply((SubscribedPrincipalInput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        PROJECT,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private SubscribedProjectInput project;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(SubscribedPrincipalInput model) {
            this.project(model.project);
        }

        public final SubscribedProjectInput.Builder getProject() {
            return this.project != null ? this.project.toBuilder() : null;
        }

        public final void setProject(SubscribedProjectInput.BuilderImpl project) {
            SubscribedProjectInput oldValue = this.project;
            this.project = project != null ? project.build() : null;
            this.handleUnionValueChange(Type.PROJECT, oldValue, this.project);
        }

        @Override
        public final Builder project(SubscribedProjectInput project) {
            SubscribedProjectInput oldValue = this.project;
            this.project = project;
            this.handleUnionValueChange(Type.PROJECT, oldValue, this.project);
            return this;
        }

        public SubscribedPrincipalInput build() {
            return new SubscribedPrincipalInput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SubscribedPrincipalInput> {
        public Builder project(SubscribedProjectInput var1);

        default public Builder project(Consumer<SubscribedProjectInput.Builder> project) {
            return this.project((SubscribedProjectInput)((SubscribedProjectInput.Builder)SubscribedProjectInput.builder().applyMutation(project)).build());
        }
    }
}

