/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.datazone.model.UsernamePassword;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RedshiftCredentials
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RedshiftCredentials> {
    private static final SdkField<String> SECRET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("secretArn").getter(RedshiftCredentials.getter(RedshiftCredentials::secretArn)).setter(RedshiftCredentials.setter(Builder::secretArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secretArn").build()}).build();
    private static final SdkField<UsernamePassword> USERNAME_PASSWORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("usernamePassword").getter(RedshiftCredentials.getter(RedshiftCredentials::usernamePassword)).setter(RedshiftCredentials.setter(Builder::usernamePassword)).constructor(UsernamePassword::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usernamePassword").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECRET_ARN_FIELD, USERNAME_PASSWORD_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("secretArn", SECRET_ARN_FIELD);
            this.put("usernamePassword", USERNAME_PASSWORD_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String secretArn;
    private final UsernamePassword usernamePassword;
    private final Type type;

    private RedshiftCredentials(BuilderImpl builder) {
        this.secretArn = builder.secretArn;
        this.usernamePassword = builder.usernamePassword;
        this.type = builder.type;
    }

    public final String secretArn() {
        return this.secretArn;
    }

    public final UsernamePassword usernamePassword() {
        return this.usernamePassword;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.secretArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.usernamePassword());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RedshiftCredentials)) {
            return false;
        }
        RedshiftCredentials other = (RedshiftCredentials)obj;
        return Objects.equals(this.secretArn(), other.secretArn()) && Objects.equals(this.usernamePassword(), other.usernamePassword());
    }

    public final String toString() {
        return ToString.builder((String)"RedshiftCredentials").add("SecretArn", (Object)this.secretArn()).add("UsernamePassword", (Object)(this.usernamePassword() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "secretArn": {
                return Optional.ofNullable(clazz.cast(this.secretArn()));
            }
            case "usernamePassword": {
                return Optional.ofNullable(clazz.cast(this.usernamePassword()));
            }
        }
        return Optional.empty();
    }

    public static RedshiftCredentials fromSecretArn(String secretArn) {
        return (RedshiftCredentials)RedshiftCredentials.builder().secretArn(secretArn).build();
    }

    public static RedshiftCredentials fromUsernamePassword(UsernamePassword usernamePassword) {
        return (RedshiftCredentials)RedshiftCredentials.builder().usernamePassword(usernamePassword).build();
    }

    public static RedshiftCredentials fromUsernamePassword(Consumer<UsernamePassword.Builder> usernamePassword) {
        UsernamePassword.Builder builder = UsernamePassword.builder();
        usernamePassword.accept(builder);
        return RedshiftCredentials.fromUsernamePassword((UsernamePassword)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<RedshiftCredentials, T> g) {
        return obj -> g.apply((RedshiftCredentials)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        SECRET_ARN,
        USERNAME_PASSWORD,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private String secretArn;
        private UsernamePassword usernamePassword;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(RedshiftCredentials model) {
            this.secretArn(model.secretArn);
            this.usernamePassword(model.usernamePassword);
        }

        public final String getSecretArn() {
            return this.secretArn;
        }

        public final void setSecretArn(String secretArn) {
            String oldValue = this.secretArn;
            this.secretArn = secretArn;
            this.handleUnionValueChange(Type.SECRET_ARN, oldValue, this.secretArn);
        }

        @Override
        public final Builder secretArn(String secretArn) {
            String oldValue = this.secretArn;
            this.secretArn = secretArn;
            this.handleUnionValueChange(Type.SECRET_ARN, oldValue, this.secretArn);
            return this;
        }

        public final UsernamePassword.Builder getUsernamePassword() {
            return this.usernamePassword != null ? this.usernamePassword.toBuilder() : null;
        }

        public final void setUsernamePassword(UsernamePassword.BuilderImpl usernamePassword) {
            UsernamePassword oldValue = this.usernamePassword;
            this.usernamePassword = usernamePassword != null ? usernamePassword.build() : null;
            this.handleUnionValueChange(Type.USERNAME_PASSWORD, oldValue, this.usernamePassword);
        }

        @Override
        public final Builder usernamePassword(UsernamePassword usernamePassword) {
            UsernamePassword oldValue = this.usernamePassword;
            this.usernamePassword = usernamePassword;
            this.handleUnionValueChange(Type.USERNAME_PASSWORD, oldValue, this.usernamePassword);
            return this;
        }

        public RedshiftCredentials build() {
            return new RedshiftCredentials(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RedshiftCredentials> {
        public Builder secretArn(String var1);

        public Builder usernamePassword(UsernamePassword var1);

        default public Builder usernamePassword(Consumer<UsernamePassword.Builder> usernamePassword) {
            return this.usernamePassword((UsernamePassword)((UsernamePassword.Builder)UsernamePassword.builder().applyMutation(usernamePassword)).build());
        }
    }
}

