/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datazone.model.DataZoneRequest;
import software.amazon.awssdk.services.datazone.model.FormInput;
import software.amazon.awssdk.services.datazone.model.MetadataFormInputsCopier;
import software.amazon.awssdk.services.datazone.model.SubscribedListingInput;
import software.amazon.awssdk.services.datazone.model.SubscribedListingInputsCopier;
import software.amazon.awssdk.services.datazone.model.SubscribedPrincipalInput;
import software.amazon.awssdk.services.datazone.model.SubscribedPrincipalInputsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateSubscriptionRequestRequest
extends DataZoneRequest
implements ToCopyableBuilder<Builder, CreateSubscriptionRequestRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateSubscriptionRequestRequest.getter(CreateSubscriptionRequestRequest::clientToken)).setter(CreateSubscriptionRequestRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> DOMAIN_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainIdentifier").getter(CreateSubscriptionRequestRequest.getter(CreateSubscriptionRequestRequest::domainIdentifier)).setter(CreateSubscriptionRequestRequest.setter(Builder::domainIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainIdentifier").build()}).build();
    private static final SdkField<List<FormInput>> METADATA_FORMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("metadataForms").getter(CreateSubscriptionRequestRequest.getter(CreateSubscriptionRequestRequest::metadataForms)).setter(CreateSubscriptionRequestRequest.setter(Builder::metadataForms)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadataForms").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FormInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> REQUEST_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("requestReason").getter(CreateSubscriptionRequestRequest.getter(CreateSubscriptionRequestRequest::requestReason)).setter(CreateSubscriptionRequestRequest.setter(Builder::requestReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestReason").build()}).build();
    private static final SdkField<List<SubscribedListingInput>> SUBSCRIBED_LISTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("subscribedListings").getter(CreateSubscriptionRequestRequest.getter(CreateSubscriptionRequestRequest::subscribedListings)).setter(CreateSubscriptionRequestRequest.setter(Builder::subscribedListings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subscribedListings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SubscribedListingInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<SubscribedPrincipalInput>> SUBSCRIBED_PRINCIPALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("subscribedPrincipals").getter(CreateSubscriptionRequestRequest.getter(CreateSubscriptionRequestRequest::subscribedPrincipals)).setter(CreateSubscriptionRequestRequest.setter(Builder::subscribedPrincipals)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subscribedPrincipals").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SubscribedPrincipalInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, DOMAIN_IDENTIFIER_FIELD, METADATA_FORMS_FIELD, REQUEST_REASON_FIELD, SUBSCRIBED_LISTINGS_FIELD, SUBSCRIBED_PRINCIPALS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("clientToken", CLIENT_TOKEN_FIELD);
            this.put("domainIdentifier", DOMAIN_IDENTIFIER_FIELD);
            this.put("metadataForms", METADATA_FORMS_FIELD);
            this.put("requestReason", REQUEST_REASON_FIELD);
            this.put("subscribedListings", SUBSCRIBED_LISTINGS_FIELD);
            this.put("subscribedPrincipals", SUBSCRIBED_PRINCIPALS_FIELD);
        }
    });
    private final String clientToken;
    private final String domainIdentifier;
    private final List<FormInput> metadataForms;
    private final String requestReason;
    private final List<SubscribedListingInput> subscribedListings;
    private final List<SubscribedPrincipalInput> subscribedPrincipals;

    private CreateSubscriptionRequestRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.domainIdentifier = builder.domainIdentifier;
        this.metadataForms = builder.metadataForms;
        this.requestReason = builder.requestReason;
        this.subscribedListings = builder.subscribedListings;
        this.subscribedPrincipals = builder.subscribedPrincipals;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String domainIdentifier() {
        return this.domainIdentifier;
    }

    public final boolean hasMetadataForms() {
        return this.metadataForms != null && !(this.metadataForms instanceof SdkAutoConstructList);
    }

    public final List<FormInput> metadataForms() {
        return this.metadataForms;
    }

    public final String requestReason() {
        return this.requestReason;
    }

    public final boolean hasSubscribedListings() {
        return this.subscribedListings != null && !(this.subscribedListings instanceof SdkAutoConstructList);
    }

    public final List<SubscribedListingInput> subscribedListings() {
        return this.subscribedListings;
    }

    public final boolean hasSubscribedPrincipals() {
        return this.subscribedPrincipals != null && !(this.subscribedPrincipals instanceof SdkAutoConstructList);
    }

    public final List<SubscribedPrincipalInput> subscribedPrincipals() {
        return this.subscribedPrincipals;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetadataForms() ? this.metadataForms() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.requestReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubscribedListings() ? this.subscribedListings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubscribedPrincipals() ? this.subscribedPrincipals() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSubscriptionRequestRequest)) {
            return false;
        }
        CreateSubscriptionRequestRequest other = (CreateSubscriptionRequestRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.domainIdentifier(), other.domainIdentifier()) && this.hasMetadataForms() == other.hasMetadataForms() && Objects.equals(this.metadataForms(), other.metadataForms()) && Objects.equals(this.requestReason(), other.requestReason()) && this.hasSubscribedListings() == other.hasSubscribedListings() && Objects.equals(this.subscribedListings(), other.subscribedListings()) && this.hasSubscribedPrincipals() == other.hasSubscribedPrincipals() && Objects.equals(this.subscribedPrincipals(), other.subscribedPrincipals());
    }

    public final String toString() {
        return ToString.builder((String)"CreateSubscriptionRequestRequest").add("ClientToken", (Object)this.clientToken()).add("DomainIdentifier", (Object)this.domainIdentifier()).add("MetadataForms", (Object)(this.metadataForms() == null ? null : "*** Sensitive Data Redacted ***")).add("RequestReason", (Object)(this.requestReason() == null ? null : "*** Sensitive Data Redacted ***")).add("SubscribedListings", this.hasSubscribedListings() ? this.subscribedListings() : null).add("SubscribedPrincipals", this.hasSubscribedPrincipals() ? this.subscribedPrincipals() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "domainIdentifier": {
                return Optional.ofNullable(clazz.cast(this.domainIdentifier()));
            }
            case "metadataForms": {
                return Optional.ofNullable(clazz.cast(this.metadataForms()));
            }
            case "requestReason": {
                return Optional.ofNullable(clazz.cast(this.requestReason()));
            }
            case "subscribedListings": {
                return Optional.ofNullable(clazz.cast(this.subscribedListings()));
            }
            case "subscribedPrincipals": {
                return Optional.ofNullable(clazz.cast(this.subscribedPrincipals()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateSubscriptionRequestRequest, T> g) {
        return obj -> g.apply((CreateSubscriptionRequestRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataZoneRequest.BuilderImpl
    implements Builder {
        private String clientToken;
        private String domainIdentifier;
        private List<FormInput> metadataForms = DefaultSdkAutoConstructList.getInstance();
        private String requestReason;
        private List<SubscribedListingInput> subscribedListings = DefaultSdkAutoConstructList.getInstance();
        private List<SubscribedPrincipalInput> subscribedPrincipals = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSubscriptionRequestRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.domainIdentifier(model.domainIdentifier);
            this.metadataForms(model.metadataForms);
            this.requestReason(model.requestReason);
            this.subscribedListings(model.subscribedListings);
            this.subscribedPrincipals(model.subscribedPrincipals);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDomainIdentifier() {
            return this.domainIdentifier;
        }

        public final void setDomainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
        }

        @Override
        public final Builder domainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        public final List<FormInput.Builder> getMetadataForms() {
            List<FormInput.Builder> result = MetadataFormInputsCopier.copyToBuilder(this.metadataForms);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetadataForms(Collection<FormInput.BuilderImpl> metadataForms) {
            this.metadataForms = MetadataFormInputsCopier.copyFromBuilder(metadataForms);
        }

        @Override
        public final Builder metadataForms(Collection<FormInput> metadataForms) {
            this.metadataForms = MetadataFormInputsCopier.copy(metadataForms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metadataForms(FormInput ... metadataForms) {
            this.metadataForms(Arrays.asList(metadataForms));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metadataForms(Consumer<FormInput.Builder> ... metadataForms) {
            this.metadataForms(Stream.of(metadataForms).map(c -> (FormInput)((FormInput.Builder)FormInput.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getRequestReason() {
            return this.requestReason;
        }

        public final void setRequestReason(String requestReason) {
            this.requestReason = requestReason;
        }

        @Override
        public final Builder requestReason(String requestReason) {
            this.requestReason = requestReason;
            return this;
        }

        public final List<SubscribedListingInput.Builder> getSubscribedListings() {
            List<SubscribedListingInput.Builder> result = SubscribedListingInputsCopier.copyToBuilder(this.subscribedListings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSubscribedListings(Collection<SubscribedListingInput.BuilderImpl> subscribedListings) {
            this.subscribedListings = SubscribedListingInputsCopier.copyFromBuilder(subscribedListings);
        }

        @Override
        public final Builder subscribedListings(Collection<SubscribedListingInput> subscribedListings) {
            this.subscribedListings = SubscribedListingInputsCopier.copy(subscribedListings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subscribedListings(SubscribedListingInput ... subscribedListings) {
            this.subscribedListings(Arrays.asList(subscribedListings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subscribedListings(Consumer<SubscribedListingInput.Builder> ... subscribedListings) {
            this.subscribedListings(Stream.of(subscribedListings).map(c -> (SubscribedListingInput)((SubscribedListingInput.Builder)SubscribedListingInput.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<SubscribedPrincipalInput.Builder> getSubscribedPrincipals() {
            List<SubscribedPrincipalInput.Builder> result = SubscribedPrincipalInputsCopier.copyToBuilder(this.subscribedPrincipals);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSubscribedPrincipals(Collection<SubscribedPrincipalInput.BuilderImpl> subscribedPrincipals) {
            this.subscribedPrincipals = SubscribedPrincipalInputsCopier.copyFromBuilder(subscribedPrincipals);
        }

        @Override
        public final Builder subscribedPrincipals(Collection<SubscribedPrincipalInput> subscribedPrincipals) {
            this.subscribedPrincipals = SubscribedPrincipalInputsCopier.copy(subscribedPrincipals);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subscribedPrincipals(SubscribedPrincipalInput ... subscribedPrincipals) {
            this.subscribedPrincipals(Arrays.asList(subscribedPrincipals));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subscribedPrincipals(Consumer<SubscribedPrincipalInput.Builder> ... subscribedPrincipals) {
            this.subscribedPrincipals(Stream.of(subscribedPrincipals).map(c -> (SubscribedPrincipalInput)((SubscribedPrincipalInput.Builder)SubscribedPrincipalInput.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateSubscriptionRequestRequest build() {
            return new CreateSubscriptionRequestRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DataZoneRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateSubscriptionRequestRequest> {
        public Builder clientToken(String var1);

        public Builder domainIdentifier(String var1);

        public Builder metadataForms(Collection<FormInput> var1);

        public Builder metadataForms(FormInput ... var1);

        public Builder metadataForms(Consumer<FormInput.Builder> ... var1);

        public Builder requestReason(String var1);

        public Builder subscribedListings(Collection<SubscribedListingInput> var1);

        public Builder subscribedListings(SubscribedListingInput ... var1);

        public Builder subscribedListings(Consumer<SubscribedListingInput.Builder> ... var1);

        public Builder subscribedPrincipals(Collection<SubscribedPrincipalInput> var1);

        public Builder subscribedPrincipals(SubscribedPrincipalInput ... var1);

        public Builder subscribedPrincipals(Consumer<SubscribedPrincipalInput.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

