/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datazone.model.DataProductItem;
import software.amazon.awssdk.services.datazone.model.DataProductItemsCopier;
import software.amazon.awssdk.services.datazone.model.DataZoneRequest;
import software.amazon.awssdk.services.datazone.model.FormInput;
import software.amazon.awssdk.services.datazone.model.FormInputListCopier;
import software.amazon.awssdk.services.datazone.model.GlossaryTermsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDataProductRevisionRequest
extends DataZoneRequest
implements ToCopyableBuilder<Builder, CreateDataProductRevisionRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateDataProductRevisionRequest.getter(CreateDataProductRevisionRequest::clientToken)).setter(CreateDataProductRevisionRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateDataProductRevisionRequest.getter(CreateDataProductRevisionRequest::description)).setter(CreateDataProductRevisionRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> DOMAIN_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainIdentifier").getter(CreateDataProductRevisionRequest.getter(CreateDataProductRevisionRequest::domainIdentifier)).setter(CreateDataProductRevisionRequest.setter(Builder::domainIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainIdentifier").build()}).build();
    private static final SdkField<List<FormInput>> FORMS_INPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("formsInput").getter(CreateDataProductRevisionRequest.getter(CreateDataProductRevisionRequest::formsInput)).setter(CreateDataProductRevisionRequest.setter(Builder::formsInput)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("formsInput").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FormInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> GLOSSARY_TERMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("glossaryTerms").getter(CreateDataProductRevisionRequest.getter(CreateDataProductRevisionRequest::glossaryTerms)).setter(CreateDataProductRevisionRequest.setter(Builder::glossaryTerms)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("glossaryTerms").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("identifier").getter(CreateDataProductRevisionRequest.getter(CreateDataProductRevisionRequest::identifier)).setter(CreateDataProductRevisionRequest.setter(Builder::identifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("identifier").build()}).build();
    private static final SdkField<List<DataProductItem>> ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("items").getter(CreateDataProductRevisionRequest.getter(CreateDataProductRevisionRequest::items)).setter(CreateDataProductRevisionRequest.setter(Builder::items)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("items").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataProductItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateDataProductRevisionRequest.getter(CreateDataProductRevisionRequest::name)).setter(CreateDataProductRevisionRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, DESCRIPTION_FIELD, DOMAIN_IDENTIFIER_FIELD, FORMS_INPUT_FIELD, GLOSSARY_TERMS_FIELD, IDENTIFIER_FIELD, ITEMS_FIELD, NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("clientToken", CLIENT_TOKEN_FIELD);
            this.put("description", DESCRIPTION_FIELD);
            this.put("domainIdentifier", DOMAIN_IDENTIFIER_FIELD);
            this.put("formsInput", FORMS_INPUT_FIELD);
            this.put("glossaryTerms", GLOSSARY_TERMS_FIELD);
            this.put("identifier", IDENTIFIER_FIELD);
            this.put("items", ITEMS_FIELD);
            this.put("name", NAME_FIELD);
        }
    });
    private final String clientToken;
    private final String description;
    private final String domainIdentifier;
    private final List<FormInput> formsInput;
    private final List<String> glossaryTerms;
    private final String identifier;
    private final List<DataProductItem> items;
    private final String name;

    private CreateDataProductRevisionRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.description = builder.description;
        this.domainIdentifier = builder.domainIdentifier;
        this.formsInput = builder.formsInput;
        this.glossaryTerms = builder.glossaryTerms;
        this.identifier = builder.identifier;
        this.items = builder.items;
        this.name = builder.name;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String description() {
        return this.description;
    }

    public final String domainIdentifier() {
        return this.domainIdentifier;
    }

    public final boolean hasFormsInput() {
        return this.formsInput != null && !(this.formsInput instanceof SdkAutoConstructList);
    }

    public final List<FormInput> formsInput() {
        return this.formsInput;
    }

    public final boolean hasGlossaryTerms() {
        return this.glossaryTerms != null && !(this.glossaryTerms instanceof SdkAutoConstructList);
    }

    public final List<String> glossaryTerms() {
        return this.glossaryTerms;
    }

    public final String identifier() {
        return this.identifier;
    }

    public final boolean hasItems() {
        return this.items != null && !(this.items instanceof SdkAutoConstructList);
    }

    public final List<DataProductItem> items() {
        return this.items;
    }

    public final String name() {
        return this.name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFormsInput() ? this.formsInput() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGlossaryTerms() ? this.glossaryTerms() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.identifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasItems() ? this.items() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDataProductRevisionRequest)) {
            return false;
        }
        CreateDataProductRevisionRequest other = (CreateDataProductRevisionRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.domainIdentifier(), other.domainIdentifier()) && this.hasFormsInput() == other.hasFormsInput() && Objects.equals(this.formsInput(), other.formsInput()) && this.hasGlossaryTerms() == other.hasGlossaryTerms() && Objects.equals(this.glossaryTerms(), other.glossaryTerms()) && Objects.equals(this.identifier(), other.identifier()) && this.hasItems() == other.hasItems() && Objects.equals(this.items(), other.items()) && Objects.equals(this.name(), other.name());
    }

    public final String toString() {
        return ToString.builder((String)"CreateDataProductRevisionRequest").add("ClientToken", (Object)this.clientToken()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("DomainIdentifier", (Object)this.domainIdentifier()).add("FormsInput", (Object)(this.formsInput() == null ? null : "*** Sensitive Data Redacted ***")).add("GlossaryTerms", this.hasGlossaryTerms() ? this.glossaryTerms() : null).add("Identifier", (Object)this.identifier()).add("Items", this.hasItems() ? this.items() : null).add("Name", (Object)(this.name() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "domainIdentifier": {
                return Optional.ofNullable(clazz.cast(this.domainIdentifier()));
            }
            case "formsInput": {
                return Optional.ofNullable(clazz.cast(this.formsInput()));
            }
            case "glossaryTerms": {
                return Optional.ofNullable(clazz.cast(this.glossaryTerms()));
            }
            case "identifier": {
                return Optional.ofNullable(clazz.cast(this.identifier()));
            }
            case "items": {
                return Optional.ofNullable(clazz.cast(this.items()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateDataProductRevisionRequest, T> g) {
        return obj -> g.apply((CreateDataProductRevisionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataZoneRequest.BuilderImpl
    implements Builder {
        private String clientToken;
        private String description;
        private String domainIdentifier;
        private List<FormInput> formsInput = DefaultSdkAutoConstructList.getInstance();
        private List<String> glossaryTerms = DefaultSdkAutoConstructList.getInstance();
        private String identifier;
        private List<DataProductItem> items = DefaultSdkAutoConstructList.getInstance();
        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDataProductRevisionRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.description(model.description);
            this.domainIdentifier(model.domainIdentifier);
            this.formsInput(model.formsInput);
            this.glossaryTerms(model.glossaryTerms);
            this.identifier(model.identifier);
            this.items(model.items);
            this.name(model.name);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDomainIdentifier() {
            return this.domainIdentifier;
        }

        public final void setDomainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
        }

        @Override
        public final Builder domainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        public final List<FormInput.Builder> getFormsInput() {
            List<FormInput.Builder> result = FormInputListCopier.copyToBuilder(this.formsInput);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFormsInput(Collection<FormInput.BuilderImpl> formsInput) {
            this.formsInput = FormInputListCopier.copyFromBuilder(formsInput);
        }

        @Override
        public final Builder formsInput(Collection<FormInput> formsInput) {
            this.formsInput = FormInputListCopier.copy(formsInput);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder formsInput(FormInput ... formsInput) {
            this.formsInput(Arrays.asList(formsInput));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder formsInput(Consumer<FormInput.Builder> ... formsInput) {
            this.formsInput(Stream.of(formsInput).map(c -> (FormInput)((FormInput.Builder)FormInput.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getGlossaryTerms() {
            if (this.glossaryTerms instanceof SdkAutoConstructList) {
                return null;
            }
            return this.glossaryTerms;
        }

        public final void setGlossaryTerms(Collection<String> glossaryTerms) {
            this.glossaryTerms = GlossaryTermsCopier.copy(glossaryTerms);
        }

        @Override
        public final Builder glossaryTerms(Collection<String> glossaryTerms) {
            this.glossaryTerms = GlossaryTermsCopier.copy(glossaryTerms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder glossaryTerms(String ... glossaryTerms) {
            this.glossaryTerms(Arrays.asList(glossaryTerms));
            return this;
        }

        public final String getIdentifier() {
            return this.identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final List<DataProductItem.Builder> getItems() {
            List<DataProductItem.Builder> result = DataProductItemsCopier.copyToBuilder(this.items);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setItems(Collection<DataProductItem.BuilderImpl> items) {
            this.items = DataProductItemsCopier.copyFromBuilder(items);
        }

        @Override
        public final Builder items(Collection<DataProductItem> items) {
            this.items = DataProductItemsCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(DataProductItem ... items) {
            this.items(Arrays.asList(items));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(Consumer<DataProductItem.Builder> ... items) {
            this.items(Stream.of(items).map(c -> (DataProductItem)((DataProductItem.Builder)DataProductItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDataProductRevisionRequest build() {
            return new CreateDataProductRevisionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DataZoneRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateDataProductRevisionRequest> {
        public Builder clientToken(String var1);

        public Builder description(String var1);

        public Builder domainIdentifier(String var1);

        public Builder formsInput(Collection<FormInput> var1);

        public Builder formsInput(FormInput ... var1);

        public Builder formsInput(Consumer<FormInput.Builder> ... var1);

        public Builder glossaryTerms(Collection<String> var1);

        public Builder glossaryTerms(String ... var1);

        public Builder identifier(String var1);

        public Builder items(Collection<DataProductItem> var1);

        public Builder items(DataProductItem ... var1);

        public Builder items(Consumer<DataProductItem.Builder> ... var1);

        public Builder name(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

