/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.datazone.model.DataZoneRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListProjectsRequest
extends DataZoneRequest
implements ToCopyableBuilder<Builder, ListProjectsRequest> {
    private static final SdkField<String> DOMAIN_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainIdentifier").getter(ListProjectsRequest.getter(ListProjectsRequest::domainIdentifier)).setter(ListProjectsRequest.setter(Builder::domainIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainIdentifier").build()}).build();
    private static final SdkField<String> GROUP_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("groupIdentifier").getter(ListProjectsRequest.getter(ListProjectsRequest::groupIdentifier)).setter(ListProjectsRequest.setter(Builder::groupIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("groupIdentifier").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListProjectsRequest.getter(ListProjectsRequest::maxResults)).setter(ListProjectsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(ListProjectsRequest.getter(ListProjectsRequest::name)).setter(ListProjectsRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("name").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListProjectsRequest.getter(ListProjectsRequest::nextToken)).setter(ListProjectsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final SdkField<String> USER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("userIdentifier").getter(ListProjectsRequest.getter(ListProjectsRequest::userIdentifier)).setter(ListProjectsRequest.setter(Builder::userIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("userIdentifier").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_IDENTIFIER_FIELD, GROUP_IDENTIFIER_FIELD, MAX_RESULTS_FIELD, NAME_FIELD, NEXT_TOKEN_FIELD, USER_IDENTIFIER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("domainIdentifier", DOMAIN_IDENTIFIER_FIELD);
            this.put("groupIdentifier", GROUP_IDENTIFIER_FIELD);
            this.put("maxResults", MAX_RESULTS_FIELD);
            this.put("name", NAME_FIELD);
            this.put("nextToken", NEXT_TOKEN_FIELD);
            this.put("userIdentifier", USER_IDENTIFIER_FIELD);
        }
    });
    private final String domainIdentifier;
    private final String groupIdentifier;
    private final Integer maxResults;
    private final String name;
    private final String nextToken;
    private final String userIdentifier;

    private ListProjectsRequest(BuilderImpl builder) {
        super(builder);
        this.domainIdentifier = builder.domainIdentifier;
        this.groupIdentifier = builder.groupIdentifier;
        this.maxResults = builder.maxResults;
        this.name = builder.name;
        this.nextToken = builder.nextToken;
        this.userIdentifier = builder.userIdentifier;
    }

    public final String domainIdentifier() {
        return this.domainIdentifier;
    }

    public final String groupIdentifier() {
        return this.groupIdentifier;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String name() {
        return this.name;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final String userIdentifier() {
        return this.userIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domainIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.userIdentifier());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListProjectsRequest)) {
            return false;
        }
        ListProjectsRequest other = (ListProjectsRequest)((Object)obj);
        return Objects.equals(this.domainIdentifier(), other.domainIdentifier()) && Objects.equals(this.groupIdentifier(), other.groupIdentifier()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.userIdentifier(), other.userIdentifier());
    }

    public final String toString() {
        return ToString.builder((String)"ListProjectsRequest").add("DomainIdentifier", (Object)this.domainIdentifier()).add("GroupIdentifier", (Object)this.groupIdentifier()).add("MaxResults", (Object)this.maxResults()).add("Name", (Object)(this.name() == null ? null : "*** Sensitive Data Redacted ***")).add("NextToken", (Object)this.nextToken()).add("UserIdentifier", (Object)this.userIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "domainIdentifier": {
                return Optional.ofNullable(clazz.cast(this.domainIdentifier()));
            }
            case "groupIdentifier": {
                return Optional.ofNullable(clazz.cast(this.groupIdentifier()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "userIdentifier": {
                return Optional.ofNullable(clazz.cast(this.userIdentifier()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListProjectsRequest, T> g) {
        return obj -> g.apply((ListProjectsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataZoneRequest.BuilderImpl
    implements Builder {
        private String domainIdentifier;
        private String groupIdentifier;
        private Integer maxResults;
        private String name;
        private String nextToken;
        private String userIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(ListProjectsRequest model) {
            super(model);
            this.domainIdentifier(model.domainIdentifier);
            this.groupIdentifier(model.groupIdentifier);
            this.maxResults(model.maxResults);
            this.name(model.name);
            this.nextToken(model.nextToken);
            this.userIdentifier(model.userIdentifier);
        }

        public final String getDomainIdentifier() {
            return this.domainIdentifier;
        }

        public final void setDomainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
        }

        @Override
        public final Builder domainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        public final String getGroupIdentifier() {
            return this.groupIdentifier;
        }

        public final void setGroupIdentifier(String groupIdentifier) {
            this.groupIdentifier = groupIdentifier;
        }

        @Override
        public final Builder groupIdentifier(String groupIdentifier) {
            this.groupIdentifier = groupIdentifier;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getUserIdentifier() {
            return this.userIdentifier;
        }

        public final void setUserIdentifier(String userIdentifier) {
            this.userIdentifier = userIdentifier;
        }

        @Override
        public final Builder userIdentifier(String userIdentifier) {
            this.userIdentifier = userIdentifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListProjectsRequest build() {
            return new ListProjectsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DataZoneRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListProjectsRequest> {
        public Builder domainIdentifier(String var1);

        public Builder groupIdentifier(String var1);

        public Builder maxResults(Integer var1);

        public Builder name(String var1);

        public Builder nextToken(String var1);

        public Builder userIdentifier(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

