/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.datazone.model.DataZoneRequest;
import software.amazon.awssdk.services.datazone.model.GroupSearchType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchGroupProfilesRequest
extends DataZoneRequest
implements ToCopyableBuilder<Builder, SearchGroupProfilesRequest> {
    private static final SdkField<String> DOMAIN_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainIdentifier").getter(SearchGroupProfilesRequest.getter(SearchGroupProfilesRequest::domainIdentifier)).setter(SearchGroupProfilesRequest.setter(Builder::domainIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainIdentifier").build()}).build();
    private static final SdkField<String> GROUP_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("groupType").getter(SearchGroupProfilesRequest.getter(SearchGroupProfilesRequest::groupTypeAsString)).setter(SearchGroupProfilesRequest.setter(Builder::groupType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupType").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(SearchGroupProfilesRequest.getter(SearchGroupProfilesRequest::maxResults)).setter(SearchGroupProfilesRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(SearchGroupProfilesRequest.getter(SearchGroupProfilesRequest::nextToken)).setter(SearchGroupProfilesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<String> SEARCH_TEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("searchText").getter(SearchGroupProfilesRequest.getter(SearchGroupProfilesRequest::searchText)).setter(SearchGroupProfilesRequest.setter(Builder::searchText)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("searchText").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_IDENTIFIER_FIELD, GROUP_TYPE_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, SEARCH_TEXT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("domainIdentifier", DOMAIN_IDENTIFIER_FIELD);
            this.put("groupType", GROUP_TYPE_FIELD);
            this.put("maxResults", MAX_RESULTS_FIELD);
            this.put("nextToken", NEXT_TOKEN_FIELD);
            this.put("searchText", SEARCH_TEXT_FIELD);
        }
    });
    private final String domainIdentifier;
    private final String groupType;
    private final Integer maxResults;
    private final String nextToken;
    private final String searchText;

    private SearchGroupProfilesRequest(BuilderImpl builder) {
        super(builder);
        this.domainIdentifier = builder.domainIdentifier;
        this.groupType = builder.groupType;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.searchText = builder.searchText;
    }

    public final String domainIdentifier() {
        return this.domainIdentifier;
    }

    public final GroupSearchType groupType() {
        return GroupSearchType.fromValue(this.groupType);
    }

    public final String groupTypeAsString() {
        return this.groupType;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final String searchText() {
        return this.searchText;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domainIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.searchText());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchGroupProfilesRequest)) {
            return false;
        }
        SearchGroupProfilesRequest other = (SearchGroupProfilesRequest)((Object)obj);
        return Objects.equals(this.domainIdentifier(), other.domainIdentifier()) && Objects.equals(this.groupTypeAsString(), other.groupTypeAsString()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.searchText(), other.searchText());
    }

    public final String toString() {
        return ToString.builder((String)"SearchGroupProfilesRequest").add("DomainIdentifier", (Object)this.domainIdentifier()).add("GroupType", (Object)this.groupTypeAsString()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("SearchText", (Object)(this.searchText() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "domainIdentifier": {
                return Optional.ofNullable(clazz.cast(this.domainIdentifier()));
            }
            case "groupType": {
                return Optional.ofNullable(clazz.cast(this.groupTypeAsString()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "searchText": {
                return Optional.ofNullable(clazz.cast(this.searchText()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SearchGroupProfilesRequest, T> g) {
        return obj -> g.apply((SearchGroupProfilesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataZoneRequest.BuilderImpl
    implements Builder {
        private String domainIdentifier;
        private String groupType;
        private Integer maxResults;
        private String nextToken;
        private String searchText;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchGroupProfilesRequest model) {
            super(model);
            this.domainIdentifier(model.domainIdentifier);
            this.groupType(model.groupType);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.searchText(model.searchText);
        }

        public final String getDomainIdentifier() {
            return this.domainIdentifier;
        }

        public final void setDomainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
        }

        @Override
        public final Builder domainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        public final String getGroupType() {
            return this.groupType;
        }

        public final void setGroupType(String groupType) {
            this.groupType = groupType;
        }

        @Override
        public final Builder groupType(String groupType) {
            this.groupType = groupType;
            return this;
        }

        @Override
        public final Builder groupType(GroupSearchType groupType) {
            this.groupType(groupType == null ? null : groupType.toString());
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getSearchText() {
            return this.searchText;
        }

        public final void setSearchText(String searchText) {
            this.searchText = searchText;
        }

        @Override
        public final Builder searchText(String searchText) {
            this.searchText = searchText;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SearchGroupProfilesRequest build() {
            return new SearchGroupProfilesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DataZoneRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SearchGroupProfilesRequest> {
        public Builder domainIdentifier(String var1);

        public Builder groupType(String var1);

        public Builder groupType(GroupSearchType var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder searchText(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

