/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datazone.model.AssetTargetNameMap;
import software.amazon.awssdk.services.datazone.model.AssetTargetNamesCopier;
import software.amazon.awssdk.services.datazone.model.DataZoneRequest;
import software.amazon.awssdk.services.datazone.model.GrantedEntityInput;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateSubscriptionGrantRequest
extends DataZoneRequest
implements ToCopyableBuilder<Builder, CreateSubscriptionGrantRequest> {
    private static final SdkField<List<AssetTargetNameMap>> ASSET_TARGET_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("assetTargetNames").getter(CreateSubscriptionGrantRequest.getter(CreateSubscriptionGrantRequest::assetTargetNames)).setter(CreateSubscriptionGrantRequest.setter(Builder::assetTargetNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetTargetNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AssetTargetNameMap::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateSubscriptionGrantRequest.getter(CreateSubscriptionGrantRequest::clientToken)).setter(CreateSubscriptionGrantRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> DOMAIN_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainIdentifier").getter(CreateSubscriptionGrantRequest.getter(CreateSubscriptionGrantRequest::domainIdentifier)).setter(CreateSubscriptionGrantRequest.setter(Builder::domainIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainIdentifier").build()}).build();
    private static final SdkField<String> ENVIRONMENT_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("environmentIdentifier").getter(CreateSubscriptionGrantRequest.getter(CreateSubscriptionGrantRequest::environmentIdentifier)).setter(CreateSubscriptionGrantRequest.setter(Builder::environmentIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentIdentifier").build()}).build();
    private static final SdkField<GrantedEntityInput> GRANTED_ENTITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("grantedEntity").getter(CreateSubscriptionGrantRequest.getter(CreateSubscriptionGrantRequest::grantedEntity)).setter(CreateSubscriptionGrantRequest.setter(Builder::grantedEntity)).constructor(GrantedEntityInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("grantedEntity").build()}).build();
    private static final SdkField<String> SUBSCRIPTION_TARGET_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("subscriptionTargetIdentifier").getter(CreateSubscriptionGrantRequest.getter(CreateSubscriptionGrantRequest::subscriptionTargetIdentifier)).setter(CreateSubscriptionGrantRequest.setter(Builder::subscriptionTargetIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subscriptionTargetIdentifier").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_TARGET_NAMES_FIELD, CLIENT_TOKEN_FIELD, DOMAIN_IDENTIFIER_FIELD, ENVIRONMENT_IDENTIFIER_FIELD, GRANTED_ENTITY_FIELD, SUBSCRIPTION_TARGET_IDENTIFIER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("assetTargetNames", ASSET_TARGET_NAMES_FIELD);
            this.put("clientToken", CLIENT_TOKEN_FIELD);
            this.put("domainIdentifier", DOMAIN_IDENTIFIER_FIELD);
            this.put("environmentIdentifier", ENVIRONMENT_IDENTIFIER_FIELD);
            this.put("grantedEntity", GRANTED_ENTITY_FIELD);
            this.put("subscriptionTargetIdentifier", SUBSCRIPTION_TARGET_IDENTIFIER_FIELD);
        }
    });
    private final List<AssetTargetNameMap> assetTargetNames;
    private final String clientToken;
    private final String domainIdentifier;
    private final String environmentIdentifier;
    private final GrantedEntityInput grantedEntity;
    private final String subscriptionTargetIdentifier;

    private CreateSubscriptionGrantRequest(BuilderImpl builder) {
        super(builder);
        this.assetTargetNames = builder.assetTargetNames;
        this.clientToken = builder.clientToken;
        this.domainIdentifier = builder.domainIdentifier;
        this.environmentIdentifier = builder.environmentIdentifier;
        this.grantedEntity = builder.grantedEntity;
        this.subscriptionTargetIdentifier = builder.subscriptionTargetIdentifier;
    }

    public final boolean hasAssetTargetNames() {
        return this.assetTargetNames != null && !(this.assetTargetNames instanceof SdkAutoConstructList);
    }

    public final List<AssetTargetNameMap> assetTargetNames() {
        return this.assetTargetNames;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String domainIdentifier() {
        return this.domainIdentifier;
    }

    public final String environmentIdentifier() {
        return this.environmentIdentifier;
    }

    public final GrantedEntityInput grantedEntity() {
        return this.grantedEntity;
    }

    public final String subscriptionTargetIdentifier() {
        return this.subscriptionTargetIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssetTargetNames() ? this.assetTargetNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.grantedEntity());
        hashCode = 31 * hashCode + Objects.hashCode(this.subscriptionTargetIdentifier());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSubscriptionGrantRequest)) {
            return false;
        }
        CreateSubscriptionGrantRequest other = (CreateSubscriptionGrantRequest)((Object)obj);
        return this.hasAssetTargetNames() == other.hasAssetTargetNames() && Objects.equals(this.assetTargetNames(), other.assetTargetNames()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.domainIdentifier(), other.domainIdentifier()) && Objects.equals(this.environmentIdentifier(), other.environmentIdentifier()) && Objects.equals(this.grantedEntity(), other.grantedEntity()) && Objects.equals(this.subscriptionTargetIdentifier(), other.subscriptionTargetIdentifier());
    }

    public final String toString() {
        return ToString.builder((String)"CreateSubscriptionGrantRequest").add("AssetTargetNames", this.hasAssetTargetNames() ? this.assetTargetNames() : null).add("ClientToken", (Object)this.clientToken()).add("DomainIdentifier", (Object)this.domainIdentifier()).add("EnvironmentIdentifier", (Object)this.environmentIdentifier()).add("GrantedEntity", (Object)this.grantedEntity()).add("SubscriptionTargetIdentifier", (Object)this.subscriptionTargetIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "assetTargetNames": {
                return Optional.ofNullable(clazz.cast(this.assetTargetNames()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "domainIdentifier": {
                return Optional.ofNullable(clazz.cast(this.domainIdentifier()));
            }
            case "environmentIdentifier": {
                return Optional.ofNullable(clazz.cast(this.environmentIdentifier()));
            }
            case "grantedEntity": {
                return Optional.ofNullable(clazz.cast(this.grantedEntity()));
            }
            case "subscriptionTargetIdentifier": {
                return Optional.ofNullable(clazz.cast(this.subscriptionTargetIdentifier()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateSubscriptionGrantRequest, T> g) {
        return obj -> g.apply((CreateSubscriptionGrantRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataZoneRequest.BuilderImpl
    implements Builder {
        private List<AssetTargetNameMap> assetTargetNames = DefaultSdkAutoConstructList.getInstance();
        private String clientToken;
        private String domainIdentifier;
        private String environmentIdentifier;
        private GrantedEntityInput grantedEntity;
        private String subscriptionTargetIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSubscriptionGrantRequest model) {
            super(model);
            this.assetTargetNames(model.assetTargetNames);
            this.clientToken(model.clientToken);
            this.domainIdentifier(model.domainIdentifier);
            this.environmentIdentifier(model.environmentIdentifier);
            this.grantedEntity(model.grantedEntity);
            this.subscriptionTargetIdentifier(model.subscriptionTargetIdentifier);
        }

        public final List<AssetTargetNameMap.Builder> getAssetTargetNames() {
            List<AssetTargetNameMap.Builder> result = AssetTargetNamesCopier.copyToBuilder(this.assetTargetNames);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssetTargetNames(Collection<AssetTargetNameMap.BuilderImpl> assetTargetNames) {
            this.assetTargetNames = AssetTargetNamesCopier.copyFromBuilder(assetTargetNames);
        }

        @Override
        public final Builder assetTargetNames(Collection<AssetTargetNameMap> assetTargetNames) {
            this.assetTargetNames = AssetTargetNamesCopier.copy(assetTargetNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetTargetNames(AssetTargetNameMap ... assetTargetNames) {
            this.assetTargetNames(Arrays.asList(assetTargetNames));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetTargetNames(Consumer<AssetTargetNameMap.Builder> ... assetTargetNames) {
            this.assetTargetNames(Stream.of(assetTargetNames).map(c -> (AssetTargetNameMap)((AssetTargetNameMap.Builder)AssetTargetNameMap.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDomainIdentifier() {
            return this.domainIdentifier;
        }

        public final void setDomainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
        }

        @Override
        public final Builder domainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        public final String getEnvironmentIdentifier() {
            return this.environmentIdentifier;
        }

        public final void setEnvironmentIdentifier(String environmentIdentifier) {
            this.environmentIdentifier = environmentIdentifier;
        }

        @Override
        public final Builder environmentIdentifier(String environmentIdentifier) {
            this.environmentIdentifier = environmentIdentifier;
            return this;
        }

        public final GrantedEntityInput.Builder getGrantedEntity() {
            return this.grantedEntity != null ? this.grantedEntity.toBuilder() : null;
        }

        public final void setGrantedEntity(GrantedEntityInput.BuilderImpl grantedEntity) {
            this.grantedEntity = grantedEntity != null ? grantedEntity.build() : null;
        }

        @Override
        public final Builder grantedEntity(GrantedEntityInput grantedEntity) {
            this.grantedEntity = grantedEntity;
            return this;
        }

        public final String getSubscriptionTargetIdentifier() {
            return this.subscriptionTargetIdentifier;
        }

        public final void setSubscriptionTargetIdentifier(String subscriptionTargetIdentifier) {
            this.subscriptionTargetIdentifier = subscriptionTargetIdentifier;
        }

        @Override
        public final Builder subscriptionTargetIdentifier(String subscriptionTargetIdentifier) {
            this.subscriptionTargetIdentifier = subscriptionTargetIdentifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateSubscriptionGrantRequest build() {
            return new CreateSubscriptionGrantRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DataZoneRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateSubscriptionGrantRequest> {
        public Builder assetTargetNames(Collection<AssetTargetNameMap> var1);

        public Builder assetTargetNames(AssetTargetNameMap ... var1);

        public Builder assetTargetNames(Consumer<AssetTargetNameMap.Builder> ... var1);

        public Builder clientToken(String var1);

        public Builder domainIdentifier(String var1);

        public Builder environmentIdentifier(String var1);

        public Builder grantedEntity(GrantedEntityInput var1);

        default public Builder grantedEntity(Consumer<GrantedEntityInput.Builder> grantedEntity) {
            return this.grantedEntity((GrantedEntityInput)((GrantedEntityInput.Builder)GrantedEntityInput.builder().applyMutation(grantedEntity)).build());
        }

        public Builder subscriptionTargetIdentifier(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

