/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.datazone.model.IamUserProfileDetails;
import software.amazon.awssdk.services.datazone.model.SsoUserProfileDetails;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UserProfileDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UserProfileDetails> {
    private static final SdkField<IamUserProfileDetails> IAM_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("iam").getter(UserProfileDetails.getter(UserProfileDetails::iam)).setter(UserProfileDetails.setter(Builder::iam)).constructor(IamUserProfileDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iam").build()}).build();
    private static final SdkField<SsoUserProfileDetails> SSO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sso").getter(UserProfileDetails.getter(UserProfileDetails::sso)).setter(UserProfileDetails.setter(Builder::sso)).constructor(SsoUserProfileDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sso").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IAM_FIELD, SSO_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("iam", IAM_FIELD);
            this.put("sso", SSO_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final IamUserProfileDetails iam;
    private final SsoUserProfileDetails sso;
    private final Type type;

    private UserProfileDetails(BuilderImpl builder) {
        this.iam = builder.iam;
        this.sso = builder.sso;
        this.type = builder.type;
    }

    public final IamUserProfileDetails iam() {
        return this.iam;
    }

    public final SsoUserProfileDetails sso() {
        return this.sso;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.iam());
        hashCode = 31 * hashCode + Objects.hashCode(this.sso());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserProfileDetails)) {
            return false;
        }
        UserProfileDetails other = (UserProfileDetails)obj;
        return Objects.equals(this.iam(), other.iam()) && Objects.equals(this.sso(), other.sso());
    }

    public final String toString() {
        return ToString.builder((String)"UserProfileDetails").add("Iam", (Object)this.iam()).add("Sso", (Object)this.sso()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "iam": {
                return Optional.ofNullable(clazz.cast(this.iam()));
            }
            case "sso": {
                return Optional.ofNullable(clazz.cast(this.sso()));
            }
        }
        return Optional.empty();
    }

    public static UserProfileDetails fromIam(IamUserProfileDetails iam) {
        return (UserProfileDetails)UserProfileDetails.builder().iam(iam).build();
    }

    public static UserProfileDetails fromIam(Consumer<IamUserProfileDetails.Builder> iam) {
        IamUserProfileDetails.Builder builder = IamUserProfileDetails.builder();
        iam.accept(builder);
        return UserProfileDetails.fromIam((IamUserProfileDetails)builder.build());
    }

    public static UserProfileDetails fromSso(SsoUserProfileDetails sso) {
        return (UserProfileDetails)UserProfileDetails.builder().sso(sso).build();
    }

    public static UserProfileDetails fromSso(Consumer<SsoUserProfileDetails.Builder> sso) {
        SsoUserProfileDetails.Builder builder = SsoUserProfileDetails.builder();
        sso.accept(builder);
        return UserProfileDetails.fromSso((SsoUserProfileDetails)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UserProfileDetails, T> g) {
        return obj -> g.apply((UserProfileDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        IAM,
        SSO,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private IamUserProfileDetails iam;
        private SsoUserProfileDetails sso;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(UserProfileDetails model) {
            this.iam(model.iam);
            this.sso(model.sso);
        }

        public final IamUserProfileDetails.Builder getIam() {
            return this.iam != null ? this.iam.toBuilder() : null;
        }

        public final void setIam(IamUserProfileDetails.BuilderImpl iam) {
            IamUserProfileDetails oldValue = this.iam;
            this.iam = iam != null ? iam.build() : null;
            this.handleUnionValueChange(Type.IAM, oldValue, this.iam);
        }

        @Override
        public final Builder iam(IamUserProfileDetails iam) {
            IamUserProfileDetails oldValue = this.iam;
            this.iam = iam;
            this.handleUnionValueChange(Type.IAM, oldValue, this.iam);
            return this;
        }

        public final SsoUserProfileDetails.Builder getSso() {
            return this.sso != null ? this.sso.toBuilder() : null;
        }

        public final void setSso(SsoUserProfileDetails.BuilderImpl sso) {
            SsoUserProfileDetails oldValue = this.sso;
            this.sso = sso != null ? sso.build() : null;
            this.handleUnionValueChange(Type.SSO, oldValue, this.sso);
        }

        @Override
        public final Builder sso(SsoUserProfileDetails sso) {
            SsoUserProfileDetails oldValue = this.sso;
            this.sso = sso;
            this.handleUnionValueChange(Type.SSO, oldValue, this.sso);
            return this;
        }

        public UserProfileDetails build() {
            return new UserProfileDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UserProfileDetails> {
        public Builder iam(IamUserProfileDetails var1);

        default public Builder iam(Consumer<IamUserProfileDetails.Builder> iam) {
            return this.iam((IamUserProfileDetails)((IamUserProfileDetails.Builder)IamUserProfileDetails.builder().applyMutation(iam)).build());
        }

        public Builder sso(SsoUserProfileDetails var1);

        default public Builder sso(Consumer<SsoUserProfileDetails.Builder> sso) {
            return this.sso((SsoUserProfileDetails)((SsoUserProfileDetails.Builder)SsoUserProfileDetails.builder().applyMutation(sso)).build());
        }
    }
}

