/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datazone.model.DataZoneResponse;
import software.amazon.awssdk.services.datazone.model.DomainUnitOwnerProperties;
import software.amazon.awssdk.services.datazone.model.DomainUnitOwnersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateDomainUnitResponse
extends DataZoneResponse
implements ToCopyableBuilder<Builder, UpdateDomainUnitResponse> {
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(UpdateDomainUnitResponse.getter(UpdateDomainUnitResponse::createdAt)).setter(UpdateDomainUnitResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<String> CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("createdBy").getter(UpdateDomainUnitResponse.getter(UpdateDomainUnitResponse::createdBy)).setter(UpdateDomainUnitResponse.setter(Builder::createdBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(UpdateDomainUnitResponse.getter(UpdateDomainUnitResponse::description)).setter(UpdateDomainUnitResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainId").getter(UpdateDomainUnitResponse.getter(UpdateDomainUnitResponse::domainId)).setter(UpdateDomainUnitResponse.setter(Builder::domainId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainId").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(UpdateDomainUnitResponse.getter(UpdateDomainUnitResponse::id)).setter(UpdateDomainUnitResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdatedAt").getter(UpdateDomainUnitResponse.getter(UpdateDomainUnitResponse::lastUpdatedAt)).setter(UpdateDomainUnitResponse.setter(Builder::lastUpdatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build()}).build();
    private static final SdkField<String> LAST_UPDATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lastUpdatedBy").getter(UpdateDomainUnitResponse.getter(UpdateDomainUnitResponse::lastUpdatedBy)).setter(UpdateDomainUnitResponse.setter(Builder::lastUpdatedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedBy").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(UpdateDomainUnitResponse.getter(UpdateDomainUnitResponse::name)).setter(UpdateDomainUnitResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<List<DomainUnitOwnerProperties>> OWNERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("owners").getter(UpdateDomainUnitResponse.getter(UpdateDomainUnitResponse::owners)).setter(UpdateDomainUnitResponse.setter(Builder::owners)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("owners").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DomainUnitOwnerProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PARENT_DOMAIN_UNIT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("parentDomainUnitId").getter(UpdateDomainUnitResponse.getter(UpdateDomainUnitResponse::parentDomainUnitId)).setter(UpdateDomainUnitResponse.setter(Builder::parentDomainUnitId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parentDomainUnitId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AT_FIELD, CREATED_BY_FIELD, DESCRIPTION_FIELD, DOMAIN_ID_FIELD, ID_FIELD, LAST_UPDATED_AT_FIELD, LAST_UPDATED_BY_FIELD, NAME_FIELD, OWNERS_FIELD, PARENT_DOMAIN_UNIT_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("createdAt", CREATED_AT_FIELD);
            this.put("createdBy", CREATED_BY_FIELD);
            this.put("description", DESCRIPTION_FIELD);
            this.put("domainId", DOMAIN_ID_FIELD);
            this.put("id", ID_FIELD);
            this.put("lastUpdatedAt", LAST_UPDATED_AT_FIELD);
            this.put("lastUpdatedBy", LAST_UPDATED_BY_FIELD);
            this.put("name", NAME_FIELD);
            this.put("owners", OWNERS_FIELD);
            this.put("parentDomainUnitId", PARENT_DOMAIN_UNIT_ID_FIELD);
        }
    });
    private final Instant createdAt;
    private final String createdBy;
    private final String description;
    private final String domainId;
    private final String id;
    private final Instant lastUpdatedAt;
    private final String lastUpdatedBy;
    private final String name;
    private final List<DomainUnitOwnerProperties> owners;
    private final String parentDomainUnitId;

    private UpdateDomainUnitResponse(BuilderImpl builder) {
        super(builder);
        this.createdAt = builder.createdAt;
        this.createdBy = builder.createdBy;
        this.description = builder.description;
        this.domainId = builder.domainId;
        this.id = builder.id;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.lastUpdatedBy = builder.lastUpdatedBy;
        this.name = builder.name;
        this.owners = builder.owners;
        this.parentDomainUnitId = builder.parentDomainUnitId;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String createdBy() {
        return this.createdBy;
    }

    public final String description() {
        return this.description;
    }

    public final String domainId() {
        return this.domainId;
    }

    public final String id() {
        return this.id;
    }

    public final Instant lastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public final String lastUpdatedBy() {
        return this.lastUpdatedBy;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasOwners() {
        return this.owners != null && !(this.owners instanceof SdkAutoConstructList);
    }

    public final List<DomainUnitOwnerProperties> owners() {
        return this.owners;
    }

    public final String parentDomainUnitId() {
        return this.parentDomainUnitId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainId());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOwners() ? this.owners() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.parentDomainUnitId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDomainUnitResponse)) {
            return false;
        }
        UpdateDomainUnitResponse other = (UpdateDomainUnitResponse)((Object)obj);
        return Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.createdBy(), other.createdBy()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.domainId(), other.domainId()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.lastUpdatedAt(), other.lastUpdatedAt()) && Objects.equals(this.lastUpdatedBy(), other.lastUpdatedBy()) && Objects.equals(this.name(), other.name()) && this.hasOwners() == other.hasOwners() && Objects.equals(this.owners(), other.owners()) && Objects.equals(this.parentDomainUnitId(), other.parentDomainUnitId());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateDomainUnitResponse").add("CreatedAt", (Object)this.createdAt()).add("CreatedBy", (Object)this.createdBy()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("DomainId", (Object)this.domainId()).add("Id", (Object)this.id()).add("LastUpdatedAt", (Object)this.lastUpdatedAt()).add("LastUpdatedBy", (Object)this.lastUpdatedBy()).add("Name", (Object)(this.name() == null ? null : "*** Sensitive Data Redacted ***")).add("Owners", this.hasOwners() ? this.owners() : null).add("ParentDomainUnitId", (Object)this.parentDomainUnitId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "createdBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "domainId": {
                return Optional.ofNullable(clazz.cast(this.domainId()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "lastUpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedAt()));
            }
            case "lastUpdatedBy": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedBy()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "owners": {
                return Optional.ofNullable(clazz.cast(this.owners()));
            }
            case "parentDomainUnitId": {
                return Optional.ofNullable(clazz.cast(this.parentDomainUnitId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateDomainUnitResponse, T> g) {
        return obj -> g.apply((UpdateDomainUnitResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataZoneResponse.BuilderImpl
    implements Builder {
        private Instant createdAt;
        private String createdBy;
        private String description;
        private String domainId;
        private String id;
        private Instant lastUpdatedAt;
        private String lastUpdatedBy;
        private String name;
        private List<DomainUnitOwnerProperties> owners = DefaultSdkAutoConstructList.getInstance();
        private String parentDomainUnitId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDomainUnitResponse model) {
            super(model);
            this.createdAt(model.createdAt);
            this.createdBy(model.createdBy);
            this.description(model.description);
            this.domainId(model.domainId);
            this.id(model.id);
            this.lastUpdatedAt(model.lastUpdatedAt);
            this.lastUpdatedBy(model.lastUpdatedBy);
            this.name(model.name);
            this.owners(model.owners);
            this.parentDomainUnitId(model.parentDomainUnitId);
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getCreatedBy() {
            return this.createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDomainId() {
            return this.domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return this.lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final String getLastUpdatedBy() {
            return this.lastUpdatedBy;
        }

        public final void setLastUpdatedBy(String lastUpdatedBy) {
            this.lastUpdatedBy = lastUpdatedBy;
        }

        @Override
        public final Builder lastUpdatedBy(String lastUpdatedBy) {
            this.lastUpdatedBy = lastUpdatedBy;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<DomainUnitOwnerProperties.Builder> getOwners() {
            List<DomainUnitOwnerProperties.Builder> result = DomainUnitOwnersCopier.copyToBuilder(this.owners);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOwners(Collection<DomainUnitOwnerProperties.BuilderImpl> owners) {
            this.owners = DomainUnitOwnersCopier.copyFromBuilder(owners);
        }

        @Override
        public final Builder owners(Collection<DomainUnitOwnerProperties> owners) {
            this.owners = DomainUnitOwnersCopier.copy(owners);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder owners(DomainUnitOwnerProperties ... owners) {
            this.owners(Arrays.asList(owners));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder owners(Consumer<DomainUnitOwnerProperties.Builder> ... owners) {
            this.owners(Stream.of(owners).map(c -> (DomainUnitOwnerProperties)((DomainUnitOwnerProperties.Builder)DomainUnitOwnerProperties.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getParentDomainUnitId() {
            return this.parentDomainUnitId;
        }

        public final void setParentDomainUnitId(String parentDomainUnitId) {
            this.parentDomainUnitId = parentDomainUnitId;
        }

        @Override
        public final Builder parentDomainUnitId(String parentDomainUnitId) {
            this.parentDomainUnitId = parentDomainUnitId;
            return this;
        }

        @Override
        public UpdateDomainUnitResponse build() {
            return new UpdateDomainUnitResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DataZoneResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateDomainUnitResponse> {
        public Builder createdAt(Instant var1);

        public Builder createdBy(String var1);

        public Builder description(String var1);

        public Builder domainId(String var1);

        public Builder id(String var1);

        public Builder lastUpdatedAt(Instant var1);

        public Builder lastUpdatedBy(String var1);

        public Builder name(String var1);

        public Builder owners(Collection<DomainUnitOwnerProperties> var1);

        public Builder owners(DomainUnitOwnerProperties ... var1);

        public Builder owners(Consumer<DomainUnitOwnerProperties.Builder> ... var1);

        public Builder parentDomainUnitId(String var1);
    }
}

