/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.datazone.model.DataZoneRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteProjectRequest
extends DataZoneRequest
implements ToCopyableBuilder<Builder, DeleteProjectRequest> {
    private static final SdkField<String> DOMAIN_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainIdentifier").getter(DeleteProjectRequest.getter(DeleteProjectRequest::domainIdentifier)).setter(DeleteProjectRequest.setter(Builder::domainIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainIdentifier").build()}).build();
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("identifier").getter(DeleteProjectRequest.getter(DeleteProjectRequest::identifier)).setter(DeleteProjectRequest.setter(Builder::identifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("identifier").build()}).build();
    private static final SdkField<Boolean> SKIP_DELETION_CHECK_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("skipDeletionCheck").getter(DeleteProjectRequest.getter(DeleteProjectRequest::skipDeletionCheck)).setter(DeleteProjectRequest.setter(Builder::skipDeletionCheck)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("skipDeletionCheck").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_IDENTIFIER_FIELD, IDENTIFIER_FIELD, SKIP_DELETION_CHECK_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("domainIdentifier", DOMAIN_IDENTIFIER_FIELD);
            this.put("identifier", IDENTIFIER_FIELD);
            this.put("skipDeletionCheck", SKIP_DELETION_CHECK_FIELD);
        }
    });
    private final String domainIdentifier;
    private final String identifier;
    private final Boolean skipDeletionCheck;

    private DeleteProjectRequest(BuilderImpl builder) {
        super(builder);
        this.domainIdentifier = builder.domainIdentifier;
        this.identifier = builder.identifier;
        this.skipDeletionCheck = builder.skipDeletionCheck;
    }

    public final String domainIdentifier() {
        return this.domainIdentifier;
    }

    public final String identifier() {
        return this.identifier;
    }

    public final Boolean skipDeletionCheck() {
        return this.skipDeletionCheck;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domainIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.identifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.skipDeletionCheck());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteProjectRequest)) {
            return false;
        }
        DeleteProjectRequest other = (DeleteProjectRequest)((Object)obj);
        return Objects.equals(this.domainIdentifier(), other.domainIdentifier()) && Objects.equals(this.identifier(), other.identifier()) && Objects.equals(this.skipDeletionCheck(), other.skipDeletionCheck());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteProjectRequest").add("DomainIdentifier", (Object)this.domainIdentifier()).add("Identifier", (Object)this.identifier()).add("SkipDeletionCheck", (Object)this.skipDeletionCheck()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "domainIdentifier": {
                return Optional.ofNullable(clazz.cast(this.domainIdentifier()));
            }
            case "identifier": {
                return Optional.ofNullable(clazz.cast(this.identifier()));
            }
            case "skipDeletionCheck": {
                return Optional.ofNullable(clazz.cast(this.skipDeletionCheck()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DeleteProjectRequest, T> g) {
        return obj -> g.apply((DeleteProjectRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataZoneRequest.BuilderImpl
    implements Builder {
        private String domainIdentifier;
        private String identifier;
        private Boolean skipDeletionCheck;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteProjectRequest model) {
            super(model);
            this.domainIdentifier(model.domainIdentifier);
            this.identifier(model.identifier);
            this.skipDeletionCheck(model.skipDeletionCheck);
        }

        public final String getDomainIdentifier() {
            return this.domainIdentifier;
        }

        public final void setDomainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
        }

        @Override
        public final Builder domainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        public final String getIdentifier() {
            return this.identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final Boolean getSkipDeletionCheck() {
            return this.skipDeletionCheck;
        }

        public final void setSkipDeletionCheck(Boolean skipDeletionCheck) {
            this.skipDeletionCheck = skipDeletionCheck;
        }

        @Override
        public final Builder skipDeletionCheck(Boolean skipDeletionCheck) {
            this.skipDeletionCheck = skipDeletionCheck;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteProjectRequest build() {
            return new DeleteProjectRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DataZoneRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteProjectRequest> {
        public Builder domainIdentifier(String var1);

        public Builder identifier(String var1);

        public Builder skipDeletionCheck(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

