/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.datazone.model.DataZoneRequest;
import software.amazon.awssdk.services.datazone.model.SingleSignOn;
import software.amazon.awssdk.services.datazone.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDomainRequest
extends DataZoneRequest
implements ToCopyableBuilder<Builder, CreateDomainRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateDomainRequest.getter(CreateDomainRequest::clientToken)).setter(CreateDomainRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateDomainRequest.getter(CreateDomainRequest::description)).setter(CreateDomainRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> DOMAIN_EXECUTION_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainExecutionRole").getter(CreateDomainRequest.getter(CreateDomainRequest::domainExecutionRole)).setter(CreateDomainRequest.setter(Builder::domainExecutionRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainExecutionRole").build()}).build();
    private static final SdkField<String> KMS_KEY_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("kmsKeyIdentifier").getter(CreateDomainRequest.getter(CreateDomainRequest::kmsKeyIdentifier)).setter(CreateDomainRequest.setter(Builder::kmsKeyIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyIdentifier").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateDomainRequest.getter(CreateDomainRequest::name)).setter(CreateDomainRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<SingleSignOn> SINGLE_SIGN_ON_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("singleSignOn").getter(CreateDomainRequest.getter(CreateDomainRequest::singleSignOn)).setter(CreateDomainRequest.setter(Builder::singleSignOn)).constructor(SingleSignOn::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("singleSignOn").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateDomainRequest.getter(CreateDomainRequest::tags)).setter(CreateDomainRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, DESCRIPTION_FIELD, DOMAIN_EXECUTION_ROLE_FIELD, KMS_KEY_IDENTIFIER_FIELD, NAME_FIELD, SINGLE_SIGN_ON_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("clientToken", CLIENT_TOKEN_FIELD);
            this.put("description", DESCRIPTION_FIELD);
            this.put("domainExecutionRole", DOMAIN_EXECUTION_ROLE_FIELD);
            this.put("kmsKeyIdentifier", KMS_KEY_IDENTIFIER_FIELD);
            this.put("name", NAME_FIELD);
            this.put("singleSignOn", SINGLE_SIGN_ON_FIELD);
            this.put("tags", TAGS_FIELD);
        }
    });
    private final String clientToken;
    private final String description;
    private final String domainExecutionRole;
    private final String kmsKeyIdentifier;
    private final String name;
    private final SingleSignOn singleSignOn;
    private final Map<String, String> tags;

    private CreateDomainRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.description = builder.description;
        this.domainExecutionRole = builder.domainExecutionRole;
        this.kmsKeyIdentifier = builder.kmsKeyIdentifier;
        this.name = builder.name;
        this.singleSignOn = builder.singleSignOn;
        this.tags = builder.tags;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String description() {
        return this.description;
    }

    public final String domainExecutionRole() {
        return this.domainExecutionRole;
    }

    public final String kmsKeyIdentifier() {
        return this.kmsKeyIdentifier;
    }

    public final String name() {
        return this.name;
    }

    public final SingleSignOn singleSignOn() {
        return this.singleSignOn;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainExecutionRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.singleSignOn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDomainRequest)) {
            return false;
        }
        CreateDomainRequest other = (CreateDomainRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.domainExecutionRole(), other.domainExecutionRole()) && Objects.equals(this.kmsKeyIdentifier(), other.kmsKeyIdentifier()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.singleSignOn(), other.singleSignOn()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateDomainRequest").add("ClientToken", (Object)this.clientToken()).add("Description", (Object)this.description()).add("DomainExecutionRole", (Object)this.domainExecutionRole()).add("KmsKeyIdentifier", (Object)this.kmsKeyIdentifier()).add("Name", (Object)this.name()).add("SingleSignOn", (Object)this.singleSignOn()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "domainExecutionRole": {
                return Optional.ofNullable(clazz.cast(this.domainExecutionRole()));
            }
            case "kmsKeyIdentifier": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyIdentifier()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "singleSignOn": {
                return Optional.ofNullable(clazz.cast(this.singleSignOn()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateDomainRequest, T> g) {
        return obj -> g.apply((CreateDomainRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataZoneRequest.BuilderImpl
    implements Builder {
        private String clientToken;
        private String description;
        private String domainExecutionRole;
        private String kmsKeyIdentifier;
        private String name;
        private SingleSignOn singleSignOn;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDomainRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.description(model.description);
            this.domainExecutionRole(model.domainExecutionRole);
            this.kmsKeyIdentifier(model.kmsKeyIdentifier);
            this.name(model.name);
            this.singleSignOn(model.singleSignOn);
            this.tags(model.tags);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDomainExecutionRole() {
            return this.domainExecutionRole;
        }

        public final void setDomainExecutionRole(String domainExecutionRole) {
            this.domainExecutionRole = domainExecutionRole;
        }

        @Override
        public final Builder domainExecutionRole(String domainExecutionRole) {
            this.domainExecutionRole = domainExecutionRole;
            return this;
        }

        public final String getKmsKeyIdentifier() {
            return this.kmsKeyIdentifier;
        }

        public final void setKmsKeyIdentifier(String kmsKeyIdentifier) {
            this.kmsKeyIdentifier = kmsKeyIdentifier;
        }

        @Override
        public final Builder kmsKeyIdentifier(String kmsKeyIdentifier) {
            this.kmsKeyIdentifier = kmsKeyIdentifier;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final SingleSignOn.Builder getSingleSignOn() {
            return this.singleSignOn != null ? this.singleSignOn.toBuilder() : null;
        }

        public final void setSingleSignOn(SingleSignOn.BuilderImpl singleSignOn) {
            this.singleSignOn = singleSignOn != null ? singleSignOn.build() : null;
        }

        @Override
        public final Builder singleSignOn(SingleSignOn singleSignOn) {
            this.singleSignOn = singleSignOn;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDomainRequest build() {
            return new CreateDomainRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DataZoneRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateDomainRequest> {
        public Builder clientToken(String var1);

        public Builder description(String var1);

        public Builder domainExecutionRole(String var1);

        public Builder kmsKeyIdentifier(String var1);

        public Builder name(String var1);

        public Builder singleSignOn(SingleSignOn var1);

        default public Builder singleSignOn(Consumer<SingleSignOn.Builder> singleSignOn) {
            return this.singleSignOn((SingleSignOn)((SingleSignOn.Builder)SingleSignOn.builder().applyMutation(singleSignOn)).build());
        }

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

