/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datazone.model.RelationalFilterConfiguration;
import software.amazon.awssdk.services.datazone.model.RelationalFilterConfigurationsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GlueRunConfigurationInput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GlueRunConfigurationInput> {
    private static final SdkField<Boolean> AUTO_IMPORT_DATA_QUALITY_RESULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("autoImportDataQualityResult").getter(GlueRunConfigurationInput.getter(GlueRunConfigurationInput::autoImportDataQualityResult)).setter(GlueRunConfigurationInput.setter(Builder::autoImportDataQualityResult)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoImportDataQualityResult").build()}).build();
    private static final SdkField<String> DATA_ACCESS_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dataAccessRole").getter(GlueRunConfigurationInput.getter(GlueRunConfigurationInput::dataAccessRole)).setter(GlueRunConfigurationInput.setter(Builder::dataAccessRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataAccessRole").build()}).build();
    private static final SdkField<List<RelationalFilterConfiguration>> RELATIONAL_FILTER_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("relationalFilterConfigurations").getter(GlueRunConfigurationInput.getter(GlueRunConfigurationInput::relationalFilterConfigurations)).setter(GlueRunConfigurationInput.setter(Builder::relationalFilterConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relationalFilterConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RelationalFilterConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_IMPORT_DATA_QUALITY_RESULT_FIELD, DATA_ACCESS_ROLE_FIELD, RELATIONAL_FILTER_CONFIGURATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("autoImportDataQualityResult", AUTO_IMPORT_DATA_QUALITY_RESULT_FIELD);
            this.put("dataAccessRole", DATA_ACCESS_ROLE_FIELD);
            this.put("relationalFilterConfigurations", RELATIONAL_FILTER_CONFIGURATIONS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Boolean autoImportDataQualityResult;
    private final String dataAccessRole;
    private final List<RelationalFilterConfiguration> relationalFilterConfigurations;

    private GlueRunConfigurationInput(BuilderImpl builder) {
        this.autoImportDataQualityResult = builder.autoImportDataQualityResult;
        this.dataAccessRole = builder.dataAccessRole;
        this.relationalFilterConfigurations = builder.relationalFilterConfigurations;
    }

    public final Boolean autoImportDataQualityResult() {
        return this.autoImportDataQualityResult;
    }

    public final String dataAccessRole() {
        return this.dataAccessRole;
    }

    public final boolean hasRelationalFilterConfigurations() {
        return this.relationalFilterConfigurations != null && !(this.relationalFilterConfigurations instanceof SdkAutoConstructList);
    }

    public final List<RelationalFilterConfiguration> relationalFilterConfigurations() {
        return this.relationalFilterConfigurations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.autoImportDataQualityResult());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataAccessRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRelationalFilterConfigurations() ? this.relationalFilterConfigurations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GlueRunConfigurationInput)) {
            return false;
        }
        GlueRunConfigurationInput other = (GlueRunConfigurationInput)obj;
        return Objects.equals(this.autoImportDataQualityResult(), other.autoImportDataQualityResult()) && Objects.equals(this.dataAccessRole(), other.dataAccessRole()) && this.hasRelationalFilterConfigurations() == other.hasRelationalFilterConfigurations() && Objects.equals(this.relationalFilterConfigurations(), other.relationalFilterConfigurations());
    }

    public final String toString() {
        return ToString.builder((String)"GlueRunConfigurationInput").add("AutoImportDataQualityResult", (Object)this.autoImportDataQualityResult()).add("DataAccessRole", (Object)this.dataAccessRole()).add("RelationalFilterConfigurations", this.hasRelationalFilterConfigurations() ? this.relationalFilterConfigurations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "autoImportDataQualityResult": {
                return Optional.ofNullable(clazz.cast(this.autoImportDataQualityResult()));
            }
            case "dataAccessRole": {
                return Optional.ofNullable(clazz.cast(this.dataAccessRole()));
            }
            case "relationalFilterConfigurations": {
                return Optional.ofNullable(clazz.cast(this.relationalFilterConfigurations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GlueRunConfigurationInput, T> g) {
        return obj -> g.apply((GlueRunConfigurationInput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean autoImportDataQualityResult;
        private String dataAccessRole;
        private List<RelationalFilterConfiguration> relationalFilterConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GlueRunConfigurationInput model) {
            this.autoImportDataQualityResult(model.autoImportDataQualityResult);
            this.dataAccessRole(model.dataAccessRole);
            this.relationalFilterConfigurations(model.relationalFilterConfigurations);
        }

        public final Boolean getAutoImportDataQualityResult() {
            return this.autoImportDataQualityResult;
        }

        public final void setAutoImportDataQualityResult(Boolean autoImportDataQualityResult) {
            this.autoImportDataQualityResult = autoImportDataQualityResult;
        }

        @Override
        public final Builder autoImportDataQualityResult(Boolean autoImportDataQualityResult) {
            this.autoImportDataQualityResult = autoImportDataQualityResult;
            return this;
        }

        public final String getDataAccessRole() {
            return this.dataAccessRole;
        }

        public final void setDataAccessRole(String dataAccessRole) {
            this.dataAccessRole = dataAccessRole;
        }

        @Override
        public final Builder dataAccessRole(String dataAccessRole) {
            this.dataAccessRole = dataAccessRole;
            return this;
        }

        public final List<RelationalFilterConfiguration.Builder> getRelationalFilterConfigurations() {
            List<RelationalFilterConfiguration.Builder> result = RelationalFilterConfigurationsCopier.copyToBuilder(this.relationalFilterConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRelationalFilterConfigurations(Collection<RelationalFilterConfiguration.BuilderImpl> relationalFilterConfigurations) {
            this.relationalFilterConfigurations = RelationalFilterConfigurationsCopier.copyFromBuilder(relationalFilterConfigurations);
        }

        @Override
        public final Builder relationalFilterConfigurations(Collection<RelationalFilterConfiguration> relationalFilterConfigurations) {
            this.relationalFilterConfigurations = RelationalFilterConfigurationsCopier.copy(relationalFilterConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relationalFilterConfigurations(RelationalFilterConfiguration ... relationalFilterConfigurations) {
            this.relationalFilterConfigurations(Arrays.asList(relationalFilterConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relationalFilterConfigurations(Consumer<RelationalFilterConfiguration.Builder> ... relationalFilterConfigurations) {
            this.relationalFilterConfigurations(Stream.of(relationalFilterConfigurations).map(c -> (RelationalFilterConfiguration)((RelationalFilterConfiguration.Builder)RelationalFilterConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public GlueRunConfigurationInput build() {
            return new GlueRunConfigurationInput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GlueRunConfigurationInput> {
        public Builder autoImportDataQualityResult(Boolean var1);

        public Builder dataAccessRole(String var1);

        public Builder relationalFilterConfigurations(Collection<RelationalFilterConfiguration> var1);

        public Builder relationalFilterConfigurations(RelationalFilterConfiguration ... var1);

        public Builder relationalFilterConfigurations(Consumer<RelationalFilterConfiguration.Builder> ... var1);
    }
}

