/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.datazone.model.ChangeAction;
import software.amazon.awssdk.services.datazone.model.DataZoneRequest;
import software.amazon.awssdk.services.datazone.model.EntityType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateListingChangeSetRequest
extends DataZoneRequest
implements ToCopyableBuilder<Builder, CreateListingChangeSetRequest> {
    private static final SdkField<String> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("action").getter(CreateListingChangeSetRequest.getter(CreateListingChangeSetRequest::actionAsString)).setter(CreateListingChangeSetRequest.setter(Builder::action)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateListingChangeSetRequest.getter(CreateListingChangeSetRequest::clientToken)).setter(CreateListingChangeSetRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> DOMAIN_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainIdentifier").getter(CreateListingChangeSetRequest.getter(CreateListingChangeSetRequest::domainIdentifier)).setter(CreateListingChangeSetRequest.setter(Builder::domainIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainIdentifier").build()}).build();
    private static final SdkField<String> ENTITY_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("entityIdentifier").getter(CreateListingChangeSetRequest.getter(CreateListingChangeSetRequest::entityIdentifier)).setter(CreateListingChangeSetRequest.setter(Builder::entityIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entityIdentifier").build()}).build();
    private static final SdkField<String> ENTITY_REVISION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("entityRevision").getter(CreateListingChangeSetRequest.getter(CreateListingChangeSetRequest::entityRevision)).setter(CreateListingChangeSetRequest.setter(Builder::entityRevision)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entityRevision").build()}).build();
    private static final SdkField<String> ENTITY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("entityType").getter(CreateListingChangeSetRequest.getter(CreateListingChangeSetRequest::entityTypeAsString)).setter(CreateListingChangeSetRequest.setter(Builder::entityType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entityType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD, CLIENT_TOKEN_FIELD, DOMAIN_IDENTIFIER_FIELD, ENTITY_IDENTIFIER_FIELD, ENTITY_REVISION_FIELD, ENTITY_TYPE_FIELD));
    private final String action;
    private final String clientToken;
    private final String domainIdentifier;
    private final String entityIdentifier;
    private final String entityRevision;
    private final String entityType;

    private CreateListingChangeSetRequest(BuilderImpl builder) {
        super(builder);
        this.action = builder.action;
        this.clientToken = builder.clientToken;
        this.domainIdentifier = builder.domainIdentifier;
        this.entityIdentifier = builder.entityIdentifier;
        this.entityRevision = builder.entityRevision;
        this.entityType = builder.entityType;
    }

    public final ChangeAction action() {
        return ChangeAction.fromValue(this.action);
    }

    public final String actionAsString() {
        return this.action;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String domainIdentifier() {
        return this.domainIdentifier;
    }

    public final String entityIdentifier() {
        return this.entityIdentifier;
    }

    public final String entityRevision() {
        return this.entityRevision;
    }

    public final EntityType entityType() {
        return EntityType.fromValue(this.entityType);
    }

    public final String entityTypeAsString() {
        return this.entityType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.entityIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.entityRevision());
        hashCode = 31 * hashCode + Objects.hashCode(this.entityTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateListingChangeSetRequest)) {
            return false;
        }
        CreateListingChangeSetRequest other = (CreateListingChangeSetRequest)((Object)obj);
        return Objects.equals(this.actionAsString(), other.actionAsString()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.domainIdentifier(), other.domainIdentifier()) && Objects.equals(this.entityIdentifier(), other.entityIdentifier()) && Objects.equals(this.entityRevision(), other.entityRevision()) && Objects.equals(this.entityTypeAsString(), other.entityTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CreateListingChangeSetRequest").add("Action", (Object)this.actionAsString()).add("ClientToken", (Object)this.clientToken()).add("DomainIdentifier", (Object)this.domainIdentifier()).add("EntityIdentifier", (Object)this.entityIdentifier()).add("EntityRevision", (Object)this.entityRevision()).add("EntityType", (Object)this.entityTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "action": {
                return Optional.ofNullable(clazz.cast(this.actionAsString()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "domainIdentifier": {
                return Optional.ofNullable(clazz.cast(this.domainIdentifier()));
            }
            case "entityIdentifier": {
                return Optional.ofNullable(clazz.cast(this.entityIdentifier()));
            }
            case "entityRevision": {
                return Optional.ofNullable(clazz.cast(this.entityRevision()));
            }
            case "entityType": {
                return Optional.ofNullable(clazz.cast(this.entityTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateListingChangeSetRequest, T> g) {
        return obj -> g.apply((CreateListingChangeSetRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataZoneRequest.BuilderImpl
    implements Builder {
        private String action;
        private String clientToken;
        private String domainIdentifier;
        private String entityIdentifier;
        private String entityRevision;
        private String entityType;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateListingChangeSetRequest model) {
            super(model);
            this.action(model.action);
            this.clientToken(model.clientToken);
            this.domainIdentifier(model.domainIdentifier);
            this.entityIdentifier(model.entityIdentifier);
            this.entityRevision(model.entityRevision);
            this.entityType(model.entityType);
        }

        public final String getAction() {
            return this.action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(ChangeAction action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDomainIdentifier() {
            return this.domainIdentifier;
        }

        public final void setDomainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
        }

        @Override
        public final Builder domainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        public final String getEntityIdentifier() {
            return this.entityIdentifier;
        }

        public final void setEntityIdentifier(String entityIdentifier) {
            this.entityIdentifier = entityIdentifier;
        }

        @Override
        public final Builder entityIdentifier(String entityIdentifier) {
            this.entityIdentifier = entityIdentifier;
            return this;
        }

        public final String getEntityRevision() {
            return this.entityRevision;
        }

        public final void setEntityRevision(String entityRevision) {
            this.entityRevision = entityRevision;
        }

        @Override
        public final Builder entityRevision(String entityRevision) {
            this.entityRevision = entityRevision;
            return this;
        }

        public final String getEntityType() {
            return this.entityType;
        }

        public final void setEntityType(String entityType) {
            this.entityType = entityType;
        }

        @Override
        public final Builder entityType(String entityType) {
            this.entityType = entityType;
            return this;
        }

        @Override
        public final Builder entityType(EntityType entityType) {
            this.entityType(entityType == null ? null : entityType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateListingChangeSetRequest build() {
            return new CreateListingChangeSetRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DataZoneRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateListingChangeSetRequest> {
        public Builder action(String var1);

        public Builder action(ChangeAction var1);

        public Builder clientToken(String var1);

        public Builder domainIdentifier(String var1);

        public Builder entityIdentifier(String var1);

        public Builder entityRevision(String var1);

        public Builder entityType(String var1);

        public Builder entityType(EntityType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

