/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datazone.model.ColumnNameListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ColumnFilterConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ColumnFilterConfiguration> {
    private static final SdkField<List<String>> INCLUDED_COLUMN_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("includedColumnNames").getter(ColumnFilterConfiguration.getter(ColumnFilterConfiguration::includedColumnNames)).setter(ColumnFilterConfiguration.setter(Builder::includedColumnNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("includedColumnNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INCLUDED_COLUMN_NAMES_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> includedColumnNames;

    private ColumnFilterConfiguration(BuilderImpl builder) {
        this.includedColumnNames = builder.includedColumnNames;
    }

    public final boolean hasIncludedColumnNames() {
        return this.includedColumnNames != null && !(this.includedColumnNames instanceof SdkAutoConstructList);
    }

    public final List<String> includedColumnNames() {
        return this.includedColumnNames;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIncludedColumnNames() ? this.includedColumnNames() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ColumnFilterConfiguration)) {
            return false;
        }
        ColumnFilterConfiguration other = (ColumnFilterConfiguration)obj;
        return this.hasIncludedColumnNames() == other.hasIncludedColumnNames() && Objects.equals(this.includedColumnNames(), other.includedColumnNames());
    }

    public final String toString() {
        return ToString.builder((String)"ColumnFilterConfiguration").add("IncludedColumnNames", this.hasIncludedColumnNames() ? this.includedColumnNames() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "includedColumnNames": {
                return Optional.ofNullable(clazz.cast(this.includedColumnNames()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ColumnFilterConfiguration, T> g) {
        return obj -> g.apply((ColumnFilterConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> includedColumnNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ColumnFilterConfiguration model) {
            this.includedColumnNames(model.includedColumnNames);
        }

        public final Collection<String> getIncludedColumnNames() {
            if (this.includedColumnNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.includedColumnNames;
        }

        public final void setIncludedColumnNames(Collection<String> includedColumnNames) {
            this.includedColumnNames = ColumnNameListCopier.copy(includedColumnNames);
        }

        @Override
        public final Builder includedColumnNames(Collection<String> includedColumnNames) {
            this.includedColumnNames = ColumnNameListCopier.copy(includedColumnNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder includedColumnNames(String ... includedColumnNames) {
            this.includedColumnNames(Arrays.asList(includedColumnNames));
            return this;
        }

        public ColumnFilterConfiguration build() {
            return new ColumnFilterConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ColumnFilterConfiguration> {
        public Builder includedColumnNames(Collection<String> var1);

        public Builder includedColumnNames(String ... var1);
    }
}

