/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.datazone.DataZoneAsyncClient;
import software.amazon.awssdk.services.datazone.internal.UserAgentUtils;
import software.amazon.awssdk.services.datazone.model.EnvironmentBlueprintSummary;
import software.amazon.awssdk.services.datazone.model.ListEnvironmentBlueprintsRequest;
import software.amazon.awssdk.services.datazone.model.ListEnvironmentBlueprintsResponse;

public class ListEnvironmentBlueprintsPublisher
implements SdkPublisher<ListEnvironmentBlueprintsResponse> {
    private final DataZoneAsyncClient client;
    private final ListEnvironmentBlueprintsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListEnvironmentBlueprintsPublisher(DataZoneAsyncClient client, ListEnvironmentBlueprintsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListEnvironmentBlueprintsPublisher(DataZoneAsyncClient client, ListEnvironmentBlueprintsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListEnvironmentBlueprintsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListEnvironmentBlueprintsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<EnvironmentBlueprintSummary> items() {
        Function<ListEnvironmentBlueprintsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListEnvironmentBlueprintsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListEnvironmentBlueprintsResponseFetcher
    implements AsyncPageFetcher<ListEnvironmentBlueprintsResponse> {
        private ListEnvironmentBlueprintsResponseFetcher() {
        }

        public boolean hasNextPage(ListEnvironmentBlueprintsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListEnvironmentBlueprintsResponse> nextPage(ListEnvironmentBlueprintsResponse previousPage) {
            if (previousPage == null) {
                return ListEnvironmentBlueprintsPublisher.this.client.listEnvironmentBlueprints(ListEnvironmentBlueprintsPublisher.this.firstRequest);
            }
            return ListEnvironmentBlueprintsPublisher.this.client.listEnvironmentBlueprints((ListEnvironmentBlueprintsRequest)((Object)ListEnvironmentBlueprintsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

