/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DataAssetActivityStatus {
    FAILED("FAILED"),
    PUBLISHING_FAILED("PUBLISHING_FAILED"),
    SUCCEEDED_CREATED("SUCCEEDED_CREATED"),
    SUCCEEDED_UPDATED("SUCCEEDED_UPDATED"),
    SKIPPED_ALREADY_IMPORTED("SKIPPED_ALREADY_IMPORTED"),
    SKIPPED_ARCHIVED("SKIPPED_ARCHIVED"),
    SKIPPED_NO_ACCESS("SKIPPED_NO_ACCESS"),
    UNCHANGED("UNCHANGED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DataAssetActivityStatus> VALUE_MAP;
    private final String value;

    private DataAssetActivityStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DataAssetActivityStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DataAssetActivityStatus> knownValues() {
        EnumSet<DataAssetActivityStatus> knownValues = EnumSet.allOf(DataAssetActivityStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DataAssetActivityStatus.class, DataAssetActivityStatus::toString);
    }
}

