/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datazone.model.DataSourceConfigurationInput;
import software.amazon.awssdk.services.datazone.model.DataZoneRequest;
import software.amazon.awssdk.services.datazone.model.EnableSetting;
import software.amazon.awssdk.services.datazone.model.FormInput;
import software.amazon.awssdk.services.datazone.model.FormInputListCopier;
import software.amazon.awssdk.services.datazone.model.RecommendationConfiguration;
import software.amazon.awssdk.services.datazone.model.ScheduleConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateDataSourceRequest
extends DataZoneRequest
implements ToCopyableBuilder<Builder, UpdateDataSourceRequest> {
    private static final SdkField<List<FormInput>> ASSET_FORMS_INPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("assetFormsInput").getter(UpdateDataSourceRequest.getter(UpdateDataSourceRequest::assetFormsInput)).setter(UpdateDataSourceRequest.setter(Builder::assetFormsInput)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetFormsInput").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FormInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<DataSourceConfigurationInput> CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("configuration").getter(UpdateDataSourceRequest.getter(UpdateDataSourceRequest::configuration)).setter(UpdateDataSourceRequest.setter(Builder::configuration)).constructor(DataSourceConfigurationInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(UpdateDataSourceRequest.getter(UpdateDataSourceRequest::description)).setter(UpdateDataSourceRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> DOMAIN_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainIdentifier").getter(UpdateDataSourceRequest.getter(UpdateDataSourceRequest::domainIdentifier)).setter(UpdateDataSourceRequest.setter(Builder::domainIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainIdentifier").build()}).build();
    private static final SdkField<String> ENABLE_SETTING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("enableSetting").getter(UpdateDataSourceRequest.getter(UpdateDataSourceRequest::enableSettingAsString)).setter(UpdateDataSourceRequest.setter(Builder::enableSetting)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableSetting").build()}).build();
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("identifier").getter(UpdateDataSourceRequest.getter(UpdateDataSourceRequest::identifier)).setter(UpdateDataSourceRequest.setter(Builder::identifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("identifier").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(UpdateDataSourceRequest.getter(UpdateDataSourceRequest::name)).setter(UpdateDataSourceRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<Boolean> PUBLISH_ON_IMPORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("publishOnImport").getter(UpdateDataSourceRequest.getter(UpdateDataSourceRequest::publishOnImport)).setter(UpdateDataSourceRequest.setter(Builder::publishOnImport)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publishOnImport").build()}).build();
    private static final SdkField<RecommendationConfiguration> RECOMMENDATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("recommendation").getter(UpdateDataSourceRequest.getter(UpdateDataSourceRequest::recommendation)).setter(UpdateDataSourceRequest.setter(Builder::recommendation)).constructor(RecommendationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendation").build()}).build();
    private static final SdkField<Boolean> RETAIN_PERMISSIONS_ON_REVOKE_FAILURE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("retainPermissionsOnRevokeFailure").getter(UpdateDataSourceRequest.getter(UpdateDataSourceRequest::retainPermissionsOnRevokeFailure)).setter(UpdateDataSourceRequest.setter(Builder::retainPermissionsOnRevokeFailure)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retainPermissionsOnRevokeFailure").build()}).build();
    private static final SdkField<ScheduleConfiguration> SCHEDULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("schedule").getter(UpdateDataSourceRequest.getter(UpdateDataSourceRequest::schedule)).setter(UpdateDataSourceRequest.setter(Builder::schedule)).constructor(ScheduleConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schedule").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_FORMS_INPUT_FIELD, CONFIGURATION_FIELD, DESCRIPTION_FIELD, DOMAIN_IDENTIFIER_FIELD, ENABLE_SETTING_FIELD, IDENTIFIER_FIELD, NAME_FIELD, PUBLISH_ON_IMPORT_FIELD, RECOMMENDATION_FIELD, RETAIN_PERMISSIONS_ON_REVOKE_FAILURE_FIELD, SCHEDULE_FIELD));
    private final List<FormInput> assetFormsInput;
    private final DataSourceConfigurationInput configuration;
    private final String description;
    private final String domainIdentifier;
    private final String enableSetting;
    private final String identifier;
    private final String name;
    private final Boolean publishOnImport;
    private final RecommendationConfiguration recommendation;
    private final Boolean retainPermissionsOnRevokeFailure;
    private final ScheduleConfiguration schedule;

    private UpdateDataSourceRequest(BuilderImpl builder) {
        super(builder);
        this.assetFormsInput = builder.assetFormsInput;
        this.configuration = builder.configuration;
        this.description = builder.description;
        this.domainIdentifier = builder.domainIdentifier;
        this.enableSetting = builder.enableSetting;
        this.identifier = builder.identifier;
        this.name = builder.name;
        this.publishOnImport = builder.publishOnImport;
        this.recommendation = builder.recommendation;
        this.retainPermissionsOnRevokeFailure = builder.retainPermissionsOnRevokeFailure;
        this.schedule = builder.schedule;
    }

    public final boolean hasAssetFormsInput() {
        return this.assetFormsInput != null && !(this.assetFormsInput instanceof SdkAutoConstructList);
    }

    public final List<FormInput> assetFormsInput() {
        return this.assetFormsInput;
    }

    public final DataSourceConfigurationInput configuration() {
        return this.configuration;
    }

    public final String description() {
        return this.description;
    }

    public final String domainIdentifier() {
        return this.domainIdentifier;
    }

    public final EnableSetting enableSetting() {
        return EnableSetting.fromValue(this.enableSetting);
    }

    public final String enableSettingAsString() {
        return this.enableSetting;
    }

    public final String identifier() {
        return this.identifier;
    }

    public final String name() {
        return this.name;
    }

    public final Boolean publishOnImport() {
        return this.publishOnImport;
    }

    public final RecommendationConfiguration recommendation() {
        return this.recommendation;
    }

    public final Boolean retainPermissionsOnRevokeFailure() {
        return this.retainPermissionsOnRevokeFailure;
    }

    public final ScheduleConfiguration schedule() {
        return this.schedule;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssetFormsInput() ? this.assetFormsInput() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.configuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableSettingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.identifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.publishOnImport());
        hashCode = 31 * hashCode + Objects.hashCode(this.recommendation());
        hashCode = 31 * hashCode + Objects.hashCode(this.retainPermissionsOnRevokeFailure());
        hashCode = 31 * hashCode + Objects.hashCode(this.schedule());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDataSourceRequest)) {
            return false;
        }
        UpdateDataSourceRequest other = (UpdateDataSourceRequest)((Object)obj);
        return this.hasAssetFormsInput() == other.hasAssetFormsInput() && Objects.equals(this.assetFormsInput(), other.assetFormsInput()) && Objects.equals(this.configuration(), other.configuration()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.domainIdentifier(), other.domainIdentifier()) && Objects.equals(this.enableSettingAsString(), other.enableSettingAsString()) && Objects.equals(this.identifier(), other.identifier()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.publishOnImport(), other.publishOnImport()) && Objects.equals(this.recommendation(), other.recommendation()) && Objects.equals(this.retainPermissionsOnRevokeFailure(), other.retainPermissionsOnRevokeFailure()) && Objects.equals(this.schedule(), other.schedule());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateDataSourceRequest").add("AssetFormsInput", (Object)(this.assetFormsInput() == null ? null : "*** Sensitive Data Redacted ***")).add("Configuration", (Object)this.configuration()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("DomainIdentifier", (Object)this.domainIdentifier()).add("EnableSetting", (Object)this.enableSettingAsString()).add("Identifier", (Object)this.identifier()).add("Name", (Object)(this.name() == null ? null : "*** Sensitive Data Redacted ***")).add("PublishOnImport", (Object)this.publishOnImport()).add("Recommendation", (Object)this.recommendation()).add("RetainPermissionsOnRevokeFailure", (Object)this.retainPermissionsOnRevokeFailure()).add("Schedule", (Object)(this.schedule() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "assetFormsInput": {
                return Optional.ofNullable(clazz.cast(this.assetFormsInput()));
            }
            case "configuration": {
                return Optional.ofNullable(clazz.cast(this.configuration()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "domainIdentifier": {
                return Optional.ofNullable(clazz.cast(this.domainIdentifier()));
            }
            case "enableSetting": {
                return Optional.ofNullable(clazz.cast(this.enableSettingAsString()));
            }
            case "identifier": {
                return Optional.ofNullable(clazz.cast(this.identifier()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "publishOnImport": {
                return Optional.ofNullable(clazz.cast(this.publishOnImport()));
            }
            case "recommendation": {
                return Optional.ofNullable(clazz.cast(this.recommendation()));
            }
            case "retainPermissionsOnRevokeFailure": {
                return Optional.ofNullable(clazz.cast(this.retainPermissionsOnRevokeFailure()));
            }
            case "schedule": {
                return Optional.ofNullable(clazz.cast(this.schedule()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateDataSourceRequest, T> g) {
        return obj -> g.apply((UpdateDataSourceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataZoneRequest.BuilderImpl
    implements Builder {
        private List<FormInput> assetFormsInput = DefaultSdkAutoConstructList.getInstance();
        private DataSourceConfigurationInput configuration;
        private String description;
        private String domainIdentifier;
        private String enableSetting;
        private String identifier;
        private String name;
        private Boolean publishOnImport;
        private RecommendationConfiguration recommendation;
        private Boolean retainPermissionsOnRevokeFailure;
        private ScheduleConfiguration schedule;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDataSourceRequest model) {
            super(model);
            this.assetFormsInput(model.assetFormsInput);
            this.configuration(model.configuration);
            this.description(model.description);
            this.domainIdentifier(model.domainIdentifier);
            this.enableSetting(model.enableSetting);
            this.identifier(model.identifier);
            this.name(model.name);
            this.publishOnImport(model.publishOnImport);
            this.recommendation(model.recommendation);
            this.retainPermissionsOnRevokeFailure(model.retainPermissionsOnRevokeFailure);
            this.schedule(model.schedule);
        }

        public final List<FormInput.Builder> getAssetFormsInput() {
            List<FormInput.Builder> result = FormInputListCopier.copyToBuilder(this.assetFormsInput);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssetFormsInput(Collection<FormInput.BuilderImpl> assetFormsInput) {
            this.assetFormsInput = FormInputListCopier.copyFromBuilder(assetFormsInput);
        }

        @Override
        public final Builder assetFormsInput(Collection<FormInput> assetFormsInput) {
            this.assetFormsInput = FormInputListCopier.copy(assetFormsInput);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetFormsInput(FormInput ... assetFormsInput) {
            this.assetFormsInput(Arrays.asList(assetFormsInput));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetFormsInput(Consumer<FormInput.Builder> ... assetFormsInput) {
            this.assetFormsInput(Stream.of(assetFormsInput).map(c -> (FormInput)((FormInput.Builder)FormInput.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final DataSourceConfigurationInput.Builder getConfiguration() {
            return this.configuration != null ? this.configuration.toBuilder() : null;
        }

        public final void setConfiguration(DataSourceConfigurationInput.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(DataSourceConfigurationInput configuration) {
            this.configuration = configuration;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDomainIdentifier() {
            return this.domainIdentifier;
        }

        public final void setDomainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
        }

        @Override
        public final Builder domainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        public final String getEnableSetting() {
            return this.enableSetting;
        }

        public final void setEnableSetting(String enableSetting) {
            this.enableSetting = enableSetting;
        }

        @Override
        public final Builder enableSetting(String enableSetting) {
            this.enableSetting = enableSetting;
            return this;
        }

        @Override
        public final Builder enableSetting(EnableSetting enableSetting) {
            this.enableSetting(enableSetting == null ? null : enableSetting.toString());
            return this;
        }

        public final String getIdentifier() {
            return this.identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Boolean getPublishOnImport() {
            return this.publishOnImport;
        }

        public final void setPublishOnImport(Boolean publishOnImport) {
            this.publishOnImport = publishOnImport;
        }

        @Override
        public final Builder publishOnImport(Boolean publishOnImport) {
            this.publishOnImport = publishOnImport;
            return this;
        }

        public final RecommendationConfiguration.Builder getRecommendation() {
            return this.recommendation != null ? this.recommendation.toBuilder() : null;
        }

        public final void setRecommendation(RecommendationConfiguration.BuilderImpl recommendation) {
            this.recommendation = recommendation != null ? recommendation.build() : null;
        }

        @Override
        public final Builder recommendation(RecommendationConfiguration recommendation) {
            this.recommendation = recommendation;
            return this;
        }

        public final Boolean getRetainPermissionsOnRevokeFailure() {
            return this.retainPermissionsOnRevokeFailure;
        }

        public final void setRetainPermissionsOnRevokeFailure(Boolean retainPermissionsOnRevokeFailure) {
            this.retainPermissionsOnRevokeFailure = retainPermissionsOnRevokeFailure;
        }

        @Override
        public final Builder retainPermissionsOnRevokeFailure(Boolean retainPermissionsOnRevokeFailure) {
            this.retainPermissionsOnRevokeFailure = retainPermissionsOnRevokeFailure;
            return this;
        }

        public final ScheduleConfiguration.Builder getSchedule() {
            return this.schedule != null ? this.schedule.toBuilder() : null;
        }

        public final void setSchedule(ScheduleConfiguration.BuilderImpl schedule) {
            this.schedule = schedule != null ? schedule.build() : null;
        }

        @Override
        public final Builder schedule(ScheduleConfiguration schedule) {
            this.schedule = schedule;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDataSourceRequest build() {
            return new UpdateDataSourceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DataZoneRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateDataSourceRequest> {
        public Builder assetFormsInput(Collection<FormInput> var1);

        public Builder assetFormsInput(FormInput ... var1);

        public Builder assetFormsInput(Consumer<FormInput.Builder> ... var1);

        public Builder configuration(DataSourceConfigurationInput var1);

        default public Builder configuration(Consumer<DataSourceConfigurationInput.Builder> configuration) {
            return this.configuration((DataSourceConfigurationInput)((DataSourceConfigurationInput.Builder)DataSourceConfigurationInput.builder().applyMutation(configuration)).build());
        }

        public Builder description(String var1);

        public Builder domainIdentifier(String var1);

        public Builder enableSetting(String var1);

        public Builder enableSetting(EnableSetting var1);

        public Builder identifier(String var1);

        public Builder name(String var1);

        public Builder publishOnImport(Boolean var1);

        public Builder recommendation(RecommendationConfiguration var1);

        default public Builder recommendation(Consumer<RecommendationConfiguration.Builder> recommendation) {
            return this.recommendation((RecommendationConfiguration)((RecommendationConfiguration.Builder)RecommendationConfiguration.builder().applyMutation(recommendation)).build());
        }

        public Builder retainPermissionsOnRevokeFailure(Boolean var1);

        public Builder schedule(ScheduleConfiguration var1);

        default public Builder schedule(Consumer<ScheduleConfiguration.Builder> schedule) {
            return this.schedule((ScheduleConfiguration)((ScheduleConfiguration.Builder)ScheduleConfiguration.builder().applyMutation(schedule)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

