/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.datazone.DataZoneAsyncClient;
import software.amazon.awssdk.services.datazone.internal.UserAgentUtils;
import software.amazon.awssdk.services.datazone.model.ListSubscriptionRequestsRequest;
import software.amazon.awssdk.services.datazone.model.ListSubscriptionRequestsResponse;
import software.amazon.awssdk.services.datazone.model.SubscriptionRequestSummary;

public class ListSubscriptionRequestsPublisher
implements SdkPublisher<ListSubscriptionRequestsResponse> {
    private final DataZoneAsyncClient client;
    private final ListSubscriptionRequestsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListSubscriptionRequestsPublisher(DataZoneAsyncClient client, ListSubscriptionRequestsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListSubscriptionRequestsPublisher(DataZoneAsyncClient client, ListSubscriptionRequestsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListSubscriptionRequestsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListSubscriptionRequestsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<SubscriptionRequestSummary> items() {
        Function<ListSubscriptionRequestsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListSubscriptionRequestsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListSubscriptionRequestsResponseFetcher
    implements AsyncPageFetcher<ListSubscriptionRequestsResponse> {
        private ListSubscriptionRequestsResponseFetcher() {
        }

        public boolean hasNextPage(ListSubscriptionRequestsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListSubscriptionRequestsResponse> nextPage(ListSubscriptionRequestsResponse previousPage) {
            if (previousPage == null) {
                return ListSubscriptionRequestsPublisher.this.client.listSubscriptionRequests(ListSubscriptionRequestsPublisher.this.firstRequest);
            }
            return ListSubscriptionRequestsPublisher.this.client.listSubscriptionRequests((ListSubscriptionRequestsRequest)((Object)ListSubscriptionRequestsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

