/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datazone.model.DataZoneRequest;
import software.amazon.awssdk.services.datazone.model.NotificationSubjectsCopier;
import software.amazon.awssdk.services.datazone.model.NotificationType;
import software.amazon.awssdk.services.datazone.model.TaskStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListNotificationsRequest
extends DataZoneRequest
implements ToCopyableBuilder<Builder, ListNotificationsRequest> {
    private static final SdkField<Instant> AFTER_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("afterTimestamp").getter(ListNotificationsRequest.getter(ListNotificationsRequest::afterTimestamp)).setter(ListNotificationsRequest.setter(Builder::afterTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("afterTimestamp").build()}).build();
    private static final SdkField<Instant> BEFORE_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("beforeTimestamp").getter(ListNotificationsRequest.getter(ListNotificationsRequest::beforeTimestamp)).setter(ListNotificationsRequest.setter(Builder::beforeTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("beforeTimestamp").build()}).build();
    private static final SdkField<String> DOMAIN_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainIdentifier").getter(ListNotificationsRequest.getter(ListNotificationsRequest::domainIdentifier)).setter(ListNotificationsRequest.setter(Builder::domainIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainIdentifier").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListNotificationsRequest.getter(ListNotificationsRequest::maxResults)).setter(ListNotificationsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListNotificationsRequest.getter(ListNotificationsRequest::nextToken)).setter(ListNotificationsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final SdkField<List<String>> SUBJECTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("subjects").getter(ListNotificationsRequest.getter(ListNotificationsRequest::subjects)).setter(ListNotificationsRequest.setter(Builder::subjects)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("subjects").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TASK_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("taskStatus").getter(ListNotificationsRequest.getter(ListNotificationsRequest::taskStatusAsString)).setter(ListNotificationsRequest.setter(Builder::taskStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("taskStatus").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(ListNotificationsRequest.getter(ListNotificationsRequest::typeAsString)).setter(ListNotificationsRequest.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AFTER_TIMESTAMP_FIELD, BEFORE_TIMESTAMP_FIELD, DOMAIN_IDENTIFIER_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, SUBJECTS_FIELD, TASK_STATUS_FIELD, TYPE_FIELD));
    private final Instant afterTimestamp;
    private final Instant beforeTimestamp;
    private final String domainIdentifier;
    private final Integer maxResults;
    private final String nextToken;
    private final List<String> subjects;
    private final String taskStatus;
    private final String type;

    private ListNotificationsRequest(BuilderImpl builder) {
        super(builder);
        this.afterTimestamp = builder.afterTimestamp;
        this.beforeTimestamp = builder.beforeTimestamp;
        this.domainIdentifier = builder.domainIdentifier;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.subjects = builder.subjects;
        this.taskStatus = builder.taskStatus;
        this.type = builder.type;
    }

    public final Instant afterTimestamp() {
        return this.afterTimestamp;
    }

    public final Instant beforeTimestamp() {
        return this.beforeTimestamp;
    }

    public final String domainIdentifier() {
        return this.domainIdentifier;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasSubjects() {
        return this.subjects != null && !(this.subjects instanceof SdkAutoConstructList);
    }

    public final List<String> subjects() {
        return this.subjects;
    }

    public final TaskStatus taskStatus() {
        return TaskStatus.fromValue(this.taskStatus);
    }

    public final String taskStatusAsString() {
        return this.taskStatus;
    }

    public final NotificationType type() {
        return NotificationType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.afterTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.beforeTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubjects() ? this.subjects() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.taskStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListNotificationsRequest)) {
            return false;
        }
        ListNotificationsRequest other = (ListNotificationsRequest)((Object)obj);
        return Objects.equals(this.afterTimestamp(), other.afterTimestamp()) && Objects.equals(this.beforeTimestamp(), other.beforeTimestamp()) && Objects.equals(this.domainIdentifier(), other.domainIdentifier()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && this.hasSubjects() == other.hasSubjects() && Objects.equals(this.subjects(), other.subjects()) && Objects.equals(this.taskStatusAsString(), other.taskStatusAsString()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ListNotificationsRequest").add("AfterTimestamp", (Object)this.afterTimestamp()).add("BeforeTimestamp", (Object)this.beforeTimestamp()).add("DomainIdentifier", (Object)this.domainIdentifier()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("Subjects", this.hasSubjects() ? this.subjects() : null).add("TaskStatus", (Object)this.taskStatusAsString()).add("Type", (Object)this.typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "afterTimestamp": {
                return Optional.ofNullable(clazz.cast(this.afterTimestamp()));
            }
            case "beforeTimestamp": {
                return Optional.ofNullable(clazz.cast(this.beforeTimestamp()));
            }
            case "domainIdentifier": {
                return Optional.ofNullable(clazz.cast(this.domainIdentifier()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "subjects": {
                return Optional.ofNullable(clazz.cast(this.subjects()));
            }
            case "taskStatus": {
                return Optional.ofNullable(clazz.cast(this.taskStatusAsString()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListNotificationsRequest, T> g) {
        return obj -> g.apply((ListNotificationsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataZoneRequest.BuilderImpl
    implements Builder {
        private Instant afterTimestamp;
        private Instant beforeTimestamp;
        private String domainIdentifier;
        private Integer maxResults;
        private String nextToken;
        private List<String> subjects = DefaultSdkAutoConstructList.getInstance();
        private String taskStatus;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(ListNotificationsRequest model) {
            super(model);
            this.afterTimestamp(model.afterTimestamp);
            this.beforeTimestamp(model.beforeTimestamp);
            this.domainIdentifier(model.domainIdentifier);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.subjects(model.subjects);
            this.taskStatus(model.taskStatus);
            this.type(model.type);
        }

        public final Instant getAfterTimestamp() {
            return this.afterTimestamp;
        }

        public final void setAfterTimestamp(Instant afterTimestamp) {
            this.afterTimestamp = afterTimestamp;
        }

        @Override
        public final Builder afterTimestamp(Instant afterTimestamp) {
            this.afterTimestamp = afterTimestamp;
            return this;
        }

        public final Instant getBeforeTimestamp() {
            return this.beforeTimestamp;
        }

        public final void setBeforeTimestamp(Instant beforeTimestamp) {
            this.beforeTimestamp = beforeTimestamp;
        }

        @Override
        public final Builder beforeTimestamp(Instant beforeTimestamp) {
            this.beforeTimestamp = beforeTimestamp;
            return this;
        }

        public final String getDomainIdentifier() {
            return this.domainIdentifier;
        }

        public final void setDomainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
        }

        @Override
        public final Builder domainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Collection<String> getSubjects() {
            if (this.subjects instanceof SdkAutoConstructList) {
                return null;
            }
            return this.subjects;
        }

        public final void setSubjects(Collection<String> subjects) {
            this.subjects = NotificationSubjectsCopier.copy(subjects);
        }

        @Override
        public final Builder subjects(Collection<String> subjects) {
            this.subjects = NotificationSubjectsCopier.copy(subjects);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subjects(String ... subjects) {
            this.subjects(Arrays.asList(subjects));
            return this;
        }

        public final String getTaskStatus() {
            return this.taskStatus;
        }

        public final void setTaskStatus(String taskStatus) {
            this.taskStatus = taskStatus;
        }

        @Override
        public final Builder taskStatus(String taskStatus) {
            this.taskStatus = taskStatus;
            return this;
        }

        @Override
        public final Builder taskStatus(TaskStatus taskStatus) {
            this.taskStatus(taskStatus == null ? null : taskStatus.toString());
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(NotificationType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListNotificationsRequest build() {
            return new ListNotificationsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DataZoneRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListNotificationsRequest> {
        public Builder afterTimestamp(Instant var1);

        public Builder beforeTimestamp(Instant var1);

        public Builder domainIdentifier(String var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder subjects(Collection<String> var1);

        public Builder subjects(String ... var1);

        public Builder taskStatus(String var1);

        public Builder taskStatus(TaskStatus var1);

        public Builder type(String var1);

        public Builder type(NotificationType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

