/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datazone.model.DataProductItem;
import software.amazon.awssdk.services.datazone.model.DataProductItemsCopier;
import software.amazon.awssdk.services.datazone.model.GlossaryTermsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataProductSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataProductSummary> {
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(DataProductSummary.getter(DataProductSummary::createdAt)).setter(DataProductSummary.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<String> CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("createdBy").getter(DataProductSummary.getter(DataProductSummary::createdBy)).setter(DataProductSummary.setter(Builder::createdBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()}).build();
    private static final SdkField<List<DataProductItem>> DATA_PRODUCT_ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("dataProductItems").getter(DataProductSummary.getter(DataProductSummary::dataProductItems)).setter(DataProductSummary.setter(Builder::dataProductItems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataProductItems").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataProductItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(DataProductSummary.getter(DataProductSummary::description)).setter(DataProductSummary.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainId").getter(DataProductSummary.getter(DataProductSummary::domainId)).setter(DataProductSummary.setter(Builder::domainId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainId").build()}).build();
    private static final SdkField<List<String>> GLOSSARY_TERMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("glossaryTerms").getter(DataProductSummary.getter(DataProductSummary::glossaryTerms)).setter(DataProductSummary.setter(Builder::glossaryTerms)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("glossaryTerms").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(DataProductSummary.getter(DataProductSummary::id)).setter(DataProductSummary.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(DataProductSummary.getter(DataProductSummary::name)).setter(DataProductSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> OWNING_PROJECT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("owningProjectId").getter(DataProductSummary.getter(DataProductSummary::owningProjectId)).setter(DataProductSummary.setter(Builder::owningProjectId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("owningProjectId").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(DataProductSummary.getter(DataProductSummary::updatedAt)).setter(DataProductSummary.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()}).build();
    private static final SdkField<String> UPDATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("updatedBy").getter(DataProductSummary.getter(DataProductSummary::updatedBy)).setter(DataProductSummary.setter(Builder::updatedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedBy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AT_FIELD, CREATED_BY_FIELD, DATA_PRODUCT_ITEMS_FIELD, DESCRIPTION_FIELD, DOMAIN_ID_FIELD, GLOSSARY_TERMS_FIELD, ID_FIELD, NAME_FIELD, OWNING_PROJECT_ID_FIELD, UPDATED_AT_FIELD, UPDATED_BY_FIELD));
    private static final long serialVersionUID = 1L;
    private final Instant createdAt;
    private final String createdBy;
    private final List<DataProductItem> dataProductItems;
    private final String description;
    private final String domainId;
    private final List<String> glossaryTerms;
    private final String id;
    private final String name;
    private final String owningProjectId;
    private final Instant updatedAt;
    private final String updatedBy;

    private DataProductSummary(BuilderImpl builder) {
        this.createdAt = builder.createdAt;
        this.createdBy = builder.createdBy;
        this.dataProductItems = builder.dataProductItems;
        this.description = builder.description;
        this.domainId = builder.domainId;
        this.glossaryTerms = builder.glossaryTerms;
        this.id = builder.id;
        this.name = builder.name;
        this.owningProjectId = builder.owningProjectId;
        this.updatedAt = builder.updatedAt;
        this.updatedBy = builder.updatedBy;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String createdBy() {
        return this.createdBy;
    }

    public final boolean hasDataProductItems() {
        return this.dataProductItems != null && !(this.dataProductItems instanceof SdkAutoConstructList);
    }

    public final List<DataProductItem> dataProductItems() {
        return this.dataProductItems;
    }

    public final String description() {
        return this.description;
    }

    public final String domainId() {
        return this.domainId;
    }

    public final boolean hasGlossaryTerms() {
        return this.glossaryTerms != null && !(this.glossaryTerms instanceof SdkAutoConstructList);
    }

    public final List<String> glossaryTerms() {
        return this.glossaryTerms;
    }

    public final String id() {
        return this.id;
    }

    public final String name() {
        return this.name;
    }

    public final String owningProjectId() {
        return this.owningProjectId;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final String updatedBy() {
        return this.updatedBy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDataProductItems() ? this.dataProductItems() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGlossaryTerms() ? this.glossaryTerms() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.owningProjectId());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedBy());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataProductSummary)) {
            return false;
        }
        DataProductSummary other = (DataProductSummary)obj;
        return Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.createdBy(), other.createdBy()) && this.hasDataProductItems() == other.hasDataProductItems() && Objects.equals(this.dataProductItems(), other.dataProductItems()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.domainId(), other.domainId()) && this.hasGlossaryTerms() == other.hasGlossaryTerms() && Objects.equals(this.glossaryTerms(), other.glossaryTerms()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.owningProjectId(), other.owningProjectId()) && Objects.equals(this.updatedAt(), other.updatedAt()) && Objects.equals(this.updatedBy(), other.updatedBy());
    }

    public final String toString() {
        return ToString.builder((String)"DataProductSummary").add("CreatedAt", (Object)this.createdAt()).add("CreatedBy", (Object)this.createdBy()).add("DataProductItems", this.hasDataProductItems() ? this.dataProductItems() : null).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("DomainId", (Object)this.domainId()).add("GlossaryTerms", this.hasGlossaryTerms() ? this.glossaryTerms() : null).add("Id", (Object)this.id()).add("Name", (Object)(this.name() == null ? null : "*** Sensitive Data Redacted ***")).add("OwningProjectId", (Object)this.owningProjectId()).add("UpdatedAt", (Object)this.updatedAt()).add("UpdatedBy", (Object)this.updatedBy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "createdBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
            case "dataProductItems": {
                return Optional.ofNullable(clazz.cast(this.dataProductItems()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "domainId": {
                return Optional.ofNullable(clazz.cast(this.domainId()));
            }
            case "glossaryTerms": {
                return Optional.ofNullable(clazz.cast(this.glossaryTerms()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "owningProjectId": {
                return Optional.ofNullable(clazz.cast(this.owningProjectId()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "updatedBy": {
                return Optional.ofNullable(clazz.cast(this.updatedBy()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataProductSummary, T> g) {
        return obj -> g.apply((DataProductSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant createdAt;
        private String createdBy;
        private List<DataProductItem> dataProductItems = DefaultSdkAutoConstructList.getInstance();
        private String description;
        private String domainId;
        private List<String> glossaryTerms = DefaultSdkAutoConstructList.getInstance();
        private String id;
        private String name;
        private String owningProjectId;
        private Instant updatedAt;
        private String updatedBy;

        private BuilderImpl() {
        }

        private BuilderImpl(DataProductSummary model) {
            this.createdAt(model.createdAt);
            this.createdBy(model.createdBy);
            this.dataProductItems(model.dataProductItems);
            this.description(model.description);
            this.domainId(model.domainId);
            this.glossaryTerms(model.glossaryTerms);
            this.id(model.id);
            this.name(model.name);
            this.owningProjectId(model.owningProjectId);
            this.updatedAt(model.updatedAt);
            this.updatedBy(model.updatedBy);
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getCreatedBy() {
            return this.createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final List<DataProductItem.Builder> getDataProductItems() {
            List<DataProductItem.Builder> result = DataProductItemsCopier.copyToBuilder(this.dataProductItems);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDataProductItems(Collection<DataProductItem.BuilderImpl> dataProductItems) {
            this.dataProductItems = DataProductItemsCopier.copyFromBuilder(dataProductItems);
        }

        @Override
        public final Builder dataProductItems(Collection<DataProductItem> dataProductItems) {
            this.dataProductItems = DataProductItemsCopier.copy(dataProductItems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataProductItems(DataProductItem ... dataProductItems) {
            this.dataProductItems(Arrays.asList(dataProductItems));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataProductItems(Consumer<DataProductItem.Builder> ... dataProductItems) {
            this.dataProductItems(Stream.of(dataProductItems).map(c -> (DataProductItem)((DataProductItem.Builder)DataProductItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDomainId() {
            return this.domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final Collection<String> getGlossaryTerms() {
            if (this.glossaryTerms instanceof SdkAutoConstructList) {
                return null;
            }
            return this.glossaryTerms;
        }

        public final void setGlossaryTerms(Collection<String> glossaryTerms) {
            this.glossaryTerms = GlossaryTermsCopier.copy(glossaryTerms);
        }

        @Override
        public final Builder glossaryTerms(Collection<String> glossaryTerms) {
            this.glossaryTerms = GlossaryTermsCopier.copy(glossaryTerms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder glossaryTerms(String ... glossaryTerms) {
            this.glossaryTerms(Arrays.asList(glossaryTerms));
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getOwningProjectId() {
            return this.owningProjectId;
        }

        public final void setOwningProjectId(String owningProjectId) {
            this.owningProjectId = owningProjectId;
        }

        @Override
        public final Builder owningProjectId(String owningProjectId) {
            this.owningProjectId = owningProjectId;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getUpdatedBy() {
            return this.updatedBy;
        }

        public final void setUpdatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
        }

        @Override
        public final Builder updatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
            return this;
        }

        public DataProductSummary build() {
            return new DataProductSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataProductSummary> {
        public Builder createdAt(Instant var1);

        public Builder createdBy(String var1);

        public Builder dataProductItems(Collection<DataProductItem> var1);

        public Builder dataProductItems(DataProductItem ... var1);

        public Builder dataProductItems(Consumer<DataProductItem.Builder> ... var1);

        public Builder description(String var1);

        public Builder domainId(String var1);

        public Builder glossaryTerms(Collection<String> var1);

        public Builder glossaryTerms(String ... var1);

        public Builder id(String var1);

        public Builder name(String var1);

        public Builder owningProjectId(String var1);

        public Builder updatedAt(Instant var1);

        public Builder updatedBy(String var1);
    }
}

