/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datazone.model.DataZoneRequest;
import software.amazon.awssdk.services.datazone.model.EnvironmentParameter;
import software.amazon.awssdk.services.datazone.model.EnvironmentParametersListCopier;
import software.amazon.awssdk.services.datazone.model.GlossaryTermsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateEnvironmentRequest
extends DataZoneRequest
implements ToCopyableBuilder<Builder, CreateEnvironmentRequest> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateEnvironmentRequest.getter(CreateEnvironmentRequest::description)).setter(CreateEnvironmentRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> DOMAIN_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainIdentifier").getter(CreateEnvironmentRequest.getter(CreateEnvironmentRequest::domainIdentifier)).setter(CreateEnvironmentRequest.setter(Builder::domainIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainIdentifier").build()}).build();
    private static final SdkField<String> ENVIRONMENT_PROFILE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("environmentProfileIdentifier").getter(CreateEnvironmentRequest.getter(CreateEnvironmentRequest::environmentProfileIdentifier)).setter(CreateEnvironmentRequest.setter(Builder::environmentProfileIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentProfileIdentifier").build()}).build();
    private static final SdkField<List<String>> GLOSSARY_TERMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("glossaryTerms").getter(CreateEnvironmentRequest.getter(CreateEnvironmentRequest::glossaryTerms)).setter(CreateEnvironmentRequest.setter(Builder::glossaryTerms)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("glossaryTerms").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateEnvironmentRequest.getter(CreateEnvironmentRequest::name)).setter(CreateEnvironmentRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> PROJECT_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("projectIdentifier").getter(CreateEnvironmentRequest.getter(CreateEnvironmentRequest::projectIdentifier)).setter(CreateEnvironmentRequest.setter(Builder::projectIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectIdentifier").build()}).build();
    private static final SdkField<List<EnvironmentParameter>> USER_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("userParameters").getter(CreateEnvironmentRequest.getter(CreateEnvironmentRequest::userParameters)).setter(CreateEnvironmentRequest.setter(Builder::userParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userParameters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EnvironmentParameter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, DOMAIN_IDENTIFIER_FIELD, ENVIRONMENT_PROFILE_IDENTIFIER_FIELD, GLOSSARY_TERMS_FIELD, NAME_FIELD, PROJECT_IDENTIFIER_FIELD, USER_PARAMETERS_FIELD));
    private final String description;
    private final String domainIdentifier;
    private final String environmentProfileIdentifier;
    private final List<String> glossaryTerms;
    private final String name;
    private final String projectIdentifier;
    private final List<EnvironmentParameter> userParameters;

    private CreateEnvironmentRequest(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.domainIdentifier = builder.domainIdentifier;
        this.environmentProfileIdentifier = builder.environmentProfileIdentifier;
        this.glossaryTerms = builder.glossaryTerms;
        this.name = builder.name;
        this.projectIdentifier = builder.projectIdentifier;
        this.userParameters = builder.userParameters;
    }

    public final String description() {
        return this.description;
    }

    public final String domainIdentifier() {
        return this.domainIdentifier;
    }

    public final String environmentProfileIdentifier() {
        return this.environmentProfileIdentifier;
    }

    public final boolean hasGlossaryTerms() {
        return this.glossaryTerms != null && !(this.glossaryTerms instanceof SdkAutoConstructList);
    }

    public final List<String> glossaryTerms() {
        return this.glossaryTerms;
    }

    public final String name() {
        return this.name;
    }

    public final String projectIdentifier() {
        return this.projectIdentifier;
    }

    public final boolean hasUserParameters() {
        return this.userParameters != null && !(this.userParameters instanceof SdkAutoConstructList);
    }

    public final List<EnvironmentParameter> userParameters() {
        return this.userParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentProfileIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGlossaryTerms() ? this.glossaryTerms() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.projectIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUserParameters() ? this.userParameters() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateEnvironmentRequest)) {
            return false;
        }
        CreateEnvironmentRequest other = (CreateEnvironmentRequest)((Object)obj);
        return Objects.equals(this.description(), other.description()) && Objects.equals(this.domainIdentifier(), other.domainIdentifier()) && Objects.equals(this.environmentProfileIdentifier(), other.environmentProfileIdentifier()) && this.hasGlossaryTerms() == other.hasGlossaryTerms() && Objects.equals(this.glossaryTerms(), other.glossaryTerms()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.projectIdentifier(), other.projectIdentifier()) && this.hasUserParameters() == other.hasUserParameters() && Objects.equals(this.userParameters(), other.userParameters());
    }

    public final String toString() {
        return ToString.builder((String)"CreateEnvironmentRequest").add("Description", (Object)this.description()).add("DomainIdentifier", (Object)this.domainIdentifier()).add("EnvironmentProfileIdentifier", (Object)this.environmentProfileIdentifier()).add("GlossaryTerms", this.hasGlossaryTerms() ? this.glossaryTerms() : null).add("Name", (Object)this.name()).add("ProjectIdentifier", (Object)this.projectIdentifier()).add("UserParameters", this.hasUserParameters() ? this.userParameters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "domainIdentifier": {
                return Optional.ofNullable(clazz.cast(this.domainIdentifier()));
            }
            case "environmentProfileIdentifier": {
                return Optional.ofNullable(clazz.cast(this.environmentProfileIdentifier()));
            }
            case "glossaryTerms": {
                return Optional.ofNullable(clazz.cast(this.glossaryTerms()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "projectIdentifier": {
                return Optional.ofNullable(clazz.cast(this.projectIdentifier()));
            }
            case "userParameters": {
                return Optional.ofNullable(clazz.cast(this.userParameters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateEnvironmentRequest, T> g) {
        return obj -> g.apply((CreateEnvironmentRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataZoneRequest.BuilderImpl
    implements Builder {
        private String description;
        private String domainIdentifier;
        private String environmentProfileIdentifier;
        private List<String> glossaryTerms = DefaultSdkAutoConstructList.getInstance();
        private String name;
        private String projectIdentifier;
        private List<EnvironmentParameter> userParameters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateEnvironmentRequest model) {
            super(model);
            this.description(model.description);
            this.domainIdentifier(model.domainIdentifier);
            this.environmentProfileIdentifier(model.environmentProfileIdentifier);
            this.glossaryTerms(model.glossaryTerms);
            this.name(model.name);
            this.projectIdentifier(model.projectIdentifier);
            this.userParameters(model.userParameters);
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDomainIdentifier() {
            return this.domainIdentifier;
        }

        public final void setDomainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
        }

        @Override
        public final Builder domainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        public final String getEnvironmentProfileIdentifier() {
            return this.environmentProfileIdentifier;
        }

        public final void setEnvironmentProfileIdentifier(String environmentProfileIdentifier) {
            this.environmentProfileIdentifier = environmentProfileIdentifier;
        }

        @Override
        public final Builder environmentProfileIdentifier(String environmentProfileIdentifier) {
            this.environmentProfileIdentifier = environmentProfileIdentifier;
            return this;
        }

        public final Collection<String> getGlossaryTerms() {
            if (this.glossaryTerms instanceof SdkAutoConstructList) {
                return null;
            }
            return this.glossaryTerms;
        }

        public final void setGlossaryTerms(Collection<String> glossaryTerms) {
            this.glossaryTerms = GlossaryTermsCopier.copy(glossaryTerms);
        }

        @Override
        public final Builder glossaryTerms(Collection<String> glossaryTerms) {
            this.glossaryTerms = GlossaryTermsCopier.copy(glossaryTerms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder glossaryTerms(String ... glossaryTerms) {
            this.glossaryTerms(Arrays.asList(glossaryTerms));
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getProjectIdentifier() {
            return this.projectIdentifier;
        }

        public final void setProjectIdentifier(String projectIdentifier) {
            this.projectIdentifier = projectIdentifier;
        }

        @Override
        public final Builder projectIdentifier(String projectIdentifier) {
            this.projectIdentifier = projectIdentifier;
            return this;
        }

        public final List<EnvironmentParameter.Builder> getUserParameters() {
            List<EnvironmentParameter.Builder> result = EnvironmentParametersListCopier.copyToBuilder(this.userParameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUserParameters(Collection<EnvironmentParameter.BuilderImpl> userParameters) {
            this.userParameters = EnvironmentParametersListCopier.copyFromBuilder(userParameters);
        }

        @Override
        public final Builder userParameters(Collection<EnvironmentParameter> userParameters) {
            this.userParameters = EnvironmentParametersListCopier.copy(userParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userParameters(EnvironmentParameter ... userParameters) {
            this.userParameters(Arrays.asList(userParameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userParameters(Consumer<EnvironmentParameter.Builder> ... userParameters) {
            this.userParameters(Stream.of(userParameters).map(c -> (EnvironmentParameter)((EnvironmentParameter.Builder)EnvironmentParameter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateEnvironmentRequest build() {
            return new CreateEnvironmentRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DataZoneRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateEnvironmentRequest> {
        public Builder description(String var1);

        public Builder domainIdentifier(String var1);

        public Builder environmentProfileIdentifier(String var1);

        public Builder glossaryTerms(Collection<String> var1);

        public Builder glossaryTerms(String ... var1);

        public Builder name(String var1);

        public Builder projectIdentifier(String var1);

        public Builder userParameters(Collection<EnvironmentParameter> var1);

        public Builder userParameters(EnvironmentParameter ... var1);

        public Builder userParameters(Consumer<EnvironmentParameter.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

