/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.datazone.model.DataZoneRequest;
import software.amazon.awssdk.services.datazone.model.GlossaryTermStatus;
import software.amazon.awssdk.services.datazone.model.TermRelations;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateGlossaryTermRequest
extends DataZoneRequest
implements ToCopyableBuilder<Builder, CreateGlossaryTermRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateGlossaryTermRequest.getter(CreateGlossaryTermRequest::clientToken)).setter(CreateGlossaryTermRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> DOMAIN_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainIdentifier").getter(CreateGlossaryTermRequest.getter(CreateGlossaryTermRequest::domainIdentifier)).setter(CreateGlossaryTermRequest.setter(Builder::domainIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainIdentifier").build()}).build();
    private static final SdkField<String> GLOSSARY_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("glossaryIdentifier").getter(CreateGlossaryTermRequest.getter(CreateGlossaryTermRequest::glossaryIdentifier)).setter(CreateGlossaryTermRequest.setter(Builder::glossaryIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("glossaryIdentifier").build()}).build();
    private static final SdkField<String> LONG_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("longDescription").getter(CreateGlossaryTermRequest.getter(CreateGlossaryTermRequest::longDescription)).setter(CreateGlossaryTermRequest.setter(Builder::longDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("longDescription").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateGlossaryTermRequest.getter(CreateGlossaryTermRequest::name)).setter(CreateGlossaryTermRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> SHORT_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("shortDescription").getter(CreateGlossaryTermRequest.getter(CreateGlossaryTermRequest::shortDescription)).setter(CreateGlossaryTermRequest.setter(Builder::shortDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shortDescription").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(CreateGlossaryTermRequest.getter(CreateGlossaryTermRequest::statusAsString)).setter(CreateGlossaryTermRequest.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<TermRelations> TERM_RELATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("termRelations").getter(CreateGlossaryTermRequest.getter(CreateGlossaryTermRequest::termRelations)).setter(CreateGlossaryTermRequest.setter(Builder::termRelations)).constructor(TermRelations::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("termRelations").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, DOMAIN_IDENTIFIER_FIELD, GLOSSARY_IDENTIFIER_FIELD, LONG_DESCRIPTION_FIELD, NAME_FIELD, SHORT_DESCRIPTION_FIELD, STATUS_FIELD, TERM_RELATIONS_FIELD));
    private final String clientToken;
    private final String domainIdentifier;
    private final String glossaryIdentifier;
    private final String longDescription;
    private final String name;
    private final String shortDescription;
    private final String status;
    private final TermRelations termRelations;

    private CreateGlossaryTermRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.domainIdentifier = builder.domainIdentifier;
        this.glossaryIdentifier = builder.glossaryIdentifier;
        this.longDescription = builder.longDescription;
        this.name = builder.name;
        this.shortDescription = builder.shortDescription;
        this.status = builder.status;
        this.termRelations = builder.termRelations;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String domainIdentifier() {
        return this.domainIdentifier;
    }

    public final String glossaryIdentifier() {
        return this.glossaryIdentifier;
    }

    public final String longDescription() {
        return this.longDescription;
    }

    public final String name() {
        return this.name;
    }

    public final String shortDescription() {
        return this.shortDescription;
    }

    public final GlossaryTermStatus status() {
        return GlossaryTermStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final TermRelations termRelations() {
        return this.termRelations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.glossaryIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.longDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.shortDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.termRelations());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateGlossaryTermRequest)) {
            return false;
        }
        CreateGlossaryTermRequest other = (CreateGlossaryTermRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.domainIdentifier(), other.domainIdentifier()) && Objects.equals(this.glossaryIdentifier(), other.glossaryIdentifier()) && Objects.equals(this.longDescription(), other.longDescription()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.shortDescription(), other.shortDescription()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.termRelations(), other.termRelations());
    }

    public final String toString() {
        return ToString.builder((String)"CreateGlossaryTermRequest").add("ClientToken", (Object)this.clientToken()).add("DomainIdentifier", (Object)this.domainIdentifier()).add("GlossaryIdentifier", (Object)this.glossaryIdentifier()).add("LongDescription", (Object)(this.longDescription() == null ? null : "*** Sensitive Data Redacted ***")).add("Name", (Object)(this.name() == null ? null : "*** Sensitive Data Redacted ***")).add("ShortDescription", (Object)(this.shortDescription() == null ? null : "*** Sensitive Data Redacted ***")).add("Status", (Object)this.statusAsString()).add("TermRelations", (Object)this.termRelations()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "domainIdentifier": {
                return Optional.ofNullable(clazz.cast(this.domainIdentifier()));
            }
            case "glossaryIdentifier": {
                return Optional.ofNullable(clazz.cast(this.glossaryIdentifier()));
            }
            case "longDescription": {
                return Optional.ofNullable(clazz.cast(this.longDescription()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "shortDescription": {
                return Optional.ofNullable(clazz.cast(this.shortDescription()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "termRelations": {
                return Optional.ofNullable(clazz.cast(this.termRelations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateGlossaryTermRequest, T> g) {
        return obj -> g.apply((CreateGlossaryTermRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataZoneRequest.BuilderImpl
    implements Builder {
        private String clientToken;
        private String domainIdentifier;
        private String glossaryIdentifier;
        private String longDescription;
        private String name;
        private String shortDescription;
        private String status;
        private TermRelations termRelations;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateGlossaryTermRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.domainIdentifier(model.domainIdentifier);
            this.glossaryIdentifier(model.glossaryIdentifier);
            this.longDescription(model.longDescription);
            this.name(model.name);
            this.shortDescription(model.shortDescription);
            this.status(model.status);
            this.termRelations(model.termRelations);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDomainIdentifier() {
            return this.domainIdentifier;
        }

        public final void setDomainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
        }

        @Override
        public final Builder domainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        public final String getGlossaryIdentifier() {
            return this.glossaryIdentifier;
        }

        public final void setGlossaryIdentifier(String glossaryIdentifier) {
            this.glossaryIdentifier = glossaryIdentifier;
        }

        @Override
        public final Builder glossaryIdentifier(String glossaryIdentifier) {
            this.glossaryIdentifier = glossaryIdentifier;
            return this;
        }

        public final String getLongDescription() {
            return this.longDescription;
        }

        public final void setLongDescription(String longDescription) {
            this.longDescription = longDescription;
        }

        @Override
        public final Builder longDescription(String longDescription) {
            this.longDescription = longDescription;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getShortDescription() {
            return this.shortDescription;
        }

        public final void setShortDescription(String shortDescription) {
            this.shortDescription = shortDescription;
        }

        @Override
        public final Builder shortDescription(String shortDescription) {
            this.shortDescription = shortDescription;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(GlossaryTermStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final TermRelations.Builder getTermRelations() {
            return this.termRelations != null ? this.termRelations.toBuilder() : null;
        }

        public final void setTermRelations(TermRelations.BuilderImpl termRelations) {
            this.termRelations = termRelations != null ? termRelations.build() : null;
        }

        @Override
        public final Builder termRelations(TermRelations termRelations) {
            this.termRelations = termRelations;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateGlossaryTermRequest build() {
            return new CreateGlossaryTermRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DataZoneRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateGlossaryTermRequest> {
        public Builder clientToken(String var1);

        public Builder domainIdentifier(String var1);

        public Builder glossaryIdentifier(String var1);

        public Builder longDescription(String var1);

        public Builder name(String var1);

        public Builder shortDescription(String var1);

        public Builder status(String var1);

        public Builder status(GlossaryTermStatus var1);

        public Builder termRelations(TermRelations var1);

        default public Builder termRelations(Consumer<TermRelations.Builder> termRelations) {
            return this.termRelations((TermRelations)((TermRelations.Builder)TermRelations.builder().applyMutation(termRelations)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

