/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datasync.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.datasync.model.DataSyncResponse;
import software.amazon.awssdk.services.datasync.model.Ec2Config;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeLocationEfsResponse
extends DataSyncResponse
implements ToCopyableBuilder<Builder, DescribeLocationEfsResponse> {
    private static final SdkField<String> LOCATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeLocationEfsResponse.getter(DescribeLocationEfsResponse::locationArn)).setter(DescribeLocationEfsResponse.setter(Builder::locationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocationArn").build()}).build();
    private static final SdkField<String> LOCATION_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeLocationEfsResponse.getter(DescribeLocationEfsResponse::locationUri)).setter(DescribeLocationEfsResponse.setter(Builder::locationUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocationUri").build()}).build();
    private static final SdkField<Ec2Config> EC2_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DescribeLocationEfsResponse.getter(DescribeLocationEfsResponse::ec2Config)).setter(DescribeLocationEfsResponse.setter(Builder::ec2Config)).constructor(Ec2Config::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ec2Config").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(DescribeLocationEfsResponse.getter(DescribeLocationEfsResponse::creationTime)).setter(DescribeLocationEfsResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOCATION_ARN_FIELD, LOCATION_URI_FIELD, EC2_CONFIG_FIELD, CREATION_TIME_FIELD));
    private final String locationArn;
    private final String locationUri;
    private final Ec2Config ec2Config;
    private final Instant creationTime;

    private DescribeLocationEfsResponse(BuilderImpl builder) {
        super(builder);
        this.locationArn = builder.locationArn;
        this.locationUri = builder.locationUri;
        this.ec2Config = builder.ec2Config;
        this.creationTime = builder.creationTime;
    }

    public String locationArn() {
        return this.locationArn;
    }

    public String locationUri() {
        return this.locationUri;
    }

    public Ec2Config ec2Config() {
        return this.ec2Config;
    }

    public Instant creationTime() {
        return this.creationTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.locationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.locationUri());
        hashCode = 31 * hashCode + Objects.hashCode(this.ec2Config());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLocationEfsResponse)) {
            return false;
        }
        DescribeLocationEfsResponse other = (DescribeLocationEfsResponse)((Object)obj);
        return Objects.equals(this.locationArn(), other.locationArn()) && Objects.equals(this.locationUri(), other.locationUri()) && Objects.equals(this.ec2Config(), other.ec2Config()) && Objects.equals(this.creationTime(), other.creationTime());
    }

    public String toString() {
        return ToString.builder((String)"DescribeLocationEfsResponse").add("LocationArn", (Object)this.locationArn()).add("LocationUri", (Object)this.locationUri()).add("Ec2Config", (Object)this.ec2Config()).add("CreationTime", (Object)this.creationTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LocationArn": {
                return Optional.ofNullable(clazz.cast(this.locationArn()));
            }
            case "LocationUri": {
                return Optional.ofNullable(clazz.cast(this.locationUri()));
            }
            case "Ec2Config": {
                return Optional.ofNullable(clazz.cast(this.ec2Config()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeLocationEfsResponse, T> g) {
        return obj -> g.apply((DescribeLocationEfsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataSyncResponse.BuilderImpl
    implements Builder {
        private String locationArn;
        private String locationUri;
        private Ec2Config ec2Config;
        private Instant creationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLocationEfsResponse model) {
            super(model);
            this.locationArn(model.locationArn);
            this.locationUri(model.locationUri);
            this.ec2Config(model.ec2Config);
            this.creationTime(model.creationTime);
        }

        public final String getLocationArn() {
            return this.locationArn;
        }

        @Override
        public final Builder locationArn(String locationArn) {
            this.locationArn = locationArn;
            return this;
        }

        public final void setLocationArn(String locationArn) {
            this.locationArn = locationArn;
        }

        public final String getLocationUri() {
            return this.locationUri;
        }

        @Override
        public final Builder locationUri(String locationUri) {
            this.locationUri = locationUri;
            return this;
        }

        public final void setLocationUri(String locationUri) {
            this.locationUri = locationUri;
        }

        public final Ec2Config.Builder getEc2Config() {
            return this.ec2Config != null ? this.ec2Config.toBuilder() : null;
        }

        @Override
        public final Builder ec2Config(Ec2Config ec2Config) {
            this.ec2Config = ec2Config;
            return this;
        }

        public final void setEc2Config(Ec2Config.BuilderImpl ec2Config) {
            this.ec2Config = ec2Config != null ? ec2Config.build() : null;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public DescribeLocationEfsResponse build() {
            return new DescribeLocationEfsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DataSyncResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeLocationEfsResponse> {
        public Builder locationArn(String var1);

        public Builder locationUri(String var1);

        public Builder ec2Config(Ec2Config var1);

        default public Builder ec2Config(Consumer<Ec2Config.Builder> ec2Config) {
            return this.ec2Config((Ec2Config)((Ec2Config.Builder)Ec2Config.builder().applyMutation(ec2Config)).build());
        }

        public Builder creationTime(Instant var1);
    }
}

