/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datasync.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.datasync.DataSyncClient;
import software.amazon.awssdk.services.datasync.model.ListTasksRequest;
import software.amazon.awssdk.services.datasync.model.ListTasksResponse;

public class ListTasksIterable
implements SdkIterable<ListTasksResponse> {
    private final DataSyncClient client;
    private final ListTasksRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTasksIterable(DataSyncClient client, ListTasksRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListTasksResponseFetcher();
    }

    public Iterator<ListTasksResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private final ListTasksIterable resume(ListTasksResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListTasksIterable(this.client, (ListTasksRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListTasksIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListTasksResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListTasksResponseFetcher
    implements SyncPageFetcher<ListTasksResponse> {
        private ListTasksResponseFetcher() {
        }

        public boolean hasNextPage(ListTasksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListTasksResponse nextPage(ListTasksResponse previousPage) {
            if (previousPage == null) {
                return ListTasksIterable.this.client.listTasks(ListTasksIterable.this.firstRequest);
            }
            return ListTasksIterable.this.client.listTasks((ListTasksRequest)((Object)ListTasksIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

