/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datasync.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datasync.model.DataSyncRequest;
import software.amazon.awssdk.services.datasync.model.Ec2Config;
import software.amazon.awssdk.services.datasync.model.EfsInTransitEncryption;
import software.amazon.awssdk.services.datasync.model.InputTagListCopier;
import software.amazon.awssdk.services.datasync.model.TagListEntry;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateLocationEfsRequest
extends DataSyncRequest
implements ToCopyableBuilder<Builder, CreateLocationEfsRequest> {
    private static final SdkField<String> SUBDIRECTORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Subdirectory").getter(CreateLocationEfsRequest.getter(CreateLocationEfsRequest::subdirectory)).setter(CreateLocationEfsRequest.setter(Builder::subdirectory)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subdirectory").build()}).build();
    private static final SdkField<String> EFS_FILESYSTEM_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EfsFilesystemArn").getter(CreateLocationEfsRequest.getter(CreateLocationEfsRequest::efsFilesystemArn)).setter(CreateLocationEfsRequest.setter(Builder::efsFilesystemArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EfsFilesystemArn").build()}).build();
    private static final SdkField<Ec2Config> EC2_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Ec2Config").getter(CreateLocationEfsRequest.getter(CreateLocationEfsRequest::ec2Config)).setter(CreateLocationEfsRequest.setter(Builder::ec2Config)).constructor(Ec2Config::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ec2Config").build()}).build();
    private static final SdkField<List<TagListEntry>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateLocationEfsRequest.getter(CreateLocationEfsRequest::tags)).setter(CreateLocationEfsRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TagListEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ACCESS_POINT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccessPointArn").getter(CreateLocationEfsRequest.getter(CreateLocationEfsRequest::accessPointArn)).setter(CreateLocationEfsRequest.setter(Builder::accessPointArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessPointArn").build()}).build();
    private static final SdkField<String> FILE_SYSTEM_ACCESS_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FileSystemAccessRoleArn").getter(CreateLocationEfsRequest.getter(CreateLocationEfsRequest::fileSystemAccessRoleArn)).setter(CreateLocationEfsRequest.setter(Builder::fileSystemAccessRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileSystemAccessRoleArn").build()}).build();
    private static final SdkField<String> IN_TRANSIT_ENCRYPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InTransitEncryption").getter(CreateLocationEfsRequest.getter(CreateLocationEfsRequest::inTransitEncryptionAsString)).setter(CreateLocationEfsRequest.setter(Builder::inTransitEncryption)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InTransitEncryption").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBDIRECTORY_FIELD, EFS_FILESYSTEM_ARN_FIELD, EC2_CONFIG_FIELD, TAGS_FIELD, ACCESS_POINT_ARN_FIELD, FILE_SYSTEM_ACCESS_ROLE_ARN_FIELD, IN_TRANSIT_ENCRYPTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateLocationEfsRequest.memberNameToFieldInitializer();
    private final String subdirectory;
    private final String efsFilesystemArn;
    private final Ec2Config ec2Config;
    private final List<TagListEntry> tags;
    private final String accessPointArn;
    private final String fileSystemAccessRoleArn;
    private final String inTransitEncryption;

    private CreateLocationEfsRequest(BuilderImpl builder) {
        super(builder);
        this.subdirectory = builder.subdirectory;
        this.efsFilesystemArn = builder.efsFilesystemArn;
        this.ec2Config = builder.ec2Config;
        this.tags = builder.tags;
        this.accessPointArn = builder.accessPointArn;
        this.fileSystemAccessRoleArn = builder.fileSystemAccessRoleArn;
        this.inTransitEncryption = builder.inTransitEncryption;
    }

    public final String subdirectory() {
        return this.subdirectory;
    }

    public final String efsFilesystemArn() {
        return this.efsFilesystemArn;
    }

    public final Ec2Config ec2Config() {
        return this.ec2Config;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<TagListEntry> tags() {
        return this.tags;
    }

    public final String accessPointArn() {
        return this.accessPointArn;
    }

    public final String fileSystemAccessRoleArn() {
        return this.fileSystemAccessRoleArn;
    }

    public final EfsInTransitEncryption inTransitEncryption() {
        return EfsInTransitEncryption.fromValue(this.inTransitEncryption);
    }

    public final String inTransitEncryptionAsString() {
        return this.inTransitEncryption;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.subdirectory());
        hashCode = 31 * hashCode + Objects.hashCode(this.efsFilesystemArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.ec2Config());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.accessPointArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileSystemAccessRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.inTransitEncryptionAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLocationEfsRequest)) {
            return false;
        }
        CreateLocationEfsRequest other = (CreateLocationEfsRequest)((Object)obj);
        return Objects.equals(this.subdirectory(), other.subdirectory()) && Objects.equals(this.efsFilesystemArn(), other.efsFilesystemArn()) && Objects.equals(this.ec2Config(), other.ec2Config()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.accessPointArn(), other.accessPointArn()) && Objects.equals(this.fileSystemAccessRoleArn(), other.fileSystemAccessRoleArn()) && Objects.equals(this.inTransitEncryptionAsString(), other.inTransitEncryptionAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CreateLocationEfsRequest").add("Subdirectory", (Object)this.subdirectory()).add("EfsFilesystemArn", (Object)this.efsFilesystemArn()).add("Ec2Config", (Object)this.ec2Config()).add("Tags", this.hasTags() ? this.tags() : null).add("AccessPointArn", (Object)this.accessPointArn()).add("FileSystemAccessRoleArn", (Object)this.fileSystemAccessRoleArn()).add("InTransitEncryption", (Object)this.inTransitEncryptionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Subdirectory": {
                return Optional.ofNullable(clazz.cast(this.subdirectory()));
            }
            case "EfsFilesystemArn": {
                return Optional.ofNullable(clazz.cast(this.efsFilesystemArn()));
            }
            case "Ec2Config": {
                return Optional.ofNullable(clazz.cast(this.ec2Config()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "AccessPointArn": {
                return Optional.ofNullable(clazz.cast(this.accessPointArn()));
            }
            case "FileSystemAccessRoleArn": {
                return Optional.ofNullable(clazz.cast(this.fileSystemAccessRoleArn()));
            }
            case "InTransitEncryption": {
                return Optional.ofNullable(clazz.cast(this.inTransitEncryptionAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Subdirectory", SUBDIRECTORY_FIELD);
        map.put("EfsFilesystemArn", EFS_FILESYSTEM_ARN_FIELD);
        map.put("Ec2Config", EC2_CONFIG_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("AccessPointArn", ACCESS_POINT_ARN_FIELD);
        map.put("FileSystemAccessRoleArn", FILE_SYSTEM_ACCESS_ROLE_ARN_FIELD);
        map.put("InTransitEncryption", IN_TRANSIT_ENCRYPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateLocationEfsRequest, T> g) {
        return obj -> g.apply((CreateLocationEfsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataSyncRequest.BuilderImpl
    implements Builder {
        private String subdirectory;
        private String efsFilesystemArn;
        private Ec2Config ec2Config;
        private List<TagListEntry> tags = DefaultSdkAutoConstructList.getInstance();
        private String accessPointArn;
        private String fileSystemAccessRoleArn;
        private String inTransitEncryption;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLocationEfsRequest model) {
            super(model);
            this.subdirectory(model.subdirectory);
            this.efsFilesystemArn(model.efsFilesystemArn);
            this.ec2Config(model.ec2Config);
            this.tags(model.tags);
            this.accessPointArn(model.accessPointArn);
            this.fileSystemAccessRoleArn(model.fileSystemAccessRoleArn);
            this.inTransitEncryption(model.inTransitEncryption);
        }

        public final String getSubdirectory() {
            return this.subdirectory;
        }

        public final void setSubdirectory(String subdirectory) {
            this.subdirectory = subdirectory;
        }

        @Override
        public final Builder subdirectory(String subdirectory) {
            this.subdirectory = subdirectory;
            return this;
        }

        public final String getEfsFilesystemArn() {
            return this.efsFilesystemArn;
        }

        public final void setEfsFilesystemArn(String efsFilesystemArn) {
            this.efsFilesystemArn = efsFilesystemArn;
        }

        @Override
        public final Builder efsFilesystemArn(String efsFilesystemArn) {
            this.efsFilesystemArn = efsFilesystemArn;
            return this;
        }

        public final Ec2Config.Builder getEc2Config() {
            return this.ec2Config != null ? this.ec2Config.toBuilder() : null;
        }

        public final void setEc2Config(Ec2Config.BuilderImpl ec2Config) {
            this.ec2Config = ec2Config != null ? ec2Config.build() : null;
        }

        @Override
        public final Builder ec2Config(Ec2Config ec2Config) {
            this.ec2Config = ec2Config;
            return this;
        }

        public final List<TagListEntry.Builder> getTags() {
            List<TagListEntry.Builder> result = InputTagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<TagListEntry.BuilderImpl> tags) {
            this.tags = InputTagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<TagListEntry> tags) {
            this.tags = InputTagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(TagListEntry ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<TagListEntry.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (TagListEntry)((TagListEntry.Builder)TagListEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getAccessPointArn() {
            return this.accessPointArn;
        }

        public final void setAccessPointArn(String accessPointArn) {
            this.accessPointArn = accessPointArn;
        }

        @Override
        public final Builder accessPointArn(String accessPointArn) {
            this.accessPointArn = accessPointArn;
            return this;
        }

        public final String getFileSystemAccessRoleArn() {
            return this.fileSystemAccessRoleArn;
        }

        public final void setFileSystemAccessRoleArn(String fileSystemAccessRoleArn) {
            this.fileSystemAccessRoleArn = fileSystemAccessRoleArn;
        }

        @Override
        public final Builder fileSystemAccessRoleArn(String fileSystemAccessRoleArn) {
            this.fileSystemAccessRoleArn = fileSystemAccessRoleArn;
            return this;
        }

        public final String getInTransitEncryption() {
            return this.inTransitEncryption;
        }

        public final void setInTransitEncryption(String inTransitEncryption) {
            this.inTransitEncryption = inTransitEncryption;
        }

        @Override
        public final Builder inTransitEncryption(String inTransitEncryption) {
            this.inTransitEncryption = inTransitEncryption;
            return this;
        }

        @Override
        public final Builder inTransitEncryption(EfsInTransitEncryption inTransitEncryption) {
            this.inTransitEncryption(inTransitEncryption == null ? null : inTransitEncryption.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateLocationEfsRequest build() {
            return new CreateLocationEfsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends DataSyncRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateLocationEfsRequest> {
        public Builder subdirectory(String var1);

        public Builder efsFilesystemArn(String var1);

        public Builder ec2Config(Ec2Config var1);

        default public Builder ec2Config(Consumer<Ec2Config.Builder> ec2Config) {
            return this.ec2Config((Ec2Config)((Ec2Config.Builder)Ec2Config.builder().applyMutation(ec2Config)).build());
        }

        public Builder tags(Collection<TagListEntry> var1);

        public Builder tags(TagListEntry ... var1);

        public Builder tags(Consumer<TagListEntry.Builder> ... var1);

        public Builder accessPointArn(String var1);

        public Builder fileSystemAccessRoleArn(String var1);

        public Builder inTransitEncryption(String var1);

        public Builder inTransitEncryption(EfsInTransitEncryption var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

