/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datasync.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datasync.model.AgentArnListCopier;
import software.amazon.awssdk.services.datasync.model.AzureAccessTier;
import software.amazon.awssdk.services.datasync.model.AzureBlobAuthenticationType;
import software.amazon.awssdk.services.datasync.model.AzureBlobSasConfiguration;
import software.amazon.awssdk.services.datasync.model.AzureBlobType;
import software.amazon.awssdk.services.datasync.model.DataSyncRequest;
import software.amazon.awssdk.services.datasync.model.InputTagListCopier;
import software.amazon.awssdk.services.datasync.model.TagListEntry;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateLocationAzureBlobRequest
extends DataSyncRequest
implements ToCopyableBuilder<Builder, CreateLocationAzureBlobRequest> {
    private static final SdkField<String> CONTAINER_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContainerUrl").getter(CreateLocationAzureBlobRequest.getter(CreateLocationAzureBlobRequest::containerUrl)).setter(CreateLocationAzureBlobRequest.setter(Builder::containerUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContainerUrl").build()}).build();
    private static final SdkField<String> AUTHENTICATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AuthenticationType").getter(CreateLocationAzureBlobRequest.getter(CreateLocationAzureBlobRequest::authenticationTypeAsString)).setter(CreateLocationAzureBlobRequest.setter(Builder::authenticationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthenticationType").build()}).build();
    private static final SdkField<AzureBlobSasConfiguration> SAS_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SasConfiguration").getter(CreateLocationAzureBlobRequest.getter(CreateLocationAzureBlobRequest::sasConfiguration)).setter(CreateLocationAzureBlobRequest.setter(Builder::sasConfiguration)).constructor(AzureBlobSasConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SasConfiguration").build()}).build();
    private static final SdkField<String> BLOB_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BlobType").getter(CreateLocationAzureBlobRequest.getter(CreateLocationAzureBlobRequest::blobTypeAsString)).setter(CreateLocationAzureBlobRequest.setter(Builder::blobType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlobType").build()}).build();
    private static final SdkField<String> ACCESS_TIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccessTier").getter(CreateLocationAzureBlobRequest.getter(CreateLocationAzureBlobRequest::accessTierAsString)).setter(CreateLocationAzureBlobRequest.setter(Builder::accessTier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessTier").build()}).build();
    private static final SdkField<String> SUBDIRECTORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Subdirectory").getter(CreateLocationAzureBlobRequest.getter(CreateLocationAzureBlobRequest::subdirectory)).setter(CreateLocationAzureBlobRequest.setter(Builder::subdirectory)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subdirectory").build()}).build();
    private static final SdkField<List<String>> AGENT_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AgentArns").getter(CreateLocationAzureBlobRequest.getter(CreateLocationAzureBlobRequest::agentArns)).setter(CreateLocationAzureBlobRequest.setter(Builder::agentArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AgentArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<TagListEntry>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateLocationAzureBlobRequest.getter(CreateLocationAzureBlobRequest::tags)).setter(CreateLocationAzureBlobRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TagListEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTAINER_URL_FIELD, AUTHENTICATION_TYPE_FIELD, SAS_CONFIGURATION_FIELD, BLOB_TYPE_FIELD, ACCESS_TIER_FIELD, SUBDIRECTORY_FIELD, AGENT_ARNS_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateLocationAzureBlobRequest.memberNameToFieldInitializer();
    private final String containerUrl;
    private final String authenticationType;
    private final AzureBlobSasConfiguration sasConfiguration;
    private final String blobType;
    private final String accessTier;
    private final String subdirectory;
    private final List<String> agentArns;
    private final List<TagListEntry> tags;

    private CreateLocationAzureBlobRequest(BuilderImpl builder) {
        super(builder);
        this.containerUrl = builder.containerUrl;
        this.authenticationType = builder.authenticationType;
        this.sasConfiguration = builder.sasConfiguration;
        this.blobType = builder.blobType;
        this.accessTier = builder.accessTier;
        this.subdirectory = builder.subdirectory;
        this.agentArns = builder.agentArns;
        this.tags = builder.tags;
    }

    public final String containerUrl() {
        return this.containerUrl;
    }

    public final AzureBlobAuthenticationType authenticationType() {
        return AzureBlobAuthenticationType.fromValue(this.authenticationType);
    }

    public final String authenticationTypeAsString() {
        return this.authenticationType;
    }

    public final AzureBlobSasConfiguration sasConfiguration() {
        return this.sasConfiguration;
    }

    public final AzureBlobType blobType() {
        return AzureBlobType.fromValue(this.blobType);
    }

    public final String blobTypeAsString() {
        return this.blobType;
    }

    public final AzureAccessTier accessTier() {
        return AzureAccessTier.fromValue(this.accessTier);
    }

    public final String accessTierAsString() {
        return this.accessTier;
    }

    public final String subdirectory() {
        return this.subdirectory;
    }

    public final boolean hasAgentArns() {
        return this.agentArns != null && !(this.agentArns instanceof SdkAutoConstructList);
    }

    public final List<String> agentArns() {
        return this.agentArns;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<TagListEntry> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.containerUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.authenticationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sasConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.blobTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessTierAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.subdirectory());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAgentArns() ? this.agentArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLocationAzureBlobRequest)) {
            return false;
        }
        CreateLocationAzureBlobRequest other = (CreateLocationAzureBlobRequest)((Object)obj);
        return Objects.equals(this.containerUrl(), other.containerUrl()) && Objects.equals(this.authenticationTypeAsString(), other.authenticationTypeAsString()) && Objects.equals(this.sasConfiguration(), other.sasConfiguration()) && Objects.equals(this.blobTypeAsString(), other.blobTypeAsString()) && Objects.equals(this.accessTierAsString(), other.accessTierAsString()) && Objects.equals(this.subdirectory(), other.subdirectory()) && this.hasAgentArns() == other.hasAgentArns() && Objects.equals(this.agentArns(), other.agentArns()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateLocationAzureBlobRequest").add("ContainerUrl", (Object)this.containerUrl()).add("AuthenticationType", (Object)this.authenticationTypeAsString()).add("SasConfiguration", (Object)this.sasConfiguration()).add("BlobType", (Object)this.blobTypeAsString()).add("AccessTier", (Object)this.accessTierAsString()).add("Subdirectory", (Object)this.subdirectory()).add("AgentArns", this.hasAgentArns() ? this.agentArns() : null).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ContainerUrl": {
                return Optional.ofNullable(clazz.cast(this.containerUrl()));
            }
            case "AuthenticationType": {
                return Optional.ofNullable(clazz.cast(this.authenticationTypeAsString()));
            }
            case "SasConfiguration": {
                return Optional.ofNullable(clazz.cast(this.sasConfiguration()));
            }
            case "BlobType": {
                return Optional.ofNullable(clazz.cast(this.blobTypeAsString()));
            }
            case "AccessTier": {
                return Optional.ofNullable(clazz.cast(this.accessTierAsString()));
            }
            case "Subdirectory": {
                return Optional.ofNullable(clazz.cast(this.subdirectory()));
            }
            case "AgentArns": {
                return Optional.ofNullable(clazz.cast(this.agentArns()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ContainerUrl", CONTAINER_URL_FIELD);
        map.put("AuthenticationType", AUTHENTICATION_TYPE_FIELD);
        map.put("SasConfiguration", SAS_CONFIGURATION_FIELD);
        map.put("BlobType", BLOB_TYPE_FIELD);
        map.put("AccessTier", ACCESS_TIER_FIELD);
        map.put("Subdirectory", SUBDIRECTORY_FIELD);
        map.put("AgentArns", AGENT_ARNS_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateLocationAzureBlobRequest, T> g) {
        return obj -> g.apply((CreateLocationAzureBlobRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataSyncRequest.BuilderImpl
    implements Builder {
        private String containerUrl;
        private String authenticationType;
        private AzureBlobSasConfiguration sasConfiguration;
        private String blobType;
        private String accessTier;
        private String subdirectory;
        private List<String> agentArns = DefaultSdkAutoConstructList.getInstance();
        private List<TagListEntry> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLocationAzureBlobRequest model) {
            super(model);
            this.containerUrl(model.containerUrl);
            this.authenticationType(model.authenticationType);
            this.sasConfiguration(model.sasConfiguration);
            this.blobType(model.blobType);
            this.accessTier(model.accessTier);
            this.subdirectory(model.subdirectory);
            this.agentArns(model.agentArns);
            this.tags(model.tags);
        }

        public final String getContainerUrl() {
            return this.containerUrl;
        }

        public final void setContainerUrl(String containerUrl) {
            this.containerUrl = containerUrl;
        }

        @Override
        public final Builder containerUrl(String containerUrl) {
            this.containerUrl = containerUrl;
            return this;
        }

        public final String getAuthenticationType() {
            return this.authenticationType;
        }

        public final void setAuthenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
        }

        @Override
        public final Builder authenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
            return this;
        }

        @Override
        public final Builder authenticationType(AzureBlobAuthenticationType authenticationType) {
            this.authenticationType(authenticationType == null ? null : authenticationType.toString());
            return this;
        }

        public final AzureBlobSasConfiguration.Builder getSasConfiguration() {
            return this.sasConfiguration != null ? this.sasConfiguration.toBuilder() : null;
        }

        public final void setSasConfiguration(AzureBlobSasConfiguration.BuilderImpl sasConfiguration) {
            this.sasConfiguration = sasConfiguration != null ? sasConfiguration.build() : null;
        }

        @Override
        public final Builder sasConfiguration(AzureBlobSasConfiguration sasConfiguration) {
            this.sasConfiguration = sasConfiguration;
            return this;
        }

        public final String getBlobType() {
            return this.blobType;
        }

        public final void setBlobType(String blobType) {
            this.blobType = blobType;
        }

        @Override
        public final Builder blobType(String blobType) {
            this.blobType = blobType;
            return this;
        }

        @Override
        public final Builder blobType(AzureBlobType blobType) {
            this.blobType(blobType == null ? null : blobType.toString());
            return this;
        }

        public final String getAccessTier() {
            return this.accessTier;
        }

        public final void setAccessTier(String accessTier) {
            this.accessTier = accessTier;
        }

        @Override
        public final Builder accessTier(String accessTier) {
            this.accessTier = accessTier;
            return this;
        }

        @Override
        public final Builder accessTier(AzureAccessTier accessTier) {
            this.accessTier(accessTier == null ? null : accessTier.toString());
            return this;
        }

        public final String getSubdirectory() {
            return this.subdirectory;
        }

        public final void setSubdirectory(String subdirectory) {
            this.subdirectory = subdirectory;
        }

        @Override
        public final Builder subdirectory(String subdirectory) {
            this.subdirectory = subdirectory;
            return this;
        }

        public final Collection<String> getAgentArns() {
            if (this.agentArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.agentArns;
        }

        public final void setAgentArns(Collection<String> agentArns) {
            this.agentArns = AgentArnListCopier.copy(agentArns);
        }

        @Override
        public final Builder agentArns(Collection<String> agentArns) {
            this.agentArns = AgentArnListCopier.copy(agentArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder agentArns(String ... agentArns) {
            this.agentArns(Arrays.asList(agentArns));
            return this;
        }

        public final List<TagListEntry.Builder> getTags() {
            List<TagListEntry.Builder> result = InputTagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<TagListEntry.BuilderImpl> tags) {
            this.tags = InputTagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<TagListEntry> tags) {
            this.tags = InputTagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(TagListEntry ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<TagListEntry.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (TagListEntry)((TagListEntry.Builder)TagListEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateLocationAzureBlobRequest build() {
            return new CreateLocationAzureBlobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends DataSyncRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateLocationAzureBlobRequest> {
        public Builder containerUrl(String var1);

        public Builder authenticationType(String var1);

        public Builder authenticationType(AzureBlobAuthenticationType var1);

        public Builder sasConfiguration(AzureBlobSasConfiguration var1);

        default public Builder sasConfiguration(Consumer<AzureBlobSasConfiguration.Builder> sasConfiguration) {
            return this.sasConfiguration((AzureBlobSasConfiguration)((AzureBlobSasConfiguration.Builder)AzureBlobSasConfiguration.builder().applyMutation(sasConfiguration)).build());
        }

        public Builder blobType(String var1);

        public Builder blobType(AzureBlobType var1);

        public Builder accessTier(String var1);

        public Builder accessTier(AzureAccessTier var1);

        public Builder subdirectory(String var1);

        public Builder agentArns(Collection<String> var1);

        public Builder agentArns(String ... var1);

        public Builder tags(Collection<TagListEntry> var1);

        public Builder tags(TagListEntry ... var1);

        public Builder tags(Consumer<TagListEntry.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

