/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datasync.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.datasync.DataSyncAsyncClient;
import software.amazon.awssdk.services.datasync.internal.UserAgentUtils;
import software.amazon.awssdk.services.datasync.model.ListLocationsRequest;
import software.amazon.awssdk.services.datasync.model.ListLocationsResponse;
import software.amazon.awssdk.services.datasync.model.LocationListEntry;

public class ListLocationsPublisher
implements SdkPublisher<ListLocationsResponse> {
    private final DataSyncAsyncClient client;
    private final ListLocationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListLocationsPublisher(DataSyncAsyncClient client, ListLocationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListLocationsPublisher(DataSyncAsyncClient client, ListLocationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListLocationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListLocationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<LocationListEntry> locations() {
        Function<ListLocationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.locations() != null) {
                return response.locations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListLocationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListLocationsResponseFetcher
    implements AsyncPageFetcher<ListLocationsResponse> {
        private ListLocationsResponseFetcher() {
        }

        public boolean hasNextPage(ListLocationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListLocationsResponse> nextPage(ListLocationsResponse previousPage) {
            if (previousPage == null) {
                return ListLocationsPublisher.this.client.listLocations(ListLocationsPublisher.this.firstRequest);
            }
            return ListLocationsPublisher.this.client.listLocations((ListLocationsRequest)((Object)ListLocationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

