/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datasync.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum HdfsDataTransferProtection {
    DISABLED("DISABLED"),
    AUTHENTICATION("AUTHENTICATION"),
    INTEGRITY("INTEGRITY"),
    PRIVACY("PRIVACY"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, HdfsDataTransferProtection> VALUE_MAP;
    private final String value;

    private HdfsDataTransferProtection(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static HdfsDataTransferProtection fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<HdfsDataTransferProtection> knownValues() {
        EnumSet<HdfsDataTransferProtection> knownValues = EnumSet.allOf(HdfsDataTransferProtection.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(HdfsDataTransferProtection.class, HdfsDataTransferProtection::toString);
    }
}

