/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datasync.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.datasync.DataSyncAsyncClient;
import software.amazon.awssdk.services.datasync.internal.UserAgentUtils;
import software.amazon.awssdk.services.datasync.model.DiscoveryJobListEntry;
import software.amazon.awssdk.services.datasync.model.ListDiscoveryJobsRequest;
import software.amazon.awssdk.services.datasync.model.ListDiscoveryJobsResponse;

public class ListDiscoveryJobsPublisher
implements SdkPublisher<ListDiscoveryJobsResponse> {
    private final DataSyncAsyncClient client;
    private final ListDiscoveryJobsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDiscoveryJobsPublisher(DataSyncAsyncClient client, ListDiscoveryJobsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDiscoveryJobsPublisher(DataSyncAsyncClient client, ListDiscoveryJobsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDiscoveryJobsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDiscoveryJobsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DiscoveryJobListEntry> discoveryJobs() {
        Function<ListDiscoveryJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.discoveryJobs() != null) {
                return response.discoveryJobs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListDiscoveryJobsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListDiscoveryJobsResponseFetcher
    implements AsyncPageFetcher<ListDiscoveryJobsResponse> {
        private ListDiscoveryJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListDiscoveryJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListDiscoveryJobsResponse> nextPage(ListDiscoveryJobsResponse previousPage) {
            if (previousPage == null) {
                return ListDiscoveryJobsPublisher.this.client.listDiscoveryJobs(ListDiscoveryJobsPublisher.this.firstRequest);
            }
            return ListDiscoveryJobsPublisher.this.client.listDiscoveryJobs((ListDiscoveryJobsRequest)((Object)ListDiscoveryJobsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

