/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datasync.model;

import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datasync.model.AgentArnListCopier;
import software.amazon.awssdk.services.datasync.model.DataSyncResponse;
import software.amazon.awssdk.services.datasync.model.ObjectStorageServerProtocol;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeLocationObjectStorageResponse
extends DataSyncResponse
implements ToCopyableBuilder<Builder, DescribeLocationObjectStorageResponse> {
    private static final SdkField<String> LOCATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LocationArn").getter(DescribeLocationObjectStorageResponse.getter(DescribeLocationObjectStorageResponse::locationArn)).setter(DescribeLocationObjectStorageResponse.setter(Builder::locationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocationArn").build()}).build();
    private static final SdkField<String> LOCATION_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LocationUri").getter(DescribeLocationObjectStorageResponse.getter(DescribeLocationObjectStorageResponse::locationUri)).setter(DescribeLocationObjectStorageResponse.setter(Builder::locationUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocationUri").build()}).build();
    private static final SdkField<String> ACCESS_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccessKey").getter(DescribeLocationObjectStorageResponse.getter(DescribeLocationObjectStorageResponse::accessKey)).setter(DescribeLocationObjectStorageResponse.setter(Builder::accessKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessKey").build()}).build();
    private static final SdkField<Integer> SERVER_PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ServerPort").getter(DescribeLocationObjectStorageResponse.getter(DescribeLocationObjectStorageResponse::serverPort)).setter(DescribeLocationObjectStorageResponse.setter(Builder::serverPort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerPort").build()}).build();
    private static final SdkField<String> SERVER_PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServerProtocol").getter(DescribeLocationObjectStorageResponse.getter(DescribeLocationObjectStorageResponse::serverProtocolAsString)).setter(DescribeLocationObjectStorageResponse.setter(Builder::serverProtocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerProtocol").build()}).build();
    private static final SdkField<List<String>> AGENT_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AgentArns").getter(DescribeLocationObjectStorageResponse.getter(DescribeLocationObjectStorageResponse::agentArns)).setter(DescribeLocationObjectStorageResponse.setter(Builder::agentArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AgentArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(DescribeLocationObjectStorageResponse.getter(DescribeLocationObjectStorageResponse::creationTime)).setter(DescribeLocationObjectStorageResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<SdkBytes> SERVER_CERTIFICATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("ServerCertificate").getter(DescribeLocationObjectStorageResponse.getter(DescribeLocationObjectStorageResponse::serverCertificate)).setter(DescribeLocationObjectStorageResponse.setter(Builder::serverCertificate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerCertificate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOCATION_ARN_FIELD, LOCATION_URI_FIELD, ACCESS_KEY_FIELD, SERVER_PORT_FIELD, SERVER_PROTOCOL_FIELD, AGENT_ARNS_FIELD, CREATION_TIME_FIELD, SERVER_CERTIFICATE_FIELD));
    private final String locationArn;
    private final String locationUri;
    private final String accessKey;
    private final Integer serverPort;
    private final String serverProtocol;
    private final List<String> agentArns;
    private final Instant creationTime;
    private final SdkBytes serverCertificate;

    private DescribeLocationObjectStorageResponse(BuilderImpl builder) {
        super(builder);
        this.locationArn = builder.locationArn;
        this.locationUri = builder.locationUri;
        this.accessKey = builder.accessKey;
        this.serverPort = builder.serverPort;
        this.serverProtocol = builder.serverProtocol;
        this.agentArns = builder.agentArns;
        this.creationTime = builder.creationTime;
        this.serverCertificate = builder.serverCertificate;
    }

    public final String locationArn() {
        return this.locationArn;
    }

    public final String locationUri() {
        return this.locationUri;
    }

    public final String accessKey() {
        return this.accessKey;
    }

    public final Integer serverPort() {
        return this.serverPort;
    }

    public final ObjectStorageServerProtocol serverProtocol() {
        return ObjectStorageServerProtocol.fromValue(this.serverProtocol);
    }

    public final String serverProtocolAsString() {
        return this.serverProtocol;
    }

    public final boolean hasAgentArns() {
        return this.agentArns != null && !(this.agentArns instanceof SdkAutoConstructList);
    }

    public final List<String> agentArns() {
        return this.agentArns;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final SdkBytes serverCertificate() {
        return this.serverCertificate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.locationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.locationUri());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverPort());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverProtocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAgentArns() ? this.agentArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverCertificate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLocationObjectStorageResponse)) {
            return false;
        }
        DescribeLocationObjectStorageResponse other = (DescribeLocationObjectStorageResponse)((Object)obj);
        return Objects.equals(this.locationArn(), other.locationArn()) && Objects.equals(this.locationUri(), other.locationUri()) && Objects.equals(this.accessKey(), other.accessKey()) && Objects.equals(this.serverPort(), other.serverPort()) && Objects.equals(this.serverProtocolAsString(), other.serverProtocolAsString()) && this.hasAgentArns() == other.hasAgentArns() && Objects.equals(this.agentArns(), other.agentArns()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.serverCertificate(), other.serverCertificate());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeLocationObjectStorageResponse").add("LocationArn", (Object)this.locationArn()).add("LocationUri", (Object)this.locationUri()).add("AccessKey", (Object)this.accessKey()).add("ServerPort", (Object)this.serverPort()).add("ServerProtocol", (Object)this.serverProtocolAsString()).add("AgentArns", this.hasAgentArns() ? this.agentArns() : null).add("CreationTime", (Object)this.creationTime()).add("ServerCertificate", (Object)this.serverCertificate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LocationArn": {
                return Optional.ofNullable(clazz.cast(this.locationArn()));
            }
            case "LocationUri": {
                return Optional.ofNullable(clazz.cast(this.locationUri()));
            }
            case "AccessKey": {
                return Optional.ofNullable(clazz.cast(this.accessKey()));
            }
            case "ServerPort": {
                return Optional.ofNullable(clazz.cast(this.serverPort()));
            }
            case "ServerProtocol": {
                return Optional.ofNullable(clazz.cast(this.serverProtocolAsString()));
            }
            case "AgentArns": {
                return Optional.ofNullable(clazz.cast(this.agentArns()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "ServerCertificate": {
                return Optional.ofNullable(clazz.cast(this.serverCertificate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeLocationObjectStorageResponse, T> g) {
        return obj -> g.apply((DescribeLocationObjectStorageResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataSyncResponse.BuilderImpl
    implements Builder {
        private String locationArn;
        private String locationUri;
        private String accessKey;
        private Integer serverPort;
        private String serverProtocol;
        private List<String> agentArns = DefaultSdkAutoConstructList.getInstance();
        private Instant creationTime;
        private SdkBytes serverCertificate;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLocationObjectStorageResponse model) {
            super(model);
            this.locationArn(model.locationArn);
            this.locationUri(model.locationUri);
            this.accessKey(model.accessKey);
            this.serverPort(model.serverPort);
            this.serverProtocol(model.serverProtocol);
            this.agentArns(model.agentArns);
            this.creationTime(model.creationTime);
            this.serverCertificate(model.serverCertificate);
        }

        public final String getLocationArn() {
            return this.locationArn;
        }

        public final void setLocationArn(String locationArn) {
            this.locationArn = locationArn;
        }

        @Override
        public final Builder locationArn(String locationArn) {
            this.locationArn = locationArn;
            return this;
        }

        public final String getLocationUri() {
            return this.locationUri;
        }

        public final void setLocationUri(String locationUri) {
            this.locationUri = locationUri;
        }

        @Override
        public final Builder locationUri(String locationUri) {
            this.locationUri = locationUri;
            return this;
        }

        public final String getAccessKey() {
            return this.accessKey;
        }

        public final void setAccessKey(String accessKey) {
            this.accessKey = accessKey;
        }

        @Override
        public final Builder accessKey(String accessKey) {
            this.accessKey = accessKey;
            return this;
        }

        public final Integer getServerPort() {
            return this.serverPort;
        }

        public final void setServerPort(Integer serverPort) {
            this.serverPort = serverPort;
        }

        @Override
        public final Builder serverPort(Integer serverPort) {
            this.serverPort = serverPort;
            return this;
        }

        public final String getServerProtocol() {
            return this.serverProtocol;
        }

        public final void setServerProtocol(String serverProtocol) {
            this.serverProtocol = serverProtocol;
        }

        @Override
        public final Builder serverProtocol(String serverProtocol) {
            this.serverProtocol = serverProtocol;
            return this;
        }

        @Override
        public final Builder serverProtocol(ObjectStorageServerProtocol serverProtocol) {
            this.serverProtocol(serverProtocol == null ? null : serverProtocol.toString());
            return this;
        }

        public final Collection<String> getAgentArns() {
            if (this.agentArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.agentArns;
        }

        public final void setAgentArns(Collection<String> agentArns) {
            this.agentArns = AgentArnListCopier.copy(agentArns);
        }

        @Override
        public final Builder agentArns(Collection<String> agentArns) {
            this.agentArns = AgentArnListCopier.copy(agentArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder agentArns(String ... agentArns) {
            this.agentArns(Arrays.asList(agentArns));
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final ByteBuffer getServerCertificate() {
            return this.serverCertificate == null ? null : this.serverCertificate.asByteBuffer();
        }

        public final void setServerCertificate(ByteBuffer serverCertificate) {
            this.serverCertificate(serverCertificate == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)serverCertificate));
        }

        @Override
        public final Builder serverCertificate(SdkBytes serverCertificate) {
            this.serverCertificate = serverCertificate;
            return this;
        }

        @Override
        public DescribeLocationObjectStorageResponse build() {
            return new DescribeLocationObjectStorageResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DataSyncResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeLocationObjectStorageResponse> {
        public Builder locationArn(String var1);

        public Builder locationUri(String var1);

        public Builder accessKey(String var1);

        public Builder serverPort(Integer var1);

        public Builder serverProtocol(String var1);

        public Builder serverProtocol(ObjectStorageServerProtocol var1);

        public Builder agentArns(Collection<String> var1);

        public Builder agentArns(String ... var1);

        public Builder creationTime(Instant var1);

        public Builder serverCertificate(SdkBytes var1);
    }
}

