/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datasync.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.datasync.DataSyncAsyncClient;
import software.amazon.awssdk.services.datasync.internal.UserAgentUtils;
import software.amazon.awssdk.services.datasync.model.ListStorageSystemsRequest;
import software.amazon.awssdk.services.datasync.model.ListStorageSystemsResponse;
import software.amazon.awssdk.services.datasync.model.StorageSystemListEntry;

public class ListStorageSystemsPublisher
implements SdkPublisher<ListStorageSystemsResponse> {
    private final DataSyncAsyncClient client;
    private final ListStorageSystemsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListStorageSystemsPublisher(DataSyncAsyncClient client, ListStorageSystemsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListStorageSystemsPublisher(DataSyncAsyncClient client, ListStorageSystemsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListStorageSystemsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListStorageSystemsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<StorageSystemListEntry> storageSystems() {
        Function<ListStorageSystemsResponse, Iterator> getIterator = response -> {
            if (response != null && response.storageSystems() != null) {
                return response.storageSystems().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListStorageSystemsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListStorageSystemsResponseFetcher
    implements AsyncPageFetcher<ListStorageSystemsResponse> {
        private ListStorageSystemsResponseFetcher() {
        }

        public boolean hasNextPage(ListStorageSystemsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListStorageSystemsResponse> nextPage(ListStorageSystemsResponse previousPage) {
            if (previousPage == null) {
                return ListStorageSystemsPublisher.this.client.listStorageSystems(ListStorageSystemsPublisher.this.firstRequest);
            }
            return ListStorageSystemsPublisher.this.client.listStorageSystems((ListStorageSystemsRequest)((Object)ListStorageSystemsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

