/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datasync.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.datasync.DataSyncClient;
import software.amazon.awssdk.services.datasync.model.ListStorageSystemsRequest;
import software.amazon.awssdk.services.datasync.model.ListStorageSystemsResponse;
import software.amazon.awssdk.services.datasync.model.StorageSystemListEntry;

public class ListStorageSystemsIterable
implements SdkIterable<ListStorageSystemsResponse> {
    private final DataSyncClient client;
    private final ListStorageSystemsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListStorageSystemsIterable(DataSyncClient client, ListStorageSystemsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListStorageSystemsResponseFetcher();
    }

    public Iterator<ListStorageSystemsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<StorageSystemListEntry> storageSystems() {
        Function<ListStorageSystemsResponse, Iterator> getIterator = response -> {
            if (response != null && response.storageSystems() != null) {
                return response.storageSystems().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListStorageSystemsResponseFetcher
    implements SyncPageFetcher<ListStorageSystemsResponse> {
        private ListStorageSystemsResponseFetcher() {
        }

        public boolean hasNextPage(ListStorageSystemsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListStorageSystemsResponse nextPage(ListStorageSystemsResponse previousPage) {
            if (previousPage == null) {
                return ListStorageSystemsIterable.this.client.listStorageSystems(ListStorageSystemsIterable.this.firstRequest);
            }
            return ListStorageSystemsIterable.this.client.listStorageSystems((ListStorageSystemsRequest)((Object)ListStorageSystemsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

