/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datasync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.datasync.model.Atime;
import software.amazon.awssdk.services.datasync.model.Gid;
import software.amazon.awssdk.services.datasync.model.LogLevel;
import software.amazon.awssdk.services.datasync.model.Mtime;
import software.amazon.awssdk.services.datasync.model.OverwriteMode;
import software.amazon.awssdk.services.datasync.model.PosixPermissions;
import software.amazon.awssdk.services.datasync.model.PreserveDeletedFiles;
import software.amazon.awssdk.services.datasync.model.PreserveDevices;
import software.amazon.awssdk.services.datasync.model.SmbSecurityDescriptorCopyFlags;
import software.amazon.awssdk.services.datasync.model.TaskQueueing;
import software.amazon.awssdk.services.datasync.model.TransferMode;
import software.amazon.awssdk.services.datasync.model.Uid;
import software.amazon.awssdk.services.datasync.model.VerifyMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Options
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Options> {
    private static final SdkField<String> VERIFY_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VerifyMode").getter(Options.getter(Options::verifyModeAsString)).setter(Options.setter(Builder::verifyMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerifyMode").build()}).build();
    private static final SdkField<String> OVERWRITE_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OverwriteMode").getter(Options.getter(Options::overwriteModeAsString)).setter(Options.setter(Builder::overwriteMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OverwriteMode").build()}).build();
    private static final SdkField<String> ATIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Atime").getter(Options.getter(Options::atimeAsString)).setter(Options.setter(Builder::atime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Atime").build()}).build();
    private static final SdkField<String> MTIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Mtime").getter(Options.getter(Options::mtimeAsString)).setter(Options.setter(Builder::mtime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mtime").build()}).build();
    private static final SdkField<String> UID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Uid").getter(Options.getter(Options::uidAsString)).setter(Options.setter(Builder::uid)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Uid").build()}).build();
    private static final SdkField<String> GID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Gid").getter(Options.getter(Options::gidAsString)).setter(Options.setter(Builder::gid)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Gid").build()}).build();
    private static final SdkField<String> PRESERVE_DELETED_FILES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PreserveDeletedFiles").getter(Options.getter(Options::preserveDeletedFilesAsString)).setter(Options.setter(Builder::preserveDeletedFiles)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreserveDeletedFiles").build()}).build();
    private static final SdkField<String> PRESERVE_DEVICES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PreserveDevices").getter(Options.getter(Options::preserveDevicesAsString)).setter(Options.setter(Builder::preserveDevices)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreserveDevices").build()}).build();
    private static final SdkField<String> POSIX_PERMISSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PosixPermissions").getter(Options.getter(Options::posixPermissionsAsString)).setter(Options.setter(Builder::posixPermissions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PosixPermissions").build()}).build();
    private static final SdkField<Long> BYTES_PER_SECOND_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("BytesPerSecond").getter(Options.getter(Options::bytesPerSecond)).setter(Options.setter(Builder::bytesPerSecond)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BytesPerSecond").build()}).build();
    private static final SdkField<String> TASK_QUEUEING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TaskQueueing").getter(Options.getter(Options::taskQueueingAsString)).setter(Options.setter(Builder::taskQueueing)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskQueueing").build()}).build();
    private static final SdkField<String> LOG_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LogLevel").getter(Options.getter(Options::logLevelAsString)).setter(Options.setter(Builder::logLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogLevel").build()}).build();
    private static final SdkField<String> TRANSFER_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TransferMode").getter(Options.getter(Options::transferModeAsString)).setter(Options.setter(Builder::transferMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransferMode").build()}).build();
    private static final SdkField<String> SECURITY_DESCRIPTOR_COPY_FLAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecurityDescriptorCopyFlags").getter(Options.getter(Options::securityDescriptorCopyFlagsAsString)).setter(Options.setter(Builder::securityDescriptorCopyFlags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityDescriptorCopyFlags").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VERIFY_MODE_FIELD, OVERWRITE_MODE_FIELD, ATIME_FIELD, MTIME_FIELD, UID_FIELD, GID_FIELD, PRESERVE_DELETED_FILES_FIELD, PRESERVE_DEVICES_FIELD, POSIX_PERMISSIONS_FIELD, BYTES_PER_SECOND_FIELD, TASK_QUEUEING_FIELD, LOG_LEVEL_FIELD, TRANSFER_MODE_FIELD, SECURITY_DESCRIPTOR_COPY_FLAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String verifyMode;
    private final String overwriteMode;
    private final String atime;
    private final String mtime;
    private final String uid;
    private final String gid;
    private final String preserveDeletedFiles;
    private final String preserveDevices;
    private final String posixPermissions;
    private final Long bytesPerSecond;
    private final String taskQueueing;
    private final String logLevel;
    private final String transferMode;
    private final String securityDescriptorCopyFlags;

    private Options(BuilderImpl builder) {
        this.verifyMode = builder.verifyMode;
        this.overwriteMode = builder.overwriteMode;
        this.atime = builder.atime;
        this.mtime = builder.mtime;
        this.uid = builder.uid;
        this.gid = builder.gid;
        this.preserveDeletedFiles = builder.preserveDeletedFiles;
        this.preserveDevices = builder.preserveDevices;
        this.posixPermissions = builder.posixPermissions;
        this.bytesPerSecond = builder.bytesPerSecond;
        this.taskQueueing = builder.taskQueueing;
        this.logLevel = builder.logLevel;
        this.transferMode = builder.transferMode;
        this.securityDescriptorCopyFlags = builder.securityDescriptorCopyFlags;
    }

    public final VerifyMode verifyMode() {
        return VerifyMode.fromValue(this.verifyMode);
    }

    public final String verifyModeAsString() {
        return this.verifyMode;
    }

    public final OverwriteMode overwriteMode() {
        return OverwriteMode.fromValue(this.overwriteMode);
    }

    public final String overwriteModeAsString() {
        return this.overwriteMode;
    }

    public final Atime atime() {
        return Atime.fromValue(this.atime);
    }

    public final String atimeAsString() {
        return this.atime;
    }

    public final Mtime mtime() {
        return Mtime.fromValue(this.mtime);
    }

    public final String mtimeAsString() {
        return this.mtime;
    }

    public final Uid uid() {
        return Uid.fromValue(this.uid);
    }

    public final String uidAsString() {
        return this.uid;
    }

    public final Gid gid() {
        return Gid.fromValue(this.gid);
    }

    public final String gidAsString() {
        return this.gid;
    }

    public final PreserveDeletedFiles preserveDeletedFiles() {
        return PreserveDeletedFiles.fromValue(this.preserveDeletedFiles);
    }

    public final String preserveDeletedFilesAsString() {
        return this.preserveDeletedFiles;
    }

    public final PreserveDevices preserveDevices() {
        return PreserveDevices.fromValue(this.preserveDevices);
    }

    public final String preserveDevicesAsString() {
        return this.preserveDevices;
    }

    public final PosixPermissions posixPermissions() {
        return PosixPermissions.fromValue(this.posixPermissions);
    }

    public final String posixPermissionsAsString() {
        return this.posixPermissions;
    }

    public final Long bytesPerSecond() {
        return this.bytesPerSecond;
    }

    public final TaskQueueing taskQueueing() {
        return TaskQueueing.fromValue(this.taskQueueing);
    }

    public final String taskQueueingAsString() {
        return this.taskQueueing;
    }

    public final LogLevel logLevel() {
        return LogLevel.fromValue(this.logLevel);
    }

    public final String logLevelAsString() {
        return this.logLevel;
    }

    public final TransferMode transferMode() {
        return TransferMode.fromValue(this.transferMode);
    }

    public final String transferModeAsString() {
        return this.transferMode;
    }

    public final SmbSecurityDescriptorCopyFlags securityDescriptorCopyFlags() {
        return SmbSecurityDescriptorCopyFlags.fromValue(this.securityDescriptorCopyFlags);
    }

    public final String securityDescriptorCopyFlagsAsString() {
        return this.securityDescriptorCopyFlags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.verifyModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.overwriteModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.atimeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.mtimeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.uidAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.gidAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.preserveDeletedFilesAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.preserveDevicesAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.posixPermissionsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.bytesPerSecond());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskQueueingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.logLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.transferModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityDescriptorCopyFlagsAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Options)) {
            return false;
        }
        Options other = (Options)obj;
        return Objects.equals(this.verifyModeAsString(), other.verifyModeAsString()) && Objects.equals(this.overwriteModeAsString(), other.overwriteModeAsString()) && Objects.equals(this.atimeAsString(), other.atimeAsString()) && Objects.equals(this.mtimeAsString(), other.mtimeAsString()) && Objects.equals(this.uidAsString(), other.uidAsString()) && Objects.equals(this.gidAsString(), other.gidAsString()) && Objects.equals(this.preserveDeletedFilesAsString(), other.preserveDeletedFilesAsString()) && Objects.equals(this.preserveDevicesAsString(), other.preserveDevicesAsString()) && Objects.equals(this.posixPermissionsAsString(), other.posixPermissionsAsString()) && Objects.equals(this.bytesPerSecond(), other.bytesPerSecond()) && Objects.equals(this.taskQueueingAsString(), other.taskQueueingAsString()) && Objects.equals(this.logLevelAsString(), other.logLevelAsString()) && Objects.equals(this.transferModeAsString(), other.transferModeAsString()) && Objects.equals(this.securityDescriptorCopyFlagsAsString(), other.securityDescriptorCopyFlagsAsString());
    }

    public final String toString() {
        return ToString.builder((String)"Options").add("VerifyMode", (Object)this.verifyModeAsString()).add("OverwriteMode", (Object)this.overwriteModeAsString()).add("Atime", (Object)this.atimeAsString()).add("Mtime", (Object)this.mtimeAsString()).add("Uid", (Object)this.uidAsString()).add("Gid", (Object)this.gidAsString()).add("PreserveDeletedFiles", (Object)this.preserveDeletedFilesAsString()).add("PreserveDevices", (Object)this.preserveDevicesAsString()).add("PosixPermissions", (Object)this.posixPermissionsAsString()).add("BytesPerSecond", (Object)this.bytesPerSecond()).add("TaskQueueing", (Object)this.taskQueueingAsString()).add("LogLevel", (Object)this.logLevelAsString()).add("TransferMode", (Object)this.transferModeAsString()).add("SecurityDescriptorCopyFlags", (Object)this.securityDescriptorCopyFlagsAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VerifyMode": {
                return Optional.ofNullable(clazz.cast(this.verifyModeAsString()));
            }
            case "OverwriteMode": {
                return Optional.ofNullable(clazz.cast(this.overwriteModeAsString()));
            }
            case "Atime": {
                return Optional.ofNullable(clazz.cast(this.atimeAsString()));
            }
            case "Mtime": {
                return Optional.ofNullable(clazz.cast(this.mtimeAsString()));
            }
            case "Uid": {
                return Optional.ofNullable(clazz.cast(this.uidAsString()));
            }
            case "Gid": {
                return Optional.ofNullable(clazz.cast(this.gidAsString()));
            }
            case "PreserveDeletedFiles": {
                return Optional.ofNullable(clazz.cast(this.preserveDeletedFilesAsString()));
            }
            case "PreserveDevices": {
                return Optional.ofNullable(clazz.cast(this.preserveDevicesAsString()));
            }
            case "PosixPermissions": {
                return Optional.ofNullable(clazz.cast(this.posixPermissionsAsString()));
            }
            case "BytesPerSecond": {
                return Optional.ofNullable(clazz.cast(this.bytesPerSecond()));
            }
            case "TaskQueueing": {
                return Optional.ofNullable(clazz.cast(this.taskQueueingAsString()));
            }
            case "LogLevel": {
                return Optional.ofNullable(clazz.cast(this.logLevelAsString()));
            }
            case "TransferMode": {
                return Optional.ofNullable(clazz.cast(this.transferModeAsString()));
            }
            case "SecurityDescriptorCopyFlags": {
                return Optional.ofNullable(clazz.cast(this.securityDescriptorCopyFlagsAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Options, T> g) {
        return obj -> g.apply((Options)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String verifyMode;
        private String overwriteMode;
        private String atime;
        private String mtime;
        private String uid;
        private String gid;
        private String preserveDeletedFiles;
        private String preserveDevices;
        private String posixPermissions;
        private Long bytesPerSecond;
        private String taskQueueing;
        private String logLevel;
        private String transferMode;
        private String securityDescriptorCopyFlags;

        private BuilderImpl() {
        }

        private BuilderImpl(Options model) {
            this.verifyMode(model.verifyMode);
            this.overwriteMode(model.overwriteMode);
            this.atime(model.atime);
            this.mtime(model.mtime);
            this.uid(model.uid);
            this.gid(model.gid);
            this.preserveDeletedFiles(model.preserveDeletedFiles);
            this.preserveDevices(model.preserveDevices);
            this.posixPermissions(model.posixPermissions);
            this.bytesPerSecond(model.bytesPerSecond);
            this.taskQueueing(model.taskQueueing);
            this.logLevel(model.logLevel);
            this.transferMode(model.transferMode);
            this.securityDescriptorCopyFlags(model.securityDescriptorCopyFlags);
        }

        public final String getVerifyMode() {
            return this.verifyMode;
        }

        @Override
        public final Builder verifyMode(String verifyMode) {
            this.verifyMode = verifyMode;
            return this;
        }

        @Override
        public final Builder verifyMode(VerifyMode verifyMode) {
            this.verifyMode(verifyMode == null ? null : verifyMode.toString());
            return this;
        }

        public final void setVerifyMode(String verifyMode) {
            this.verifyMode = verifyMode;
        }

        public final String getOverwriteMode() {
            return this.overwriteMode;
        }

        @Override
        public final Builder overwriteMode(String overwriteMode) {
            this.overwriteMode = overwriteMode;
            return this;
        }

        @Override
        public final Builder overwriteMode(OverwriteMode overwriteMode) {
            this.overwriteMode(overwriteMode == null ? null : overwriteMode.toString());
            return this;
        }

        public final void setOverwriteMode(String overwriteMode) {
            this.overwriteMode = overwriteMode;
        }

        public final String getAtime() {
            return this.atime;
        }

        @Override
        public final Builder atime(String atime) {
            this.atime = atime;
            return this;
        }

        @Override
        public final Builder atime(Atime atime) {
            this.atime(atime == null ? null : atime.toString());
            return this;
        }

        public final void setAtime(String atime) {
            this.atime = atime;
        }

        public final String getMtime() {
            return this.mtime;
        }

        @Override
        public final Builder mtime(String mtime) {
            this.mtime = mtime;
            return this;
        }

        @Override
        public final Builder mtime(Mtime mtime) {
            this.mtime(mtime == null ? null : mtime.toString());
            return this;
        }

        public final void setMtime(String mtime) {
            this.mtime = mtime;
        }

        public final String getUid() {
            return this.uid;
        }

        @Override
        public final Builder uid(String uid) {
            this.uid = uid;
            return this;
        }

        @Override
        public final Builder uid(Uid uid) {
            this.uid(uid == null ? null : uid.toString());
            return this;
        }

        public final void setUid(String uid) {
            this.uid = uid;
        }

        public final String getGid() {
            return this.gid;
        }

        @Override
        public final Builder gid(String gid) {
            this.gid = gid;
            return this;
        }

        @Override
        public final Builder gid(Gid gid) {
            this.gid(gid == null ? null : gid.toString());
            return this;
        }

        public final void setGid(String gid) {
            this.gid = gid;
        }

        public final String getPreserveDeletedFiles() {
            return this.preserveDeletedFiles;
        }

        @Override
        public final Builder preserveDeletedFiles(String preserveDeletedFiles) {
            this.preserveDeletedFiles = preserveDeletedFiles;
            return this;
        }

        @Override
        public final Builder preserveDeletedFiles(PreserveDeletedFiles preserveDeletedFiles) {
            this.preserveDeletedFiles(preserveDeletedFiles == null ? null : preserveDeletedFiles.toString());
            return this;
        }

        public final void setPreserveDeletedFiles(String preserveDeletedFiles) {
            this.preserveDeletedFiles = preserveDeletedFiles;
        }

        public final String getPreserveDevices() {
            return this.preserveDevices;
        }

        @Override
        public final Builder preserveDevices(String preserveDevices) {
            this.preserveDevices = preserveDevices;
            return this;
        }

        @Override
        public final Builder preserveDevices(PreserveDevices preserveDevices) {
            this.preserveDevices(preserveDevices == null ? null : preserveDevices.toString());
            return this;
        }

        public final void setPreserveDevices(String preserveDevices) {
            this.preserveDevices = preserveDevices;
        }

        public final String getPosixPermissions() {
            return this.posixPermissions;
        }

        @Override
        public final Builder posixPermissions(String posixPermissions) {
            this.posixPermissions = posixPermissions;
            return this;
        }

        @Override
        public final Builder posixPermissions(PosixPermissions posixPermissions) {
            this.posixPermissions(posixPermissions == null ? null : posixPermissions.toString());
            return this;
        }

        public final void setPosixPermissions(String posixPermissions) {
            this.posixPermissions = posixPermissions;
        }

        public final Long getBytesPerSecond() {
            return this.bytesPerSecond;
        }

        @Override
        public final Builder bytesPerSecond(Long bytesPerSecond) {
            this.bytesPerSecond = bytesPerSecond;
            return this;
        }

        public final void setBytesPerSecond(Long bytesPerSecond) {
            this.bytesPerSecond = bytesPerSecond;
        }

        public final String getTaskQueueing() {
            return this.taskQueueing;
        }

        @Override
        public final Builder taskQueueing(String taskQueueing) {
            this.taskQueueing = taskQueueing;
            return this;
        }

        @Override
        public final Builder taskQueueing(TaskQueueing taskQueueing) {
            this.taskQueueing(taskQueueing == null ? null : taskQueueing.toString());
            return this;
        }

        public final void setTaskQueueing(String taskQueueing) {
            this.taskQueueing = taskQueueing;
        }

        public final String getLogLevel() {
            return this.logLevel;
        }

        @Override
        public final Builder logLevel(String logLevel) {
            this.logLevel = logLevel;
            return this;
        }

        @Override
        public final Builder logLevel(LogLevel logLevel) {
            this.logLevel(logLevel == null ? null : logLevel.toString());
            return this;
        }

        public final void setLogLevel(String logLevel) {
            this.logLevel = logLevel;
        }

        public final String getTransferMode() {
            return this.transferMode;
        }

        @Override
        public final Builder transferMode(String transferMode) {
            this.transferMode = transferMode;
            return this;
        }

        @Override
        public final Builder transferMode(TransferMode transferMode) {
            this.transferMode(transferMode == null ? null : transferMode.toString());
            return this;
        }

        public final void setTransferMode(String transferMode) {
            this.transferMode = transferMode;
        }

        public final String getSecurityDescriptorCopyFlags() {
            return this.securityDescriptorCopyFlags;
        }

        @Override
        public final Builder securityDescriptorCopyFlags(String securityDescriptorCopyFlags) {
            this.securityDescriptorCopyFlags = securityDescriptorCopyFlags;
            return this;
        }

        @Override
        public final Builder securityDescriptorCopyFlags(SmbSecurityDescriptorCopyFlags securityDescriptorCopyFlags) {
            this.securityDescriptorCopyFlags(securityDescriptorCopyFlags == null ? null : securityDescriptorCopyFlags.toString());
            return this;
        }

        public final void setSecurityDescriptorCopyFlags(String securityDescriptorCopyFlags) {
            this.securityDescriptorCopyFlags = securityDescriptorCopyFlags;
        }

        public Options build() {
            return new Options(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Options> {
        public Builder verifyMode(String var1);

        public Builder verifyMode(VerifyMode var1);

        public Builder overwriteMode(String var1);

        public Builder overwriteMode(OverwriteMode var1);

        public Builder atime(String var1);

        public Builder atime(Atime var1);

        public Builder mtime(String var1);

        public Builder mtime(Mtime var1);

        public Builder uid(String var1);

        public Builder uid(Uid var1);

        public Builder gid(String var1);

        public Builder gid(Gid var1);

        public Builder preserveDeletedFiles(String var1);

        public Builder preserveDeletedFiles(PreserveDeletedFiles var1);

        public Builder preserveDevices(String var1);

        public Builder preserveDevices(PreserveDevices var1);

        public Builder posixPermissions(String var1);

        public Builder posixPermissions(PosixPermissions var1);

        public Builder bytesPerSecond(Long var1);

        public Builder taskQueueing(String var1);

        public Builder taskQueueing(TaskQueueing var1);

        public Builder logLevel(String var1);

        public Builder logLevel(LogLevel var1);

        public Builder transferMode(String var1);

        public Builder transferMode(TransferMode var1);

        public Builder securityDescriptorCopyFlags(String var1);

        public Builder securityDescriptorCopyFlags(SmbSecurityDescriptorCopyFlags var1);
    }
}

