/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datasync.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datasync.model.AgentArnListCopier;
import software.amazon.awssdk.services.datasync.model.DataSyncResponse;
import software.amazon.awssdk.services.datasync.model.S3Config;
import software.amazon.awssdk.services.datasync.model.S3StorageClass;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeLocationS3Response
extends DataSyncResponse
implements ToCopyableBuilder<Builder, DescribeLocationS3Response> {
    private static final SdkField<String> LOCATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LocationArn").getter(DescribeLocationS3Response.getter(DescribeLocationS3Response::locationArn)).setter(DescribeLocationS3Response.setter(Builder::locationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocationArn").build()}).build();
    private static final SdkField<String> LOCATION_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LocationUri").getter(DescribeLocationS3Response.getter(DescribeLocationS3Response::locationUri)).setter(DescribeLocationS3Response.setter(Builder::locationUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocationUri").build()}).build();
    private static final SdkField<String> S3_STORAGE_CLASS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3StorageClass").getter(DescribeLocationS3Response.getter(DescribeLocationS3Response::s3StorageClassAsString)).setter(DescribeLocationS3Response.setter(Builder::s3StorageClass)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3StorageClass").build()}).build();
    private static final SdkField<S3Config> S3_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("S3Config").getter(DescribeLocationS3Response.getter(DescribeLocationS3Response::s3Config)).setter(DescribeLocationS3Response.setter(Builder::s3Config)).constructor(S3Config::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Config").build()}).build();
    private static final SdkField<List<String>> AGENT_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AgentArns").getter(DescribeLocationS3Response.getter(DescribeLocationS3Response::agentArns)).setter(DescribeLocationS3Response.setter(Builder::agentArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AgentArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(DescribeLocationS3Response.getter(DescribeLocationS3Response::creationTime)).setter(DescribeLocationS3Response.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOCATION_ARN_FIELD, LOCATION_URI_FIELD, S3_STORAGE_CLASS_FIELD, S3_CONFIG_FIELD, AGENT_ARNS_FIELD, CREATION_TIME_FIELD));
    private final String locationArn;
    private final String locationUri;
    private final String s3StorageClass;
    private final S3Config s3Config;
    private final List<String> agentArns;
    private final Instant creationTime;

    private DescribeLocationS3Response(BuilderImpl builder) {
        super(builder);
        this.locationArn = builder.locationArn;
        this.locationUri = builder.locationUri;
        this.s3StorageClass = builder.s3StorageClass;
        this.s3Config = builder.s3Config;
        this.agentArns = builder.agentArns;
        this.creationTime = builder.creationTime;
    }

    public String locationArn() {
        return this.locationArn;
    }

    public String locationUri() {
        return this.locationUri;
    }

    public S3StorageClass s3StorageClass() {
        return S3StorageClass.fromValue(this.s3StorageClass);
    }

    public String s3StorageClassAsString() {
        return this.s3StorageClass;
    }

    public S3Config s3Config() {
        return this.s3Config;
    }

    public boolean hasAgentArns() {
        return this.agentArns != null && !(this.agentArns instanceof SdkAutoConstructList);
    }

    public List<String> agentArns() {
        return this.agentArns;
    }

    public Instant creationTime() {
        return this.creationTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.locationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.locationUri());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3StorageClassAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Config());
        hashCode = 31 * hashCode + Objects.hashCode(this.agentArns());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLocationS3Response)) {
            return false;
        }
        DescribeLocationS3Response other = (DescribeLocationS3Response)((Object)obj);
        return Objects.equals(this.locationArn(), other.locationArn()) && Objects.equals(this.locationUri(), other.locationUri()) && Objects.equals(this.s3StorageClassAsString(), other.s3StorageClassAsString()) && Objects.equals(this.s3Config(), other.s3Config()) && Objects.equals(this.agentArns(), other.agentArns()) && Objects.equals(this.creationTime(), other.creationTime());
    }

    public String toString() {
        return ToString.builder((String)"DescribeLocationS3Response").add("LocationArn", (Object)this.locationArn()).add("LocationUri", (Object)this.locationUri()).add("S3StorageClass", (Object)this.s3StorageClassAsString()).add("S3Config", (Object)this.s3Config()).add("AgentArns", this.agentArns()).add("CreationTime", (Object)this.creationTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LocationArn": {
                return Optional.ofNullable(clazz.cast(this.locationArn()));
            }
            case "LocationUri": {
                return Optional.ofNullable(clazz.cast(this.locationUri()));
            }
            case "S3StorageClass": {
                return Optional.ofNullable(clazz.cast(this.s3StorageClassAsString()));
            }
            case "S3Config": {
                return Optional.ofNullable(clazz.cast(this.s3Config()));
            }
            case "AgentArns": {
                return Optional.ofNullable(clazz.cast(this.agentArns()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeLocationS3Response, T> g) {
        return obj -> g.apply((DescribeLocationS3Response)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataSyncResponse.BuilderImpl
    implements Builder {
        private String locationArn;
        private String locationUri;
        private String s3StorageClass;
        private S3Config s3Config;
        private List<String> agentArns = DefaultSdkAutoConstructList.getInstance();
        private Instant creationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLocationS3Response model) {
            super(model);
            this.locationArn(model.locationArn);
            this.locationUri(model.locationUri);
            this.s3StorageClass(model.s3StorageClass);
            this.s3Config(model.s3Config);
            this.agentArns(model.agentArns);
            this.creationTime(model.creationTime);
        }

        public final String getLocationArn() {
            return this.locationArn;
        }

        @Override
        public final Builder locationArn(String locationArn) {
            this.locationArn = locationArn;
            return this;
        }

        public final void setLocationArn(String locationArn) {
            this.locationArn = locationArn;
        }

        public final String getLocationUri() {
            return this.locationUri;
        }

        @Override
        public final Builder locationUri(String locationUri) {
            this.locationUri = locationUri;
            return this;
        }

        public final void setLocationUri(String locationUri) {
            this.locationUri = locationUri;
        }

        public final String getS3StorageClass() {
            return this.s3StorageClass;
        }

        @Override
        public final Builder s3StorageClass(String s3StorageClass) {
            this.s3StorageClass = s3StorageClass;
            return this;
        }

        @Override
        public final Builder s3StorageClass(S3StorageClass s3StorageClass) {
            this.s3StorageClass(s3StorageClass == null ? null : s3StorageClass.toString());
            return this;
        }

        public final void setS3StorageClass(String s3StorageClass) {
            this.s3StorageClass = s3StorageClass;
        }

        public final S3Config.Builder getS3Config() {
            return this.s3Config != null ? this.s3Config.toBuilder() : null;
        }

        @Override
        public final Builder s3Config(S3Config s3Config) {
            this.s3Config = s3Config;
            return this;
        }

        public final void setS3Config(S3Config.BuilderImpl s3Config) {
            this.s3Config = s3Config != null ? s3Config.build() : null;
        }

        public final Collection<String> getAgentArns() {
            return this.agentArns;
        }

        @Override
        public final Builder agentArns(Collection<String> agentArns) {
            this.agentArns = AgentArnListCopier.copy(agentArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder agentArns(String ... agentArns) {
            this.agentArns(Arrays.asList(agentArns));
            return this;
        }

        public final void setAgentArns(Collection<String> agentArns) {
            this.agentArns = AgentArnListCopier.copy(agentArns);
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public DescribeLocationS3Response build() {
            return new DescribeLocationS3Response(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DataSyncResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeLocationS3Response> {
        public Builder locationArn(String var1);

        public Builder locationUri(String var1);

        public Builder s3StorageClass(String var1);

        public Builder s3StorageClass(S3StorageClass var1);

        public Builder s3Config(S3Config var1);

        default public Builder s3Config(Consumer<S3Config.Builder> s3Config) {
            return this.s3Config((S3Config)((S3Config.Builder)S3Config.builder().applyMutation(s3Config)).build());
        }

        public Builder agentArns(Collection<String> var1);

        public Builder agentArns(String ... var1);

        public Builder creationTime(Instant var1);
    }
}

