/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datasync.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum SmbVersion {
    AUTOMATIC("AUTOMATIC"),
    SMB2("SMB2"),
    SMB3("SMB3"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private SmbVersion(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SmbVersion fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(SmbVersion.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SmbVersion> knownValues() {
        return Stream.of(SmbVersion.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

