/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datapipeline.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.datapipeline.model.DataPipelineRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReportTaskRunnerHeartbeatRequest
extends DataPipelineRequest
implements ToCopyableBuilder<Builder, ReportTaskRunnerHeartbeatRequest> {
    private static final SdkField<String> TASKRUNNER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ReportTaskRunnerHeartbeatRequest.getter(ReportTaskRunnerHeartbeatRequest::taskrunnerId)).setter(ReportTaskRunnerHeartbeatRequest.setter(Builder::taskrunnerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskrunnerId").build()}).build();
    private static final SdkField<String> WORKER_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ReportTaskRunnerHeartbeatRequest.getter(ReportTaskRunnerHeartbeatRequest::workerGroup)).setter(ReportTaskRunnerHeartbeatRequest.setter(Builder::workerGroup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workerGroup").build()}).build();
    private static final SdkField<String> HOSTNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ReportTaskRunnerHeartbeatRequest.getter(ReportTaskRunnerHeartbeatRequest::hostname)).setter(ReportTaskRunnerHeartbeatRequest.setter(Builder::hostname)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hostname").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASKRUNNER_ID_FIELD, WORKER_GROUP_FIELD, HOSTNAME_FIELD));
    private final String taskrunnerId;
    private final String workerGroup;
    private final String hostname;

    private ReportTaskRunnerHeartbeatRequest(BuilderImpl builder) {
        super(builder);
        this.taskrunnerId = builder.taskrunnerId;
        this.workerGroup = builder.workerGroup;
        this.hostname = builder.hostname;
    }

    public String taskrunnerId() {
        return this.taskrunnerId;
    }

    public String workerGroup() {
        return this.workerGroup;
    }

    public String hostname() {
        return this.hostname;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.taskrunnerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.workerGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostname());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReportTaskRunnerHeartbeatRequest)) {
            return false;
        }
        ReportTaskRunnerHeartbeatRequest other = (ReportTaskRunnerHeartbeatRequest)((Object)obj);
        return Objects.equals(this.taskrunnerId(), other.taskrunnerId()) && Objects.equals(this.workerGroup(), other.workerGroup()) && Objects.equals(this.hostname(), other.hostname());
    }

    public String toString() {
        return ToString.builder((String)"ReportTaskRunnerHeartbeatRequest").add("TaskrunnerId", (Object)this.taskrunnerId()).add("WorkerGroup", (Object)this.workerGroup()).add("Hostname", (Object)this.hostname()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "taskrunnerId": {
                return Optional.ofNullable(clazz.cast(this.taskrunnerId()));
            }
            case "workerGroup": {
                return Optional.ofNullable(clazz.cast(this.workerGroup()));
            }
            case "hostname": {
                return Optional.ofNullable(clazz.cast(this.hostname()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReportTaskRunnerHeartbeatRequest, T> g) {
        return obj -> g.apply((ReportTaskRunnerHeartbeatRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataPipelineRequest.BuilderImpl
    implements Builder {
        private String taskrunnerId;
        private String workerGroup;
        private String hostname;

        private BuilderImpl() {
        }

        private BuilderImpl(ReportTaskRunnerHeartbeatRequest model) {
            super(model);
            this.taskrunnerId(model.taskrunnerId);
            this.workerGroup(model.workerGroup);
            this.hostname(model.hostname);
        }

        public final String getTaskrunnerId() {
            return this.taskrunnerId;
        }

        @Override
        public final Builder taskrunnerId(String taskrunnerId) {
            this.taskrunnerId = taskrunnerId;
            return this;
        }

        public final void setTaskrunnerId(String taskrunnerId) {
            this.taskrunnerId = taskrunnerId;
        }

        public final String getWorkerGroup() {
            return this.workerGroup;
        }

        @Override
        public final Builder workerGroup(String workerGroup) {
            this.workerGroup = workerGroup;
            return this;
        }

        public final void setWorkerGroup(String workerGroup) {
            this.workerGroup = workerGroup;
        }

        public final String getHostname() {
            return this.hostname;
        }

        @Override
        public final Builder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public final void setHostname(String hostname) {
            this.hostname = hostname;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ReportTaskRunnerHeartbeatRequest build() {
            return new ReportTaskRunnerHeartbeatRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DataPipelineRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ReportTaskRunnerHeartbeatRequest> {
        public Builder taskrunnerId(String var1);

        public Builder workerGroup(String var1);

        public Builder hostname(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

