/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dataexchange.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.dataexchange.model.LakeFormationTagPolicyDetails;
import software.amazon.awssdk.services.dataexchange.model.ListOfLakeFormationTagPoliciesCopier;
import software.amazon.awssdk.services.dataexchange.model.ListOfRedshiftDataSharesCopier;
import software.amazon.awssdk.services.dataexchange.model.ListOfS3DataAccessesCopier;
import software.amazon.awssdk.services.dataexchange.model.RedshiftDataShareDetails;
import software.amazon.awssdk.services.dataexchange.model.S3DataAccessDetails;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ScopeDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ScopeDetails> {
    private static final SdkField<List<LakeFormationTagPolicyDetails>> LAKE_FORMATION_TAG_POLICIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LakeFormationTagPolicies").getter(ScopeDetails.getter(ScopeDetails::lakeFormationTagPolicies)).setter(ScopeDetails.setter(Builder::lakeFormationTagPolicies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LakeFormationTagPolicies").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LakeFormationTagPolicyDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<RedshiftDataShareDetails>> REDSHIFT_DATA_SHARES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RedshiftDataShares").getter(ScopeDetails.getter(ScopeDetails::redshiftDataShares)).setter(ScopeDetails.setter(Builder::redshiftDataShares)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RedshiftDataShares").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RedshiftDataShareDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<S3DataAccessDetails>> S3_DATA_ACCESSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("S3DataAccesses").getter(ScopeDetails.getter(ScopeDetails::s3DataAccesses)).setter(ScopeDetails.setter(Builder::s3DataAccesses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3DataAccesses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(S3DataAccessDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAKE_FORMATION_TAG_POLICIES_FIELD, REDSHIFT_DATA_SHARES_FIELD, S3_DATA_ACCESSES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ScopeDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<LakeFormationTagPolicyDetails> lakeFormationTagPolicies;
    private final List<RedshiftDataShareDetails> redshiftDataShares;
    private final List<S3DataAccessDetails> s3DataAccesses;

    private ScopeDetails(BuilderImpl builder) {
        this.lakeFormationTagPolicies = builder.lakeFormationTagPolicies;
        this.redshiftDataShares = builder.redshiftDataShares;
        this.s3DataAccesses = builder.s3DataAccesses;
    }

    public final boolean hasLakeFormationTagPolicies() {
        return this.lakeFormationTagPolicies != null && !(this.lakeFormationTagPolicies instanceof SdkAutoConstructList);
    }

    public final List<LakeFormationTagPolicyDetails> lakeFormationTagPolicies() {
        return this.lakeFormationTagPolicies;
    }

    public final boolean hasRedshiftDataShares() {
        return this.redshiftDataShares != null && !(this.redshiftDataShares instanceof SdkAutoConstructList);
    }

    public final List<RedshiftDataShareDetails> redshiftDataShares() {
        return this.redshiftDataShares;
    }

    public final boolean hasS3DataAccesses() {
        return this.s3DataAccesses != null && !(this.s3DataAccesses instanceof SdkAutoConstructList);
    }

    public final List<S3DataAccessDetails> s3DataAccesses() {
        return this.s3DataAccesses;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLakeFormationTagPolicies() ? this.lakeFormationTagPolicies() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRedshiftDataShares() ? this.redshiftDataShares() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasS3DataAccesses() ? this.s3DataAccesses() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScopeDetails)) {
            return false;
        }
        ScopeDetails other = (ScopeDetails)obj;
        return this.hasLakeFormationTagPolicies() == other.hasLakeFormationTagPolicies() && Objects.equals(this.lakeFormationTagPolicies(), other.lakeFormationTagPolicies()) && this.hasRedshiftDataShares() == other.hasRedshiftDataShares() && Objects.equals(this.redshiftDataShares(), other.redshiftDataShares()) && this.hasS3DataAccesses() == other.hasS3DataAccesses() && Objects.equals(this.s3DataAccesses(), other.s3DataAccesses());
    }

    public final String toString() {
        return ToString.builder((String)"ScopeDetails").add("LakeFormationTagPolicies", this.hasLakeFormationTagPolicies() ? this.lakeFormationTagPolicies() : null).add("RedshiftDataShares", this.hasRedshiftDataShares() ? this.redshiftDataShares() : null).add("S3DataAccesses", this.hasS3DataAccesses() ? this.s3DataAccesses() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LakeFormationTagPolicies": {
                return Optional.ofNullable(clazz.cast(this.lakeFormationTagPolicies()));
            }
            case "RedshiftDataShares": {
                return Optional.ofNullable(clazz.cast(this.redshiftDataShares()));
            }
            case "S3DataAccesses": {
                return Optional.ofNullable(clazz.cast(this.s3DataAccesses()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("LakeFormationTagPolicies", LAKE_FORMATION_TAG_POLICIES_FIELD);
        map.put("RedshiftDataShares", REDSHIFT_DATA_SHARES_FIELD);
        map.put("S3DataAccesses", S3_DATA_ACCESSES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ScopeDetails, T> g) {
        return obj -> g.apply((ScopeDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<LakeFormationTagPolicyDetails> lakeFormationTagPolicies = DefaultSdkAutoConstructList.getInstance();
        private List<RedshiftDataShareDetails> redshiftDataShares = DefaultSdkAutoConstructList.getInstance();
        private List<S3DataAccessDetails> s3DataAccesses = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ScopeDetails model) {
            this.lakeFormationTagPolicies(model.lakeFormationTagPolicies);
            this.redshiftDataShares(model.redshiftDataShares);
            this.s3DataAccesses(model.s3DataAccesses);
        }

        public final List<LakeFormationTagPolicyDetails.Builder> getLakeFormationTagPolicies() {
            List<LakeFormationTagPolicyDetails.Builder> result = ListOfLakeFormationTagPoliciesCopier.copyToBuilder(this.lakeFormationTagPolicies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLakeFormationTagPolicies(Collection<LakeFormationTagPolicyDetails.BuilderImpl> lakeFormationTagPolicies) {
            this.lakeFormationTagPolicies = ListOfLakeFormationTagPoliciesCopier.copyFromBuilder(lakeFormationTagPolicies);
        }

        @Override
        public final Builder lakeFormationTagPolicies(Collection<LakeFormationTagPolicyDetails> lakeFormationTagPolicies) {
            this.lakeFormationTagPolicies = ListOfLakeFormationTagPoliciesCopier.copy(lakeFormationTagPolicies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lakeFormationTagPolicies(LakeFormationTagPolicyDetails ... lakeFormationTagPolicies) {
            this.lakeFormationTagPolicies(Arrays.asList(lakeFormationTagPolicies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lakeFormationTagPolicies(Consumer<LakeFormationTagPolicyDetails.Builder> ... lakeFormationTagPolicies) {
            this.lakeFormationTagPolicies(Stream.of(lakeFormationTagPolicies).map(c -> (LakeFormationTagPolicyDetails)((LakeFormationTagPolicyDetails.Builder)LakeFormationTagPolicyDetails.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<RedshiftDataShareDetails.Builder> getRedshiftDataShares() {
            List<RedshiftDataShareDetails.Builder> result = ListOfRedshiftDataSharesCopier.copyToBuilder(this.redshiftDataShares);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRedshiftDataShares(Collection<RedshiftDataShareDetails.BuilderImpl> redshiftDataShares) {
            this.redshiftDataShares = ListOfRedshiftDataSharesCopier.copyFromBuilder(redshiftDataShares);
        }

        @Override
        public final Builder redshiftDataShares(Collection<RedshiftDataShareDetails> redshiftDataShares) {
            this.redshiftDataShares = ListOfRedshiftDataSharesCopier.copy(redshiftDataShares);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder redshiftDataShares(RedshiftDataShareDetails ... redshiftDataShares) {
            this.redshiftDataShares(Arrays.asList(redshiftDataShares));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder redshiftDataShares(Consumer<RedshiftDataShareDetails.Builder> ... redshiftDataShares) {
            this.redshiftDataShares(Stream.of(redshiftDataShares).map(c -> (RedshiftDataShareDetails)((RedshiftDataShareDetails.Builder)RedshiftDataShareDetails.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<S3DataAccessDetails.Builder> getS3DataAccesses() {
            List<S3DataAccessDetails.Builder> result = ListOfS3DataAccessesCopier.copyToBuilder(this.s3DataAccesses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setS3DataAccesses(Collection<S3DataAccessDetails.BuilderImpl> s3DataAccesses) {
            this.s3DataAccesses = ListOfS3DataAccessesCopier.copyFromBuilder(s3DataAccesses);
        }

        @Override
        public final Builder s3DataAccesses(Collection<S3DataAccessDetails> s3DataAccesses) {
            this.s3DataAccesses = ListOfS3DataAccessesCopier.copy(s3DataAccesses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder s3DataAccesses(S3DataAccessDetails ... s3DataAccesses) {
            this.s3DataAccesses(Arrays.asList(s3DataAccesses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder s3DataAccesses(Consumer<S3DataAccessDetails.Builder> ... s3DataAccesses) {
            this.s3DataAccesses(Stream.of(s3DataAccesses).map(c -> (S3DataAccessDetails)((S3DataAccessDetails.Builder)S3DataAccessDetails.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ScopeDetails build() {
            return new ScopeDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ScopeDetails> {
        public Builder lakeFormationTagPolicies(Collection<LakeFormationTagPolicyDetails> var1);

        public Builder lakeFormationTagPolicies(LakeFormationTagPolicyDetails ... var1);

        public Builder lakeFormationTagPolicies(Consumer<LakeFormationTagPolicyDetails.Builder> ... var1);

        public Builder redshiftDataShares(Collection<RedshiftDataShareDetails> var1);

        public Builder redshiftDataShares(RedshiftDataShareDetails ... var1);

        public Builder redshiftDataShares(Consumer<RedshiftDataShareDetails.Builder> ... var1);

        public Builder s3DataAccesses(Collection<S3DataAccessDetails> var1);

        public Builder s3DataAccesses(S3DataAccessDetails ... var1);

        public Builder s3DataAccesses(Consumer<S3DataAccessDetails.Builder> ... var1);
    }
}

