/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dataexchange.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.dataexchange.model.DataExchangeResponse;
import software.amazon.awssdk.services.dataexchange.model.DataGrantAcceptanceState;
import software.amazon.awssdk.services.dataexchange.model.GrantDistributionScope;
import software.amazon.awssdk.services.dataexchange.model.MapOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetDataGrantResponse
extends DataExchangeResponse
implements ToCopyableBuilder<Builder, GetDataGrantResponse> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(GetDataGrantResponse.getter(GetDataGrantResponse::name)).setter(GetDataGrantResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> SENDER_PRINCIPAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SenderPrincipal").getter(GetDataGrantResponse.getter(GetDataGrantResponse::senderPrincipal)).setter(GetDataGrantResponse.setter(Builder::senderPrincipal)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SenderPrincipal").build()}).build();
    private static final SdkField<String> RECEIVER_PRINCIPAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReceiverPrincipal").getter(GetDataGrantResponse.getter(GetDataGrantResponse::receiverPrincipal)).setter(GetDataGrantResponse.setter(Builder::receiverPrincipal)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReceiverPrincipal").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(GetDataGrantResponse.getter(GetDataGrantResponse::description)).setter(GetDataGrantResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> ACCEPTANCE_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AcceptanceState").getter(GetDataGrantResponse.getter(GetDataGrantResponse::acceptanceStateAsString)).setter(GetDataGrantResponse.setter(Builder::acceptanceState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceptanceState").build()}).build();
    private static final SdkField<Instant> ACCEPTED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("AcceptedAt").getter(GetDataGrantResponse.getter(GetDataGrantResponse::acceptedAt)).setter(GetDataGrantResponse.setter(Builder::acceptedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceptedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> ENDS_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndsAt").getter(GetDataGrantResponse.getter(GetDataGrantResponse::endsAt)).setter(GetDataGrantResponse.setter(Builder::endsAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndsAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> GRANT_DISTRIBUTION_SCOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GrantDistributionScope").getter(GetDataGrantResponse.getter(GetDataGrantResponse::grantDistributionScopeAsString)).setter(GetDataGrantResponse.setter(Builder::grantDistributionScope)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GrantDistributionScope").build()}).build();
    private static final SdkField<String> DATA_SET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataSetId").getter(GetDataGrantResponse.getter(GetDataGrantResponse::dataSetId)).setter(GetDataGrantResponse.setter(Builder::dataSetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSetId").build()}).build();
    private static final SdkField<String> SOURCE_DATA_SET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceDataSetId").getter(GetDataGrantResponse.getter(GetDataGrantResponse::sourceDataSetId)).setter(GetDataGrantResponse.setter(Builder::sourceDataSetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceDataSetId").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(GetDataGrantResponse.getter(GetDataGrantResponse::id)).setter(GetDataGrantResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(GetDataGrantResponse.getter(GetDataGrantResponse::arn)).setter(GetDataGrantResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(GetDataGrantResponse.getter(GetDataGrantResponse::createdAt)).setter(GetDataGrantResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdatedAt").getter(GetDataGrantResponse.getter(GetDataGrantResponse::updatedAt)).setter(GetDataGrantResponse.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(GetDataGrantResponse.getter(GetDataGrantResponse::tags)).setter(GetDataGrantResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, SENDER_PRINCIPAL_FIELD, RECEIVER_PRINCIPAL_FIELD, DESCRIPTION_FIELD, ACCEPTANCE_STATE_FIELD, ACCEPTED_AT_FIELD, ENDS_AT_FIELD, GRANT_DISTRIBUTION_SCOPE_FIELD, DATA_SET_ID_FIELD, SOURCE_DATA_SET_ID_FIELD, ID_FIELD, ARN_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetDataGrantResponse.memberNameToFieldInitializer();
    private final String name;
    private final String senderPrincipal;
    private final String receiverPrincipal;
    private final String description;
    private final String acceptanceState;
    private final Instant acceptedAt;
    private final Instant endsAt;
    private final String grantDistributionScope;
    private final String dataSetId;
    private final String sourceDataSetId;
    private final String id;
    private final String arn;
    private final Instant createdAt;
    private final Instant updatedAt;
    private final Map<String, String> tags;

    private GetDataGrantResponse(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.senderPrincipal = builder.senderPrincipal;
        this.receiverPrincipal = builder.receiverPrincipal;
        this.description = builder.description;
        this.acceptanceState = builder.acceptanceState;
        this.acceptedAt = builder.acceptedAt;
        this.endsAt = builder.endsAt;
        this.grantDistributionScope = builder.grantDistributionScope;
        this.dataSetId = builder.dataSetId;
        this.sourceDataSetId = builder.sourceDataSetId;
        this.id = builder.id;
        this.arn = builder.arn;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.tags = builder.tags;
    }

    public final String name() {
        return this.name;
    }

    public final String senderPrincipal() {
        return this.senderPrincipal;
    }

    public final String receiverPrincipal() {
        return this.receiverPrincipal;
    }

    public final String description() {
        return this.description;
    }

    public final DataGrantAcceptanceState acceptanceState() {
        return DataGrantAcceptanceState.fromValue(this.acceptanceState);
    }

    public final String acceptanceStateAsString() {
        return this.acceptanceState;
    }

    public final Instant acceptedAt() {
        return this.acceptedAt;
    }

    public final Instant endsAt() {
        return this.endsAt;
    }

    public final GrantDistributionScope grantDistributionScope() {
        return GrantDistributionScope.fromValue(this.grantDistributionScope);
    }

    public final String grantDistributionScopeAsString() {
        return this.grantDistributionScope;
    }

    public final String dataSetId() {
        return this.dataSetId;
    }

    public final String sourceDataSetId() {
        return this.sourceDataSetId;
    }

    public final String id() {
        return this.id;
    }

    public final String arn() {
        return this.arn;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.senderPrincipal());
        hashCode = 31 * hashCode + Objects.hashCode(this.receiverPrincipal());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.acceptanceStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.acceptedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.endsAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.grantDistributionScopeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceDataSetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDataGrantResponse)) {
            return false;
        }
        GetDataGrantResponse other = (GetDataGrantResponse)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.senderPrincipal(), other.senderPrincipal()) && Objects.equals(this.receiverPrincipal(), other.receiverPrincipal()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.acceptanceStateAsString(), other.acceptanceStateAsString()) && Objects.equals(this.acceptedAt(), other.acceptedAt()) && Objects.equals(this.endsAt(), other.endsAt()) && Objects.equals(this.grantDistributionScopeAsString(), other.grantDistributionScopeAsString()) && Objects.equals(this.dataSetId(), other.dataSetId()) && Objects.equals(this.sourceDataSetId(), other.sourceDataSetId()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.updatedAt(), other.updatedAt()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"GetDataGrantResponse").add("Name", (Object)this.name()).add("SenderPrincipal", (Object)this.senderPrincipal()).add("ReceiverPrincipal", (Object)this.receiverPrincipal()).add("Description", (Object)this.description()).add("AcceptanceState", (Object)this.acceptanceStateAsString()).add("AcceptedAt", (Object)this.acceptedAt()).add("EndsAt", (Object)this.endsAt()).add("GrantDistributionScope", (Object)this.grantDistributionScopeAsString()).add("DataSetId", (Object)this.dataSetId()).add("SourceDataSetId", (Object)this.sourceDataSetId()).add("Id", (Object)this.id()).add("Arn", (Object)this.arn()).add("CreatedAt", (Object)this.createdAt()).add("UpdatedAt", (Object)this.updatedAt()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "SenderPrincipal": {
                return Optional.ofNullable(clazz.cast(this.senderPrincipal()));
            }
            case "ReceiverPrincipal": {
                return Optional.ofNullable(clazz.cast(this.receiverPrincipal()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "AcceptanceState": {
                return Optional.ofNullable(clazz.cast(this.acceptanceStateAsString()));
            }
            case "AcceptedAt": {
                return Optional.ofNullable(clazz.cast(this.acceptedAt()));
            }
            case "EndsAt": {
                return Optional.ofNullable(clazz.cast(this.endsAt()));
            }
            case "GrantDistributionScope": {
                return Optional.ofNullable(clazz.cast(this.grantDistributionScopeAsString()));
            }
            case "DataSetId": {
                return Optional.ofNullable(clazz.cast(this.dataSetId()));
            }
            case "SourceDataSetId": {
                return Optional.ofNullable(clazz.cast(this.sourceDataSetId()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "UpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", NAME_FIELD);
        map.put("SenderPrincipal", SENDER_PRINCIPAL_FIELD);
        map.put("ReceiverPrincipal", RECEIVER_PRINCIPAL_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("AcceptanceState", ACCEPTANCE_STATE_FIELD);
        map.put("AcceptedAt", ACCEPTED_AT_FIELD);
        map.put("EndsAt", ENDS_AT_FIELD);
        map.put("GrantDistributionScope", GRANT_DISTRIBUTION_SCOPE_FIELD);
        map.put("DataSetId", DATA_SET_ID_FIELD);
        map.put("SourceDataSetId", SOURCE_DATA_SET_ID_FIELD);
        map.put("Id", ID_FIELD);
        map.put("Arn", ARN_FIELD);
        map.put("CreatedAt", CREATED_AT_FIELD);
        map.put("UpdatedAt", UPDATED_AT_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetDataGrantResponse, T> g) {
        return obj -> g.apply((GetDataGrantResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataExchangeResponse.BuilderImpl
    implements Builder {
        private String name;
        private String senderPrincipal;
        private String receiverPrincipal;
        private String description;
        private String acceptanceState;
        private Instant acceptedAt;
        private Instant endsAt;
        private String grantDistributionScope;
        private String dataSetId;
        private String sourceDataSetId;
        private String id;
        private String arn;
        private Instant createdAt;
        private Instant updatedAt;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetDataGrantResponse model) {
            super(model);
            this.name(model.name);
            this.senderPrincipal(model.senderPrincipal);
            this.receiverPrincipal(model.receiverPrincipal);
            this.description(model.description);
            this.acceptanceState(model.acceptanceState);
            this.acceptedAt(model.acceptedAt);
            this.endsAt(model.endsAt);
            this.grantDistributionScope(model.grantDistributionScope);
            this.dataSetId(model.dataSetId);
            this.sourceDataSetId(model.sourceDataSetId);
            this.id(model.id);
            this.arn(model.arn);
            this.createdAt(model.createdAt);
            this.updatedAt(model.updatedAt);
            this.tags(model.tags);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getSenderPrincipal() {
            return this.senderPrincipal;
        }

        public final void setSenderPrincipal(String senderPrincipal) {
            this.senderPrincipal = senderPrincipal;
        }

        @Override
        public final Builder senderPrincipal(String senderPrincipal) {
            this.senderPrincipal = senderPrincipal;
            return this;
        }

        public final String getReceiverPrincipal() {
            return this.receiverPrincipal;
        }

        public final void setReceiverPrincipal(String receiverPrincipal) {
            this.receiverPrincipal = receiverPrincipal;
        }

        @Override
        public final Builder receiverPrincipal(String receiverPrincipal) {
            this.receiverPrincipal = receiverPrincipal;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getAcceptanceState() {
            return this.acceptanceState;
        }

        public final void setAcceptanceState(String acceptanceState) {
            this.acceptanceState = acceptanceState;
        }

        @Override
        public final Builder acceptanceState(String acceptanceState) {
            this.acceptanceState = acceptanceState;
            return this;
        }

        @Override
        public final Builder acceptanceState(DataGrantAcceptanceState acceptanceState) {
            this.acceptanceState(acceptanceState == null ? null : acceptanceState.toString());
            return this;
        }

        public final Instant getAcceptedAt() {
            return this.acceptedAt;
        }

        public final void setAcceptedAt(Instant acceptedAt) {
            this.acceptedAt = acceptedAt;
        }

        @Override
        public final Builder acceptedAt(Instant acceptedAt) {
            this.acceptedAt = acceptedAt;
            return this;
        }

        public final Instant getEndsAt() {
            return this.endsAt;
        }

        public final void setEndsAt(Instant endsAt) {
            this.endsAt = endsAt;
        }

        @Override
        public final Builder endsAt(Instant endsAt) {
            this.endsAt = endsAt;
            return this;
        }

        public final String getGrantDistributionScope() {
            return this.grantDistributionScope;
        }

        public final void setGrantDistributionScope(String grantDistributionScope) {
            this.grantDistributionScope = grantDistributionScope;
        }

        @Override
        public final Builder grantDistributionScope(String grantDistributionScope) {
            this.grantDistributionScope = grantDistributionScope;
            return this;
        }

        @Override
        public final Builder grantDistributionScope(GrantDistributionScope grantDistributionScope) {
            this.grantDistributionScope(grantDistributionScope == null ? null : grantDistributionScope.toString());
            return this;
        }

        public final String getDataSetId() {
            return this.dataSetId;
        }

        public final void setDataSetId(String dataSetId) {
            this.dataSetId = dataSetId;
        }

        @Override
        public final Builder dataSetId(String dataSetId) {
            this.dataSetId = dataSetId;
            return this;
        }

        public final String getSourceDataSetId() {
            return this.sourceDataSetId;
        }

        public final void setSourceDataSetId(String sourceDataSetId) {
            this.sourceDataSetId = sourceDataSetId;
        }

        @Override
        public final Builder sourceDataSetId(String sourceDataSetId) {
            this.sourceDataSetId = sourceDataSetId;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = MapOf__stringCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = MapOf__stringCopier.copy(tags);
            return this;
        }

        @Override
        public GetDataGrantResponse build() {
            return new GetDataGrantResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DataExchangeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetDataGrantResponse> {
        public Builder name(String var1);

        public Builder senderPrincipal(String var1);

        public Builder receiverPrincipal(String var1);

        public Builder description(String var1);

        public Builder acceptanceState(String var1);

        public Builder acceptanceState(DataGrantAcceptanceState var1);

        public Builder acceptedAt(Instant var1);

        public Builder endsAt(Instant var1);

        public Builder grantDistributionScope(String var1);

        public Builder grantDistributionScope(GrantDistributionScope var1);

        public Builder dataSetId(String var1);

        public Builder sourceDataSetId(String var1);

        public Builder id(String var1);

        public Builder arn(String var1);

        public Builder createdAt(Instant var1);

        public Builder updatedAt(Instant var1);

        public Builder tags(Map<String, String> var1);
    }
}

