/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dataexchange.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DataGrantAcceptanceState {
    PENDING_RECEIVER_ACCEPTANCE("PENDING_RECEIVER_ACCEPTANCE"),
    ACCEPTED("ACCEPTED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DataGrantAcceptanceState> VALUE_MAP;
    private final String value;

    private DataGrantAcceptanceState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DataGrantAcceptanceState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DataGrantAcceptanceState> knownValues() {
        EnumSet<DataGrantAcceptanceState> knownValues = EnumSet.allOf(DataGrantAcceptanceState.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DataGrantAcceptanceState.class, DataGrantAcceptanceState::toString);
    }
}

