/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dataexchange.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RevisionDestinationEntry
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RevisionDestinationEntry> {
    private static final SdkField<String> BUCKET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Bucket").getter(RevisionDestinationEntry.getter(RevisionDestinationEntry::bucket)).setter(RevisionDestinationEntry.setter(Builder::bucket)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Bucket").build()}).build();
    private static final SdkField<String> KEY_PATTERN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyPattern").getter(RevisionDestinationEntry.getter(RevisionDestinationEntry::keyPattern)).setter(RevisionDestinationEntry.setter(Builder::keyPattern)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyPattern").build()}).build();
    private static final SdkField<String> REVISION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RevisionId").getter(RevisionDestinationEntry.getter(RevisionDestinationEntry::revisionId)).setter(RevisionDestinationEntry.setter(Builder::revisionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RevisionId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_FIELD, KEY_PATTERN_FIELD, REVISION_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RevisionDestinationEntry.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String bucket;
    private final String keyPattern;
    private final String revisionId;

    private RevisionDestinationEntry(BuilderImpl builder) {
        this.bucket = builder.bucket;
        this.keyPattern = builder.keyPattern;
        this.revisionId = builder.revisionId;
    }

    public final String bucket() {
        return this.bucket;
    }

    public final String keyPattern() {
        return this.keyPattern;
    }

    public final String revisionId() {
        return this.revisionId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyPattern());
        hashCode = 31 * hashCode + Objects.hashCode(this.revisionId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RevisionDestinationEntry)) {
            return false;
        }
        RevisionDestinationEntry other = (RevisionDestinationEntry)obj;
        return Objects.equals(this.bucket(), other.bucket()) && Objects.equals(this.keyPattern(), other.keyPattern()) && Objects.equals(this.revisionId(), other.revisionId());
    }

    public final String toString() {
        return ToString.builder((String)"RevisionDestinationEntry").add("Bucket", (Object)this.bucket()).add("KeyPattern", (Object)this.keyPattern()).add("RevisionId", (Object)this.revisionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Bucket": {
                return Optional.ofNullable(clazz.cast(this.bucket()));
            }
            case "KeyPattern": {
                return Optional.ofNullable(clazz.cast(this.keyPattern()));
            }
            case "RevisionId": {
                return Optional.ofNullable(clazz.cast(this.revisionId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("Bucket", BUCKET_FIELD);
        map.put("KeyPattern", KEY_PATTERN_FIELD);
        map.put("RevisionId", REVISION_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RevisionDestinationEntry, T> g) {
        return obj -> g.apply((RevisionDestinationEntry)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String bucket;
        private String keyPattern;
        private String revisionId;

        private BuilderImpl() {
        }

        private BuilderImpl(RevisionDestinationEntry model) {
            this.bucket(model.bucket);
            this.keyPattern(model.keyPattern);
            this.revisionId(model.revisionId);
        }

        public final String getBucket() {
            return this.bucket;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final String getKeyPattern() {
            return this.keyPattern;
        }

        public final void setKeyPattern(String keyPattern) {
            this.keyPattern = keyPattern;
        }

        @Override
        public final Builder keyPattern(String keyPattern) {
            this.keyPattern = keyPattern;
            return this;
        }

        public final String getRevisionId() {
            return this.revisionId;
        }

        public final void setRevisionId(String revisionId) {
            this.revisionId = revisionId;
        }

        @Override
        public final Builder revisionId(String revisionId) {
            this.revisionId = revisionId;
            return this;
        }

        public RevisionDestinationEntry build() {
            return new RevisionDestinationEntry(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RevisionDestinationEntry> {
        public Builder bucket(String var1);

        public Builder keyPattern(String var1);

        public Builder revisionId(String var1);
    }
}

