/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dataexchange.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.dataexchange.model.DataExchangeResponse;
import software.amazon.awssdk.services.dataexchange.model.DataGrantSummaryEntry;
import software.amazon.awssdk.services.dataexchange.model.ListOfDataGrantSummaryEntryCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDataGrantsResponse
extends DataExchangeResponse
implements ToCopyableBuilder<Builder, ListDataGrantsResponse> {
    private static final SdkField<List<DataGrantSummaryEntry>> DATA_GRANT_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DataGrantSummaries").getter(ListDataGrantsResponse.getter(ListDataGrantsResponse::dataGrantSummaries)).setter(ListDataGrantsResponse.setter(Builder::dataGrantSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataGrantSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataGrantSummaryEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListDataGrantsResponse.getter(ListDataGrantsResponse::nextToken)).setter(ListDataGrantsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_GRANT_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private final List<DataGrantSummaryEntry> dataGrantSummaries;
    private final String nextToken;

    private ListDataGrantsResponse(BuilderImpl builder) {
        super(builder);
        this.dataGrantSummaries = builder.dataGrantSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasDataGrantSummaries() {
        return this.dataGrantSummaries != null && !(this.dataGrantSummaries instanceof SdkAutoConstructList);
    }

    public final List<DataGrantSummaryEntry> dataGrantSummaries() {
        return this.dataGrantSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDataGrantSummaries() ? this.dataGrantSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDataGrantsResponse)) {
            return false;
        }
        ListDataGrantsResponse other = (ListDataGrantsResponse)((Object)obj);
        return this.hasDataGrantSummaries() == other.hasDataGrantSummaries() && Objects.equals(this.dataGrantSummaries(), other.dataGrantSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListDataGrantsResponse").add("DataGrantSummaries", this.hasDataGrantSummaries() ? this.dataGrantSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DataGrantSummaries": {
                return Optional.ofNullable(clazz.cast(this.dataGrantSummaries()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDataGrantsResponse, T> g) {
        return obj -> g.apply((ListDataGrantsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataExchangeResponse.BuilderImpl
    implements Builder {
        private List<DataGrantSummaryEntry> dataGrantSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDataGrantsResponse model) {
            super(model);
            this.dataGrantSummaries(model.dataGrantSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<DataGrantSummaryEntry.Builder> getDataGrantSummaries() {
            List<DataGrantSummaryEntry.Builder> result = ListOfDataGrantSummaryEntryCopier.copyToBuilder(this.dataGrantSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDataGrantSummaries(Collection<DataGrantSummaryEntry.BuilderImpl> dataGrantSummaries) {
            this.dataGrantSummaries = ListOfDataGrantSummaryEntryCopier.copyFromBuilder(dataGrantSummaries);
        }

        @Override
        public final Builder dataGrantSummaries(Collection<DataGrantSummaryEntry> dataGrantSummaries) {
            this.dataGrantSummaries = ListOfDataGrantSummaryEntryCopier.copy(dataGrantSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataGrantSummaries(DataGrantSummaryEntry ... dataGrantSummaries) {
            this.dataGrantSummaries(Arrays.asList(dataGrantSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataGrantSummaries(Consumer<DataGrantSummaryEntry.Builder> ... dataGrantSummaries) {
            this.dataGrantSummaries(Stream.of(dataGrantSummaries).map(c -> (DataGrantSummaryEntry)((DataGrantSummaryEntry.Builder)DataGrantSummaryEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListDataGrantsResponse build() {
            return new ListDataGrantsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DataExchangeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDataGrantsResponse> {
        public Builder dataGrantSummaries(Collection<DataGrantSummaryEntry> var1);

        public Builder dataGrantSummaries(DataGrantSummaryEntry ... var1);

        public Builder dataGrantSummaries(Consumer<DataGrantSummaryEntry.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

